/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.dom.rewrite.imports;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.aspectj.org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportAdder;
import org.aspectj.org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportName;

final class ReorderingImportAdder
implements ImportAdder {
    private final Comparator<ImportName> importComparator;

    ReorderingImportAdder(Comparator<ImportName> importComparator) {
        this.importComparator = importComparator;
    }

    @Override
    public List<ImportName> addImports(Collection<ImportName> existingImports, Collection<ImportName> importsToAdd) {
        HashSet<ImportName> existingImportsSet = new HashSet<ImportName>(existingImports);
        ArrayList<ImportName> importsWithAdditions = new ArrayList<ImportName>(existingImports.size() + importsToAdd.size());
        importsWithAdditions.addAll(existingImports);
        for (ImportName importToAdd : importsToAdd) {
            if (existingImportsSet.contains(importToAdd)) continue;
            importsWithAdditions.add(importToAdd);
        }
        Collections.sort(importsWithAdditions, this.importComparator);
        return importsWithAdditions;
    }
}

