/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.provisional;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aspectj.org.eclipse.jdt.core.IClasspathAttribute;
import org.aspectj.org.eclipse.jdt.core.IClasspathEntry;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.IModuleDescription;
import org.aspectj.org.eclipse.jdt.core.IPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IModule;
import org.aspectj.org.eclipse.jdt.internal.core.AbstractModule;
import org.aspectj.org.eclipse.jdt.internal.core.JavaProject;
import org.aspectj.org.eclipse.jdt.internal.core.ModuleUpdater;
import org.aspectj.org.eclipse.jdt.internal.core.PackageFragmentRoot;

public class JavaModelAccess {
    private static final String BLANK = " ";
    private static final String COMMA = ",";
    private static final String OPTION_START = "--";
    private static final String ADD_MODULES = "--add-modules ";
    private static final String LIMIT_MODULES = "--limit-modules ";

    public static IPackageFragmentRoot[] getUnfilteredPackageFragmentRoots(IJavaProject javaProject, IClasspathEntry entry) {
        try {
            JavaProject internalProject = (JavaProject)javaProject;
            IClasspathEntry[] resolvedEntries = internalProject.resolveClasspath(new IClasspathEntry[]{entry});
            return internalProject.computePackageFragmentRoots(resolvedEntries, false, false, null);
        }
        catch (JavaModelException e) {
            return new IPackageFragmentRoot[0];
        }
    }

    public static String[] getRequiredModules(IModuleDescription module) throws JavaModelException {
        IModule.IModuleReference[] references = ((AbstractModule)module).getRequiredModules();
        return (String[])Arrays.stream(references).map(ref -> String.valueOf(ref.name())).toArray(String[]::new);
    }

    public static List<String> defaultRootModules(Iterable<IPackageFragmentRoot> allSystemRoots) {
        return JavaProject.defaultRootModules(allSystemRoots);
    }

    public static IModuleDescription getAutomaticModuleDescription(IJavaElement element) throws JavaModelException, IllegalArgumentException {
        switch (element.getElementType()) {
            case 2: {
                return ((JavaProject)element).getAutomaticModuleDescription();
            }
            case 3: {
                return ((PackageFragmentRoot)element).getAutomaticModuleDescription();
            }
        }
        throw new IllegalArgumentException("Illegal kind of java element: " + element.getElementType());
    }

    public static String getModuleCLIOptions(IJavaProject project, IClasspathEntry systemLibrary) throws JavaModelException {
        StringBuilder buf = new StringBuilder();
        IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            IClasspathAttribute[] iClasspathAttributeArray = classpathEntry.getExtraAttributes();
            int n3 = iClasspathAttributeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String optName;
                IClasspathAttribute classpathAttribute = iClasspathAttributeArray[n4];
                switch (optName = classpathAttribute.getName()) {
                    case "add-exports": 
                    case "add-reads": {
                        String[] stringArray = classpathAttribute.getValue().split(COMMA);
                        int n5 = stringArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            String value = stringArray[n6];
                            buf.append(OPTION_START).append(optName).append(BLANK).append(value).append(BLANK);
                            ++n6;
                        }
                        break;
                    }
                    case "limit-modules": {
                        JavaModelAccess.addLimitModules(buf, project, systemLibrary, classpathAttribute.getValue());
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return buf.toString().trim();
    }

    private static void addLimitModules(StringBuilder buf, IJavaProject prj, IClasspathEntry systemLibrary, String value) throws JavaModelException {
        boolean isUnnamed;
        Object[] modules = value.split(COMMA);
        boolean bl = isUnnamed = prj.getModuleDescription() == null;
        if (isUnnamed) {
            HashSet<Object> selected = new HashSet<Object>(Arrays.asList(modules));
            List<IPackageFragmentRoot> allSystemRoots = Arrays.asList(JavaModelAccess.getUnfilteredPackageFragmentRoots(prj, systemLibrary));
            HashSet<String> defaultModules = new HashSet<String>(JavaProject.defaultRootModules(allSystemRoots));
            HashSet<String> limit = new HashSet<String>(defaultModules);
            if (limit.retainAll(selected)) {
                if (limit.isEmpty()) {
                    throw new IllegalArgumentException("Cannot hide all modules, at least java.base is required");
                }
                buf.append(LIMIT_MODULES).append(JavaModelAccess.joinedSortedList(limit)).append(BLANK);
            }
            HashSet<Object> add = new HashSet<Object>(selected);
            add.removeAll(defaultModules);
            if (!add.isEmpty()) {
                buf.append(ADD_MODULES).append(JavaModelAccess.joinedSortedList(add)).append(BLANK);
            }
        } else {
            Arrays.sort(modules);
            buf.append(LIMIT_MODULES).append(String.join((CharSequence)COMMA, (CharSequence[])modules)).append(BLANK);
        }
    }

    private static String joinedSortedList(Collection<String> list) {
        Object[] limitArray = list.toArray(new String[list.size()]);
        Arrays.sort(limitArray);
        return String.join((CharSequence)COMMA, (CharSequence[])limitArray);
    }

    public static Set<String> determineModulesOfProjectsWithNonEmptyClasspath(IJavaProject project) throws JavaModelException {
        if (project instanceof JavaProject) {
            JavaProject javaProject = (JavaProject)project;
            return ModuleUpdater.determineModulesOfProjectsWithNonEmptyClasspath(javaProject, javaProject.getExpandedClasspath());
        }
        return Collections.emptySet();
    }

    public static boolean isTestCode(IType type) throws JavaModelException {
        JavaProject javaProject;
        IClasspathEntry entry;
        IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)type.getPackageFragment().getParent();
        return !(packageFragmentRoot.getJavaProject() instanceof JavaProject) || (entry = (javaProject = (JavaProject)packageFragmentRoot.getJavaProject()).getClasspathEntryFor(packageFragmentRoot.getPath())) == null || entry.isTest();
    }
}

