/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class ToStringSorter<T> {
    private final Function<T, String> toString;
    List<Pair<T>> sortedObjects;

    public ToStringSorter(Function<T, String> toString) {
        this.toString = toString;
    }

    public void sort(Collection<T> unSorted) {
        int size = unSorted.size();
        this.sortedObjects = new ArrayList<Pair<T>>(size);
        unSorted.forEach(k -> {
            boolean bl = this.sortedObjects.add(new Pair<Object>(k, this.toString.apply(k)));
        });
        Collections.sort(this.sortedObjects);
    }

    static class Pair<T>
    implements Comparable<Pair<T>> {
        final T object;
        final String string;

        public Pair(T k, String s) {
            this.object = k;
            this.string = s;
        }

        @Override
        public int compareTo(Pair<T> other) {
            return this.string.compareTo(other.string);
        }
    }
}

