/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.java;

import java.util.List;
import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.NdNode;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldInt;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldList;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.StructDef;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeParameter;
import org.aspectj.org.eclipse.jdt.internal.core.util.CharArrayBuffer;
import org.eclipse.core.runtime.IAdaptable;

public abstract class NdBinding
extends NdNode
implements IAdaptable {
    public static final FieldInt MODIFIERS;
    public static final FieldList<NdTypeParameter> TYPE_PARAMETERS;
    public static final StructDef<NdBinding> type;

    static {
        type = StructDef.create(NdBinding.class, NdNode.type);
        MODIFIERS = type.addInt();
        TYPE_PARAMETERS = FieldList.create(type, NdTypeParameter.type);
        type.done();
    }

    public NdBinding(Nd nd, long address) {
        super(nd, address);
    }

    public NdBinding(Nd nd) {
        super(nd);
    }

    public boolean hasModifier(int toTest) {
        return (MODIFIERS.get(this.getNd(), this.address) & toTest) != 0;
    }

    public void setModifiers(int toSet) {
        MODIFIERS.put(this.getNd(), this.address, toSet);
    }

    public int getModifiers() {
        return MODIFIERS.get(this.getNd(), this.address);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(NdBinding.class)) {
            return this;
        }
        return null;
    }

    public final int getBindingConstant() {
        return this.getNodeType();
    }

    public char[][] getTypeParameterSignatures() {
        List<NdTypeParameter> parameters = this.getTypeParameters();
        char[][] result = new char[parameters.size()][];
        int idx = 0;
        for (NdTypeParameter next : parameters) {
            char[] nextContents = this.getSignatureFor(next);
            result[idx] = nextContents;
            ++idx;
        }
        return result;
    }

    private char[] getSignatureFor(NdTypeParameter next) {
        CharArrayBuffer nextArray = new CharArrayBuffer();
        next.getSignature(nextArray);
        char[] nextContents = nextArray.getContents();
        return nextContents;
    }

    public List<NdTypeParameter> getTypeParameters() {
        return TYPE_PARAMETERS.asList(this.getNd(), this.address);
    }

    public NdTypeParameter createTypeParameter() {
        return TYPE_PARAMETERS.append(this.getNd(), this.getAddress());
    }

    public void allocateTypeParameters(int elements) {
        TYPE_PARAMETERS.allocate(this.getNd(), this.getAddress(), elements);
    }
}

