/*******************************************************************************
 * Copyright (c) 2000, 2022 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.aspectj.org.eclipse.jdt.internal.compiler.parser;

/**
 * IMPORTANT NOTE: These constants are dedicated to the internal Scanner implementation.
 * It is mirrored in org.eclipse.jdt.core.compiler public package where it is API.
 * The mirror implementation is using the backward compatible ITerminalSymbols constant
 * definitions (stable with 2.0), whereas the internal implementation uses TerminalTokens
 * which constant values reflect the latest parser generation state.
 */
/**
 * Maps each terminal symbol in the java-grammar into a unique integer.
 * This integer is used to represent the terminal when computing a parsing action.
 *
 * Disclaimer : These constant values are generated automatically using a Java
 * grammar, therefore their actual values are subject to change if new keywords
 * were added to the language (for instance, 'assert' is a keyword in 1.4).
 */
public interface TerminalTokens {

	// special tokens not part of grammar - not autogenerated
	int TokenNameNotAToken = 0,
							TokenNameWHITESPACE = 1000,
							TokenNameCOMMENT_LINE = 1001,
							TokenNameCOMMENT_BLOCK = 1002,
							TokenNameCOMMENT_JAVADOC = 1003,
							TokenNameSingleQuoteStringLiteral = 1004;

	static boolean isRestrictedKeyword(int tokenType) {
		return switch (tokenType) {
			case TokenNameRestrictedIdentifierYield, TokenNameRestrictedIdentifierrecord,TokenNameRestrictedIdentifierWhen,
					TokenNameRestrictedIdentifiersealed, TokenNameRestrictedIdentifierpermits -> true;
			default -> false;
		};
	}

	static int getRestrictedKeyword(char [] text) {
		if (text != null) {
			int len = text.length;
			if (len == 4 && text[0] == 'w' ||
				len == 5 && text[0] == 'y' ||
				len == 6 && (text[0] == 'r' || text[0] == 's') ||
				len == 7 && text[0] == 'p') {
				return getRestrictedKeyword(new String(text));
			}
		}
		return TokenNameNotAToken;
	}

	static int getRestrictedKeyword(String text) {
		return switch (text) {
			case "yield"   -> TokenNameRestrictedIdentifierYield;   //$NON-NLS-1$
			case "record"  -> TokenNameRestrictedIdentifierrecord;  //$NON-NLS-1$
			case "when"    -> TokenNameRestrictedIdentifierWhen;    //$NON-NLS-1$
			case "sealed"  -> TokenNameRestrictedIdentifiersealed;  //$NON-NLS-1$
			case "permits" -> TokenNameRestrictedIdentifierpermits; //$NON-NLS-1$
			default        -> TokenNameNotAToken;
		};
	}

	// AspectJ: Tokens taken from javasym.java, generated by jikespg according to
	// https://www.eclipse.org/jdt/core/howto/generate%20parser/generateParser.html
	//
	// TODO Every time when updating tokens, make sure to rename
	//   - TokenName$eof -> TokenNameEOF
	//   - TokenName$error -> TokenNameERROR
	//   - TokenNamenon-sealed -> TokenNamenon_sealed
	int
		TokenNameIdentifier = 16,
		TokenNameabstract = 47,
		TokenNameassert = 87,
		TokenNameboolean = 120,
		TokenNamebreak = 88,
		TokenNamebyte = 121,
		TokenNamecase = 96,
		TokenNamecatch = 99,
		TokenNamechar = 122,
		TokenNameclass = 76,
		TokenNamecontinue = 89,
		TokenNameconst = 145,
		TokenNamedefault = 97,
		TokenNamedo = 90,
		TokenNamedouble = 123,
		TokenNameelse = 105,
		TokenNameenum = 83,
		TokenNameextends = 98,
		TokenNamefalse = 63,
		TokenNamefinal = 48,
		TokenNamefinally = 102,
		TokenNamefloat = 124,
		TokenNamefor = 91,
		TokenNamegoto = 146,
		TokenNameif = 92,
		TokenNameimplements = 107,
		TokenNameimport = 100,
		TokenNameinstanceof = 14,
		TokenNameint = 125,
		TokenNameinterface = 80,
		TokenNamelong = 126,
		TokenNamenative = 49,
		TokenNamenew = 44,
		TokenNamenon_sealed = 50,
		TokenNamenull = 64,
		TokenNamepackage = 95,
		TokenNameprivate = 51,
		TokenNameprotected = 52,
		TokenNamepublic = 53,
		TokenNamereturn = 93,
		TokenNameshort = 127,
		TokenNamestatic = 43,
		TokenNamestrictfp = 54,
		TokenNamesuper = 55,
		TokenNameswitch = 72,
		TokenNamesynchronized = 45,
		TokenNamethis = 56,
		TokenNamethrow = 85,
		TokenNamethrows = 103,
		TokenNametransient = 57,
		TokenNametrue = 65,
		TokenNametry = 94,
		TokenNamevoid = 128,
		TokenNamevolatile = 58,
		TokenNamewhile = 86,
		TokenNamemodule = 129,
		TokenNameopen = 132,
		TokenNamerequires = 133,
		TokenNametransitive = 139,
		TokenNameexports = 134,
		TokenNameopens = 135,
		TokenNameto = 143,
		TokenNameuses = 136,
		TokenNameprovides = 137,
		TokenNamewith = 144,
		TokenNameaspect = 25,
		TokenNamepointcut = 29,
		TokenNamearound = 34,
		TokenNamebefore = 30,
		TokenNameafter = 31,
		TokenNamedeclare = 32,
		TokenNameprivileged = 27,
		TokenNameIntegerLiteral = 66,
		TokenNameLongLiteral = 67,
		TokenNameFloatingPointLiteral = 68,
		TokenNameDoubleLiteral = 69,
		TokenNameCharacterLiteral = 70,
		TokenNameStringLiteral = 60,
		TokenNameTextBlock = 61,
		TokenNameStringTemplate = 130,
		TokenNameTextBlockTemplate = 131,
		TokenNamePLUS_PLUS = 3,
		TokenNameMINUS_MINUS = 4,
		TokenNameEQUAL_EQUAL = 23,
		TokenNameLESS_EQUAL = 17,
		TokenNameGREATER_EQUAL = 18,
		TokenNameNOT_EQUAL = 20,
		TokenNameLEFT_SHIFT = 21,
		TokenNameRIGHT_SHIFT = 12,
		TokenNameUNSIGNED_RIGHT_SHIFT = 15,
		TokenNamePLUS_EQUAL = 108,
		TokenNameMINUS_EQUAL = 109,
		TokenNameMULTIPLY_EQUAL = 110,
		TokenNameDIVIDE_EQUAL = 111,
		TokenNameAND_EQUAL = 112,
		TokenNameOR_EQUAL = 113,
		TokenNameXOR_EQUAL = 114,
		TokenNameREMAINDER_EQUAL = 115,
		TokenNameLEFT_SHIFT_EQUAL = 116,
		TokenNameRIGHT_SHIFT_EQUAL = 117,
		TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL = 118,
		TokenNameOR_OR = 38,
		TokenNameAND_AND = 37,
		TokenNamePLUS = 2,
		TokenNameMINUS = 6,
		TokenNameNOT = 74,
		TokenNameREMAINDER = 10,
		TokenNameXOR = 33,
		TokenNameAND = 22,
		TokenNameMULTIPLY = 8,
		TokenNameOR = 35,
		TokenNameTWIDDLE = 77,
		TokenNameDIVIDE = 11,
		TokenNameGREATER = 13,
		TokenNameLESS = 7,
		TokenNameLPAREN = 19,
		TokenNameRPAREN = 24,
		TokenNameLBRACE = 62,
		TokenNameRBRACE = 41,
		TokenNameLBRACKET = 5,
		TokenNameRBRACKET = 75,
		TokenNameSEMICOLON = 28,
		TokenNameQUESTION = 36,
		TokenNameCOLON = 71,
		TokenNameCOMMA = 39,
		TokenNameDOT = 1,
		TokenNameEQUAL = 79,
		TokenNameAT = 40,
		TokenNameELLIPSIS = 104,
		TokenNameARROW = 119,
		TokenNameCOLON_COLON = 9,
		TokenNameBeginLambda = 73,
		TokenNameBeginIntersectionCast = 78,
		TokenNameBeginTypeArguments = 101,
		TokenNameElidedSemicolonAndRightBrace = 81,
		TokenNameAT308 = 26,
		TokenNameAT308DOTDOTDOT = 140,
		TokenNameBeginCaseExpr = 82,
		TokenNameRestrictedIdentifierYield = 106,
		TokenNameRestrictedIdentifierrecord = 84,
		TokenNameRestrictedIdentifiersealed = 46,
		TokenNameRestrictedIdentifierpermits = 138,
		TokenNameBeginCaseElement = 141,
		TokenNameRestrictedIdentifierWhen = 142,
		TokenNameUNDERSCORE = 42,
		TokenNameEOF = 59,
		TokenNameERROR = 147;
}
