/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.aspectj.org.eclipse.jdt.core.search.IJavaSearchScope;
import org.aspectj.org.eclipse.jdt.core.search.SearchParticipant;
import org.aspectj.org.eclipse.jdt.core.search.SearchPattern;
import org.aspectj.org.eclipse.jdt.internal.core.index.Index;
import org.aspectj.org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.aspectj.org.eclipse.jdt.internal.core.search.PatternSearchJob;
import org.eclipse.core.runtime.IProgressMonitor;

public class SubTypeSearchJob
extends PatternSearchJob {
    Set<Index> indexes = Collections.synchronizedSet(new LinkedHashSet(5));

    public SubTypeSearchJob(SearchPattern pattern, SearchParticipant participant, IJavaSearchScope scope, IndexQueryRequestor requestor) {
        super(pattern, participant, scope, requestor);
    }

    public void finished() {
        this.indexes.forEach(Index::stopQuery);
    }

    @Override
    public Index[] getIndexes(IProgressMonitor progressMonitor) {
        if (this.indexes.isEmpty()) {
            return super.getIndexes(progressMonitor);
        }
        this.areIndexesReady = true;
        return this.indexes.toArray(new Index[0]);
    }

    @Override
    public boolean search(Index index, IndexQueryRequestor queryRequestor, IProgressMonitor progressMonitor) {
        if (index == null) {
            return true;
        }
        if (this.indexes.add(index)) {
            index.startQuery();
        }
        return super.search(index, queryRequestor, progressMonitor);
    }
}

