/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.swing.StructureTree;
import org.aspectj.ajde.ui.swing.SwingTreeViewNode;
import org.aspectj.asm.IProgramElement;

class BrowserViewTreeListener
implements TreeSelectionListener,
MouseListener {
    private StructureTree tree = null;

    public BrowserViewTreeListener(StructureTree tree) {
        this.tree = tree;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.singleClickNavigation(e);
        this.maybeShowPopup(e);
    }

    public void singleClickNavigation(MouseEvent e) {
        IProgramElement currNode;
        SwingTreeViewNode treeNode = (SwingTreeViewNode)this.tree.getLastSelectedPathComponent();
        if (treeNode == null || e.isControlDown() || e.isShiftDown() || e.getModifiers() == 4 || (currNode = (IProgramElement)treeNode.getUserObject()) == null || e.isControlDown() || e.isShiftDown() || e.getModifiers() != 4) {
            // empty if block
        }
    }

    public void doubleClickNavigation(MouseEvent e) {
        IProgramElement currNode;
        SwingTreeViewNode treeNode = (SwingTreeViewNode)this.tree.getLastSelectedPathComponent();
        if (treeNode == null || (currNode = (IProgramElement)treeNode.getUserObject()) == null || e.isControlDown() || e.isShiftDown() || e.getModifiers() != 4) {
            // empty if block
        }
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.getModifiers() == 4 && this.tree.getSelectionCount() > 0) {
            final ArrayList signatures = new ArrayList();
            JPopupMenu popup = new JPopupMenu();
            JMenuItem showSourcesItem = new JMenuItem("Display sources", Ajde.getDefault().getIconRegistry().getStructureSwingIcon(IProgramElement.Kind.CODE));
            showSourcesItem.setFont(new Font("Dialog", 0, 11));
            showSourcesItem.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            popup.add(showSourcesItem);
            popup.addSeparator();
            JMenuItem generatePCD = new JMenuItem("Pointcut Wizard (alpha)...", Ajde.getDefault().getIconRegistry().getStructureSwingIcon(IProgramElement.Kind.POINTCUT));
            generatePCD.setFont(new Font("Dialog", 0, 11));
            generatePCD.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Ajde.getDefault().getViewManager().extractAndInsertSignatures(signatures, true);
                }
            });
            popup.add(generatePCD);
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

