/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.util;

import java.util.Arrays;

final class CharArray
implements Comparable<CharArray> {
    private final char[] key;

    public CharArray(char[] key) {
        this.key = key;
    }

    @Override
    public int compareTo(CharArray o) {
        return CharArray.compare(this.key, o.key);
    }

    public char[] getKey() {
        return this.key;
    }

    private static int compare(char[] a, char[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null || b == null) {
            return a == null ? -1 : 1;
        }
        int shortestLenght = Math.min(a.length, b.length);
        int i = 0;
        while (i < shortestLenght) {
            if (a[i] != b[i]) {
                return Character.compare(a[i], b[i]);
            }
            ++i;
        }
        return a.length - b.length;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharArray)) {
            return false;
        }
        CharArray other = (CharArray)obj;
        return Arrays.equals(this.key, other.key);
    }

    public int hashCode() {
        return Arrays.hashCode(this.key);
    }

    public String toString() {
        return Arrays.toString(this.key);
    }
}

