/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import java.util.HashMap;
import org.aspectj.org.eclipse.jdt.core.IAnnotation;
import org.aspectj.org.eclipse.jdt.core.IBuffer;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.ILocalVariable;
import org.aspectj.org.eclipse.jdt.core.IMember;
import org.aspectj.org.eclipse.jdt.core.IMemberValuePair;
import org.aspectj.org.eclipse.jdt.core.IMethod;
import org.aspectj.org.eclipse.jdt.core.IOpenable;
import org.aspectj.org.eclipse.jdt.core.ISourceRange;
import org.aspectj.org.eclipse.jdt.core.ITypeRoot;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.core.SourceRange;
import org.aspectj.org.eclipse.jdt.core.WorkingCopyOwner;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Literal;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.RecoveryScanner;
import org.aspectj.org.eclipse.jdt.internal.core.Annotation;
import org.aspectj.org.eclipse.jdt.internal.core.BinaryMethod;
import org.aspectj.org.eclipse.jdt.internal.core.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.Member;
import org.aspectj.org.eclipse.jdt.internal.core.MemberValuePair;
import org.aspectj.org.eclipse.jdt.internal.core.SourceMapper;
import org.aspectj.org.eclipse.jdt.internal.core.SourceRefElement;
import org.aspectj.org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class LocalVariable
extends SourceRefElement
implements ILocalVariable {
    public static final ILocalVariable[] NO_LOCAL_VARIABLES = new ILocalVariable[0];
    String name;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int nameStart;
    public int nameEnd;
    String typeSignature;
    public IAnnotation[] annotations;
    private int flags;
    private boolean isParameter;
    public IAnnotation[][] annotationsOnDimensions;

    public LocalVariable(JavaElement parent, String name, int declarationSourceStart, int declarationSourceEnd, int nameStart, int nameEnd, String typeSignature, org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation[] astAnnotations, int flags, boolean isParameter) {
        super(parent);
        this.name = name;
        this.declarationSourceStart = declarationSourceStart;
        this.declarationSourceEnd = declarationSourceEnd;
        this.nameStart = nameStart;
        this.nameEnd = nameEnd;
        this.typeSignature = typeSignature;
        this.annotations = this.getAnnotations(astAnnotations);
        this.flags = flags;
        this.isParameter = isParameter;
    }

    public LocalVariable(JavaElement parent, String name, int declarationSourceStart, int declarationSourceEnd, int nameStart, int nameEnd, String typeSignature, org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation[] astAnnotations, int flags, boolean isParameter, org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation[][] astAnnotationsOnDimensions) {
        this(parent, name, declarationSourceStart, declarationSourceEnd, nameStart, nameEnd, typeSignature, astAnnotations, flags, isParameter);
        int noOfDimensions;
        int n = noOfDimensions = astAnnotationsOnDimensions == null ? 0 : astAnnotationsOnDimensions.length;
        if (noOfDimensions > 0) {
            this.annotationsOnDimensions = new IAnnotation[noOfDimensions][];
            int i = 0;
            while (i < noOfDimensions) {
                this.annotationsOnDimensions[i] = this.getAnnotations(astAnnotationsOnDimensions[i]);
                ++i;
            }
        }
    }

    @Override
    protected void closing(Object info) {
    }

    @Override
    protected Object createElementInfo() {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LocalVariable)) {
            return false;
        }
        LocalVariable other = (LocalVariable)o;
        return this.declarationSourceStart == other.declarationSourceStart && this.declarationSourceEnd == other.declarationSourceEnd && this.nameStart == other.nameStart && this.nameEnd == other.nameEnd && super.equals(o);
    }

    @Override
    public boolean exists() {
        return this.getParent().exists();
    }

    @Override
    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor pm) {
    }

    @Override
    public IAnnotation getAnnotation(String annotationName) {
        int i = 0;
        int length = this.annotations.length;
        while (i < length) {
            IAnnotation annotation = this.annotations[i];
            if (annotation.getElementName().equals(annotationName)) {
                return annotation;
            }
            ++i;
        }
        return super.getAnnotation(annotationName);
    }

    @Override
    public IAnnotation[] getAnnotations() throws JavaModelException {
        return this.annotations;
    }

    private IAnnotation[] getAnnotations(org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation[] astAnnotations) {
        int length;
        if (astAnnotations == null || (length = astAnnotations.length) == 0) {
            return Annotation.NO_ANNOTATIONS;
        }
        IAnnotation[] result = new IAnnotation[length];
        int i = 0;
        while (i < length) {
            result[i] = this.getAnnotation(astAnnotations[i], this);
            ++i;
        }
        return result;
    }

    private IAnnotation getAnnotation(org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation annotation, JavaElement parentElement) {
        IMemberValuePair[] memberValuePairs;
        int length;
        int typeStart = annotation.type.sourceStart();
        int typeEnd = annotation.type.sourceEnd();
        int sourceStart = annotation.sourceStart();
        int sourceEnd = annotation.declarationSourceEnd;
        String annotationName = new String(CharOperation.concatWith(annotation.type.getTypeName(), '.'));
        class LocalVarAnnotation
        extends Annotation {
            IMemberValuePair[] memberValuePairs;
            private final /* synthetic */ int val$typeStart;
            private final /* synthetic */ int val$typeEnd;
            private final /* synthetic */ int val$sourceStart;
            private final /* synthetic */ int val$sourceEnd;

            public LocalVarAnnotation(JavaElement localVar, String elementName, int n, int n2, int n3, int n4) {
                this.val$typeStart = n;
                this.val$typeEnd = n2;
                this.val$sourceStart = n3;
                this.val$sourceEnd = n4;
                super(localVar, elementName);
            }

            @Override
            public IMemberValuePair[] getMemberValuePairs() throws JavaModelException {
                return this.memberValuePairs;
            }

            @Override
            public ISourceRange getNameRange() throws JavaModelException {
                return new SourceRange(this.val$typeStart, this.val$typeEnd - this.val$typeStart + 1);
            }

            @Override
            public ISourceRange getSourceRange() throws JavaModelException {
                return new SourceRange(this.val$sourceStart, this.val$sourceEnd - this.val$sourceStart + 1);
            }

            @Override
            public boolean exists() {
                return this.getParent().exists();
            }
        }
        LocalVarAnnotation localVarAnnotation = new LocalVarAnnotation(parentElement, annotationName, typeStart, typeEnd, sourceStart, sourceEnd);
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.MemberValuePair[] astMemberValuePairs = annotation.memberValuePairs();
        if (astMemberValuePairs == null || (length = astMemberValuePairs.length) == 0) {
            memberValuePairs = Annotation.NO_MEMBER_VALUE_PAIRS;
        } else {
            memberValuePairs = new IMemberValuePair[length];
            int i = 0;
            while (i < length) {
                org.aspectj.org.eclipse.jdt.internal.compiler.ast.MemberValuePair astMemberValuePair = astMemberValuePairs[i];
                MemberValuePair memberValuePair = new MemberValuePair(new String(astMemberValuePair.name));
                memberValuePair.value = this.getAnnotationMemberValue(memberValuePair, astMemberValuePair.value, localVarAnnotation);
                memberValuePairs[i] = memberValuePair;
                ++i;
            }
        }
        localVarAnnotation.memberValuePairs = memberValuePairs;
        return localVarAnnotation;
    }

    private Object getAnnotationMemberValue(MemberValuePair memberValuePair, Expression expression, JavaElement parentElement) {
        if (expression instanceof NullLiteral) {
            return null;
        }
        if (expression instanceof Literal) {
            ((Literal)expression).computeConstant();
            return Util.getAnnotationMemberValue(memberValuePair, expression.constant);
        }
        if (expression instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation) {
            memberValuePair.valueKind = 10;
            return this.getAnnotation((org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation)expression, parentElement);
        }
        if (expression instanceof ClassLiteralAccess) {
            ClassLiteralAccess classLiteral = (ClassLiteralAccess)expression;
            char[] typeName = CharOperation.concatWith(classLiteral.type.getTypeName(), '.');
            memberValuePair.valueKind = 11;
            return new String(typeName);
        }
        if (expression instanceof QualifiedNameReference) {
            char[] qualifiedName = CharOperation.concatWith(((QualifiedNameReference)expression).tokens, '.');
            memberValuePair.valueKind = 12;
            return new String(qualifiedName);
        }
        if (expression instanceof SingleNameReference) {
            char[] simpleName = ((SingleNameReference)expression).token;
            if (simpleName == RecoveryScanner.FAKE_IDENTIFIER) {
                memberValuePair.valueKind = 14;
                return null;
            }
            memberValuePair.valueKind = 13;
            return new String(simpleName);
        }
        if (expression instanceof ArrayInitializer) {
            memberValuePair.valueKind = -1;
            Expression[] expressions = ((ArrayInitializer)expression).expressions;
            int length = expressions == null ? 0 : expressions.length;
            Object[] values = new Object[length];
            int i = 0;
            while (i < length) {
                int previousValueKind = memberValuePair.valueKind;
                Object value = this.getAnnotationMemberValue(memberValuePair, expressions[i], parentElement);
                if (previousValueKind != -1 && memberValuePair.valueKind != previousValueKind) {
                    memberValuePair.valueKind = 14;
                }
                values[i] = value;
                ++i;
            }
            if (memberValuePair.valueKind == -1) {
                memberValuePair.valueKind = 14;
            }
            return values;
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            if ((unaryExpression.bits & 0x3F00) >> 8 == 13 && unaryExpression.expression instanceof Literal) {
                Literal subExpression = (Literal)unaryExpression.expression;
                subExpression.computeConstant();
                return Util.getNegativeAnnotationMemberValue(memberValuePair, subExpression.constant);
            }
            memberValuePair.valueKind = 14;
            return null;
        }
        memberValuePair.valueKind = 14;
        return null;
    }

    @Override
    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, owner);
            }
        }
        return this;
    }

    @Override
    protected void getHandleMemento(StringBuffer buff) {
        this.getHandleMemento(buff, true);
    }

    protected void getHandleMemento(StringBuffer buff, boolean memoizeParent) {
        if (memoizeParent) {
            this.getParent().getHandleMemento(buff);
        }
        buff.append(this.getHandleMementoDelimiter());
        buff.append(this.name);
        buff.append('!');
        buff.append(this.declarationSourceStart);
        buff.append('!');
        buff.append(this.declarationSourceEnd);
        buff.append('!');
        buff.append(this.nameStart);
        buff.append('!');
        buff.append(this.nameEnd);
        buff.append('!');
        this.escapeMementoName(buff, this.typeSignature);
        buff.append('!');
        buff.append(this.flags);
        buff.append('!');
        buff.append(this.isParameter);
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '@';
    }

    @Override
    public IResource getCorrespondingResource() {
        return null;
    }

    @Override
    public IMember getDeclaringMember() {
        return (IMember)((Object)this.getParent());
    }

    @Override
    public String getElementName() {
        return this.name;
    }

    @Override
    public int getElementType() {
        return 14;
    }

    @Override
    public int getFlags() {
        if (this.flags == -1) {
            SourceMapper mapper = this.getSourceMapper();
            if (mapper != null) {
                try {
                    ClassFile classFile = this.getClassFile();
                    if (classFile != null) {
                        classFile.getBuffer();
                        return mapper.getFlags(this);
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            return 0;
        }
        return this.flags & 0xFFFF;
    }

    @Override
    public ClassFile getClassFile() {
        JavaElement element = this.getParent();
        while (element instanceof Member) {
            element = element.getParent();
        }
        if (element instanceof ClassFile) {
            return (ClassFile)element;
        }
        return null;
    }

    @Override
    public ISourceRange getNameRange() {
        if (this.nameEnd == -1) {
            SourceMapper mapper = this.getSourceMapper();
            if (mapper != null) {
                try {
                    ClassFile classFile = this.getClassFile();
                    if (classFile != null) {
                        classFile.getBuffer();
                        return mapper.getNameRange(this);
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            return SourceMapper.UNKNOWN_RANGE;
        }
        return new SourceRange(this.nameStart, this.nameEnd - this.nameStart + 1);
    }

    @Override
    public IPath getPath() {
        return this.getParent().getPath();
    }

    @Override
    public IResource resource() {
        return this.getParent().resource();
    }

    @Override
    public String getSource() throws JavaModelException {
        IOpenable openable = this.getParent().getOpenableParent();
        IBuffer buffer = openable.getBuffer();
        if (buffer == null) {
            return null;
        }
        ISourceRange range = this.getSourceRange();
        int offset = range.getOffset();
        int length = range.getLength();
        if (offset == -1 || length == 0) {
            return null;
        }
        try {
            return buffer.getText(offset, length);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public ISourceRange getSourceRange() throws JavaModelException {
        if (this.declarationSourceEnd == -1) {
            ClassFile classFile;
            SourceMapper mapper = this.getSourceMapper();
            if (mapper != null && (classFile = this.getClassFile()) != null) {
                classFile.getBuffer();
                return mapper.getSourceRange(this);
            }
            return SourceMapper.UNKNOWN_RANGE;
        }
        return new SourceRange(this.declarationSourceStart, this.declarationSourceEnd - this.declarationSourceStart + 1);
    }

    @Override
    public ITypeRoot getTypeRoot() {
        return this.getDeclaringMember().getTypeRoot();
    }

    @Override
    public String getTypeSignature() {
        return this.typeSignature;
    }

    @Override
    public IResource getUnderlyingResource() throws JavaModelException {
        return this.getParent().getUnderlyingResource();
    }

    @Override
    public int hashCode() {
        return Util.combineHashCodes(this.getParent().hashCode(), this.nameStart);
    }

    @Override
    public boolean isParameter() {
        return this.isParameter;
    }

    @Override
    public boolean isStructureKnown() throws JavaModelException {
        return true;
    }

    public String getKey(boolean forceOpen) throws JavaModelException {
        if (this.getParent().getElementType() == 9) {
            StringBuilder buf = new StringBuilder();
            if (this.getParent() instanceof BinaryMethod) {
                buf.append(((BinaryMethod)this.getParent()).getKey(forceOpen));
            } else {
                buf.append(((IMethod)((Object)this.getParent())).getKey());
            }
            buf.append('#');
            buf.append(this.name);
            if (this.isParameter) {
                ILocalVariable[] parameters = ((IMethod)((Object)this.getParent())).getParameters();
                int i = 0;
                while (i < parameters.length) {
                    if (this.equals(parameters[i])) {
                        buf.append("#0#").append(i);
                        break;
                    }
                    ++i;
                }
            }
            return buf.toString();
        }
        return null;
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info != JavaElement.NO_INFO) {
            buffer.append(Signature.toString(this.getTypeSignature()));
            buffer.append(" ");
        }
        this.toStringName(buffer);
    }
}

