/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.dom.rewrite.imports;

import java.util.Comparator;
import org.aspectj.org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportGroupComparator;
import org.aspectj.org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportName;

final class ImportComparator
implements Comparator<ImportName> {
    private final Comparator<ImportName> importGroupComparator;
    private final Comparator<ImportName> typeContainerComparator;
    private final Comparator<ImportName> staticContainerComparator;
    private final Comparator<ImportName> qualifiedNameComparator;

    private static Comparator<ImportName> createQualifiedNameComparator() {
        return new Comparator<ImportName>(){

            @Override
            public int compare(ImportName o1, ImportName o2) {
                return o1.qualifiedName.compareTo(o2.qualifiedName);
            }
        };
    }

    ImportComparator(ImportGroupComparator importGroupComparator, Comparator<ImportName> typeContainerComparator, Comparator<ImportName> staticContainerComparator) {
        this.importGroupComparator = importGroupComparator;
        this.typeContainerComparator = typeContainerComparator;
        this.staticContainerComparator = staticContainerComparator;
        this.qualifiedNameComparator = ImportComparator.createQualifiedNameComparator();
    }

    @Override
    public int compare(ImportName o1, ImportName o2) {
        int comparison;
        int importGroupComparison = this.importGroupComparator.compare(o1, o2);
        if (importGroupComparison != 0) {
            comparison = importGroupComparison;
        } else {
            Comparator<ImportName> containerComparator = o1.isStatic ? this.staticContainerComparator : this.typeContainerComparator;
            int containerComparison = containerComparator.compare(o1, o2);
            comparison = containerComparison != 0 ? containerComparison : this.qualifiedNameComparator.compare(o1, o2);
        }
        return comparison;
    }
}

