/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.matching;

import org.aspectj.ajdt.internal.compiler.lookup.OwningClassSupportForFieldBindings;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompactConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.LocalVariable;
import org.aspectj.org.eclipse.jdt.internal.core.SourceField;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.FieldPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.LocalVariablePattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.VariableLocator;
import org.aspectj.runtime.internal.AroundClosure;
import org.eclipse.core.runtime.CoreException;

public class LocalVariableLocator
extends VariableLocator {
    public LocalVariableLocator(LocalVariablePattern pattern) {
        super(pattern);
    }

    @Override
    public int match(LocalDeclaration node, MatchingNodeSet nodeSet) {
        int referencesLevel = 0;
        if (this.pattern.findReferences && this.pattern.writeAccess && !this.pattern.readAccess && node.initialization != null && this.matchesName(this.pattern.name, node.name)) {
            referencesLevel = this.pattern.mustResolve ? 2 : 3;
        }
        int declarationsLevel = 0;
        if (this.pattern.findDeclarations && this.matchesName(this.pattern.name, node.name) && node.declarationSourceStart == this.getLocalVariable().declarationSourceStart) {
            declarationsLevel = this.pattern.mustResolve ? 2 : 3;
        }
        return nodeSet.addMatch(node, referencesLevel >= declarationsLevel ? referencesLevel : declarationsLevel);
    }

    private LocalVariable getLocalVariable() {
        return ((LocalVariablePattern)this.pattern).localVariable;
    }

    @Override
    protected void matchReportReference(ASTNode reference, IJavaElement element, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        int offset = -1;
        int length = -1;
        if (reference instanceof SingleNameReference) {
            offset = reference.sourceStart;
            length = reference.sourceEnd - offset + 1;
        } else if (reference instanceof QualifiedNameReference) {
            QualifiedNameReference qNameRef = (QualifiedNameReference)reference;
            long sourcePosition = qNameRef.sourcePositions[0];
            offset = (int)(sourcePosition >>> 32);
            length = (int)sourcePosition - offset + 1;
        } else {
            if (reference instanceof LocalDeclaration) {
                LocalVariable localVariable = this.getLocalVariable();
                offset = localVariable.nameStart;
                length = localVariable.nameEnd - offset + 1;
                element = localVariable;
                this.match = locator.newDeclarationMatch(element, null, accuracy, offset, length);
                locator.report(this.match);
                return;
            }
            if (reference instanceof FieldReference) {
                FieldReference fieldReference = (FieldReference)reference;
                long position = fieldReference.nameSourcePosition;
                int start = (int)(position >>> 32);
                int end = (int)position;
                this.match = locator.newFieldReferenceMatch(element, null, elementBinding, accuracy, start, end - start + 1, fieldReference);
                locator.report(this.match);
                return;
            }
        }
        if (offset >= 0) {
            this.match = locator.newLocalVariableReferenceMatch(element, accuracy, offset, length, reference);
            locator.report(this.match);
        }
    }

    @Override
    protected int matchContainer() {
        return 4;
    }

    protected int matchLocalVariable(LocalVariableBinding variable, boolean matchName) {
        if (variable == null) {
            return 1;
        }
        if (matchName && !this.matchesName(this.pattern.name, variable.readableName())) {
            return 0;
        }
        return variable.declaration.declarationSourceStart == this.getLocalVariable().declarationSourceStart ? 3 : 0;
    }

    @Override
    protected int referenceType() {
        return 14;
    }

    @Override
    public int resolveLevel(ASTNode possiblelMatchingNode) {
        FieldBinding binding;
        if ((this.pattern.findReferences || this.pattern.fineGrain != 0) && possiblelMatchingNode instanceof NameReference) {
            return this.resolveLevel((NameReference)possiblelMatchingNode);
        }
        if (possiblelMatchingNode instanceof LocalDeclaration) {
            return this.matchLocalVariable(((LocalDeclaration)possiblelMatchingNode).binding, true);
        }
        if (possiblelMatchingNode instanceof FieldReference && (binding = ((FieldReference)possiblelMatchingNode).binding).isRecordComponent()) {
            return this.matchField(binding, true);
        }
        return 0;
    }

    @Override
    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        if (binding instanceof FieldBinding && ((FieldBinding)binding).isRecordComponent()) {
            return this.matchField(binding, true);
        }
        if (binding instanceof LocalVariableBinding && ((LocalVariableBinding)binding).declaringScope.referenceContext() instanceof CompactConstructorDeclaration && this.pattern instanceof FieldPattern) {
            return this.matchField(binding, true);
        }
        if (!(binding instanceof LocalVariableBinding)) {
            return 0;
        }
        return this.matchLocalVariable((LocalVariableBinding)binding, true);
    }

    private int matchField(Binding binding, boolean matchName) {
        FieldBinding fieldBinding;
        if (binding == null) {
            return 1;
        }
        if (binding instanceof FieldBinding && !((ReferenceBinding)LocalVariableLocator.declaringClass_aroundBody1$advice(this, fieldBinding = (FieldBinding)binding, OwningClassSupportForFieldBindings.aspectOf(), fieldBinding, null)).isRecord()) {
            return 0;
        }
        if (this.pattern instanceof LocalVariablePattern) {
            LocalVariablePattern lvp = (LocalVariablePattern)this.pattern;
            LocalVariable localVariable = lvp.localVariable;
            JavaElement parent = localVariable.getParent();
            if (!(parent instanceof SourceField)) {
                return 0;
            }
        }
        if (matchName && this.matchesName(this.pattern.name, binding.readableName())) {
            return 3;
        }
        return 0;
    }

    protected int resolveLevel(NameReference nameRef) {
        return this.resolveLevel(nameRef.binding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody0(LocalVariableLocator localVariableLocator, FieldBinding fieldBinding) {
        return fieldBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody1$advice(LocalVariableLocator ajc$this, FieldBinding target, OwningClassSupportForFieldBindings ajc$aspectInstance, FieldBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForFieldBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForFieldBindings$org_eclipse_jdt_internal_compiler_lookup_FieldBinding$getOwningClass(aBinding);
    }
}

