/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;

public class EnumElementValue
extends ElementValue {
    private int typeIdx;
    private int valueIdx;

    public EnumElementValue(int type, int typeIdx, int valueIdx, ConstantPool cpool) {
        super(type, cpool);
        if (type != 101) {
            throw new RuntimeException("Only element values of type enum can be built with this ctor");
        }
        this.typeIdx = typeIdx;
        this.valueIdx = valueIdx;
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeByte(this.type);
        dos.writeShort(this.typeIdx);
        dos.writeShort(this.valueIdx);
    }

    public String stringifyValue() {
        StringBuffer sb = new StringBuffer();
        ConstantUtf8 cu8 = (ConstantUtf8)this.cpool.getConstant(this.typeIdx, (byte)1);
        sb.append(cu8.getBytes());
        cu8 = (ConstantUtf8)this.cpool.getConstant(this.valueIdx, (byte)1);
        sb.append(cu8.getBytes());
        return sb.toString();
    }

    public String getEnumTypeString() {
        ConstantUtf8 cu8 = (ConstantUtf8)this.cpool.getConstant(this.typeIdx, (byte)1);
        return cu8.getBytes();
    }

    public String getEnumValueString() {
        ConstantUtf8 cu8 = (ConstantUtf8)this.cpool.getConstant(this.valueIdx, (byte)1);
        return cu8.getBytes();
    }

    public int getValueIndex() {
        return this.valueIdx;
    }

    public int getTypeIndex() {
        return this.typeIdx;
    }
}

