/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.Checker;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.ExposeTypeMunger;
import org.aspectj.weaver.PrivilegedAccessMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.DeclareAnnotation;
import org.aspectj.weaver.patterns.DeclareErrorOrWarning;
import org.aspectj.weaver.patterns.DeclareParents;
import org.aspectj.weaver.patterns.DeclarePrecedence;
import org.aspectj.weaver.patterns.DeclareSoft;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.PointcutRewriter;

public class CrosscuttingMembers {
    private final ResolvedType inAspect;
    private final World world;
    private PerClause perClause;
    private List shadowMungers = new ArrayList(4);
    private List typeMungers = new ArrayList(4);
    private List lateTypeMungers = new ArrayList(0);
    private List declareParents = new ArrayList(4);
    private List declareSofts = new ArrayList(0);
    private List declareDominates = new ArrayList(4);
    private List declareAnnotationsOnType = new ArrayList();
    private List declareAnnotationsOnField = new ArrayList();
    private List declareAnnotationsOnMethods = new ArrayList();
    private boolean shouldConcretizeIfNeeded = true;
    private final Hashtable cflowFields = new Hashtable();
    private final Hashtable cflowBelowFields = new Hashtable();

    public CrosscuttingMembers(ResolvedType inAspect, boolean shouldConcretizeIfNeeded) {
        this.inAspect = inAspect;
        this.world = inAspect.getWorld();
        this.shouldConcretizeIfNeeded = shouldConcretizeIfNeeded;
    }

    public void addConcreteShadowMunger(ShadowMunger m) {
        this.shadowMungers.add(m);
    }

    public void addShadowMungers(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.addShadowMunger((ShadowMunger)i.next());
        }
    }

    private void addShadowMunger(ShadowMunger m) {
        if (this.inAspect.isAbstract()) {
            return;
        }
        this.addConcreteShadowMunger(m.concretize(this.inAspect, this.world, this.perClause));
    }

    public void addTypeMungers(Collection c) {
        this.typeMungers.addAll(c);
    }

    public void addTypeMunger(ConcreteTypeMunger m) {
        if (m == null) {
            throw new Error("FIXME AV - should not happen or what ?");
        }
        this.typeMungers.add(m);
    }

    public void addLateTypeMungers(Collection c) {
        this.lateTypeMungers.addAll(c);
    }

    public void addLateTypeMunger(ConcreteTypeMunger m) {
        this.lateTypeMungers.add(m);
    }

    public void addDeclares(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.addDeclare((Declare)i.next());
        }
    }

    public void addDeclare(Declare declare) {
        if (declare instanceof DeclareErrorOrWarning) {
            Checker m = new Checker((DeclareErrorOrWarning)declare);
            m.setDeclaringType(declare.getDeclaringType());
            this.addShadowMunger(m);
        } else if (declare instanceof DeclarePrecedence) {
            this.declareDominates.add(declare);
        } else if (declare instanceof DeclareParents) {
            DeclareParents dp = (DeclareParents)declare;
            this.exposeTypes(dp.getParents().getExactTypes());
            this.declareParents.add(dp);
        } else if (declare instanceof DeclareSoft) {
            Pointcut concretePointcut;
            DeclareSoft d = (DeclareSoft)declare;
            Advice m = Advice.makeSoftener(this.world, d.getPointcut(), d.getException(), this.inAspect, d);
            m.setDeclaringType(d.getDeclaringType());
            m.pointcut = concretePointcut = d.getPointcut().concretize(this.inAspect, d.getDeclaringType(), 0, m);
            this.declareSofts.add(new DeclareSoft(d.getException(), concretePointcut));
            this.addConcreteShadowMunger(m);
        } else if (declare instanceof DeclareAnnotation) {
            DeclareAnnotation da = (DeclareAnnotation)declare;
            if (da.getAspect() == null) {
                da.setAspect(this.inAspect);
            }
            if (da.isDeclareAtType()) {
                this.declareAnnotationsOnType.add(da);
            } else if (da.isDeclareAtField()) {
                this.declareAnnotationsOnField.add(da);
            } else if (da.isDeclareAtMethod() || da.isDeclareAtConstuctor()) {
                this.declareAnnotationsOnMethods.add(da);
            }
        } else {
            throw new RuntimeException("unimplemented");
        }
    }

    public void exposeTypes(Collection typesToExpose) {
        Iterator i = typesToExpose.iterator();
        while (i.hasNext()) {
            this.exposeType((UnresolvedType)i.next());
        }
    }

    public void exposeType(UnresolvedType typeToExpose) {
        if (ResolvedType.isMissing(typeToExpose)) {
            return;
        }
        if (typeToExpose.isParameterizedType() || typeToExpose.isRawType()) {
            typeToExpose = typeToExpose instanceof ResolvedType ? ((ResolvedType)typeToExpose).getGenericType() : UnresolvedType.forSignature(typeToExpose.getErasureSignature());
        }
        String signatureToLookFor = typeToExpose.getSignature();
        Iterator iterator = this.typeMungers.iterator();
        while (iterator.hasNext()) {
            String exposedType;
            ConcreteTypeMunger cTM = (ConcreteTypeMunger)iterator.next();
            ResolvedTypeMunger rTM = cTM.getMunger();
            if (rTM == null || !(rTM instanceof ExposeTypeMunger) || !(exposedType = ((ExposeTypeMunger)rTM).getExposedTypeSignature()).equals(signatureToLookFor)) continue;
            return;
        }
        this.addTypeMunger(this.world.getWeavingSupport().concreteTypeMunger(new ExposeTypeMunger(typeToExpose), this.inAspect));
    }

    public void addPrivilegedAccesses(Collection accessedMembers) {
        Iterator i = accessedMembers.iterator();
        while (i.hasNext()) {
            this.addPrivilegedAccess((ResolvedMember)i.next());
        }
    }

    private void addPrivilegedAccess(ResolvedMember member) {
        this.addTypeMunger(this.world.getWeavingSupport().concreteTypeMunger(new PrivilegedAccessMunger(member), this.inAspect));
    }

    public Collection getCflowEntries() {
        ArrayList<Advice> ret = new ArrayList<Advice>();
        Iterator i = this.shadowMungers.iterator();
        while (i.hasNext()) {
            Advice a;
            ShadowMunger m = (ShadowMunger)i.next();
            if (!(m instanceof Advice) || !(a = (Advice)m).getKind().isCflow()) continue;
            ret.add(a);
        }
        return ret;
    }

    public boolean replaceWith(CrosscuttingMembers other, boolean careAboutShadowMungers) {
        Iterator iter;
        boolean changed = false;
        if (careAboutShadowMungers && (this.perClause == null || !this.perClause.equals(other.perClause))) {
            changed = true;
            this.perClause = other.perClause;
        }
        if (careAboutShadowMungers) {
            ShadowMunger munger;
            HashSet<ShadowMunger> theseShadowMungers = new HashSet<ShadowMunger>();
            HashSet<Advice> theseInlinedAroundMungers = new HashSet<Advice>();
            iter = this.shadowMungers.iterator();
            while (iter.hasNext()) {
                ShadowMunger munger2 = (ShadowMunger)iter.next();
                if (munger2 instanceof Advice) {
                    Advice adviceMunger = (Advice)munger2;
                    if (!this.world.isXnoInline() && adviceMunger.getKind().equals(AdviceKind.Around)) {
                        theseInlinedAroundMungers.add(adviceMunger);
                        continue;
                    }
                    theseShadowMungers.add(adviceMunger);
                    continue;
                }
                theseShadowMungers.add(munger2);
            }
            HashSet tempSet = new HashSet();
            tempSet.addAll(other.shadowMungers);
            HashSet<ShadowMunger> otherShadowMungers = new HashSet<ShadowMunger>();
            HashSet<ShadowMunger> otherInlinedAroundMungers = new HashSet<ShadowMunger>();
            Iterator iter2 = tempSet.iterator();
            while (iter2.hasNext()) {
                munger = (ShadowMunger)iter2.next();
                if (munger instanceof Advice) {
                    Advice adviceMunger = (Advice)munger;
                    if (!this.world.isXnoInline() && adviceMunger.getKind().equals(AdviceKind.Around)) {
                        otherInlinedAroundMungers.add(this.rewritePointcutInMunger(adviceMunger));
                        continue;
                    }
                    otherShadowMungers.add(this.rewritePointcutInMunger(adviceMunger));
                    continue;
                }
                otherShadowMungers.add(this.rewritePointcutInMunger(munger));
            }
            if (!((Object)theseShadowMungers).equals(otherShadowMungers)) {
                changed = true;
            }
            if (!this.equivalent(theseInlinedAroundMungers, otherInlinedAroundMungers)) {
                changed = true;
            }
            if (!changed) {
                iter2 = this.shadowMungers.iterator();
                while (iter2.hasNext()) {
                    munger = (ShadowMunger)iter2.next();
                    int i = other.shadowMungers.indexOf(munger);
                    ShadowMunger otherMunger = (ShadowMunger)other.shadowMungers.get(i);
                    if (!(munger instanceof Advice)) continue;
                    ((Advice)otherMunger).setHasMatchedSomething(((Advice)munger).hasMatchedSomething());
                }
            }
            this.shadowMungers = other.shadowMungers;
        }
        HashSet<ConcreteTypeMunger> theseTypeMungers = new HashSet<ConcreteTypeMunger>();
        HashSet<ConcreteTypeMunger> otherTypeMungers = new HashSet<ConcreteTypeMunger>();
        if (!careAboutShadowMungers) {
            ConcreteTypeMunger typeMunger;
            Object o;
            iter = this.typeMungers.iterator();
            while (iter.hasNext()) {
                o = iter.next();
                if (o instanceof ConcreteTypeMunger) {
                    typeMunger = (ConcreteTypeMunger)o;
                    if (typeMunger.existsToSupportShadowMunging()) continue;
                    theseTypeMungers.add(typeMunger);
                    continue;
                }
                theseTypeMungers.add((ConcreteTypeMunger)o);
            }
            iter = other.typeMungers.iterator();
            while (iter.hasNext()) {
                o = iter.next();
                if (o instanceof ConcreteTypeMunger) {
                    typeMunger = (ConcreteTypeMunger)o;
                    if (typeMunger.existsToSupportShadowMunging()) continue;
                    otherTypeMungers.add(typeMunger);
                    continue;
                }
                otherTypeMungers.add((ConcreteTypeMunger)o);
            }
        } else {
            theseTypeMungers.addAll(this.typeMungers);
            otherTypeMungers.addAll(other.typeMungers);
        }
        if (!((Object)theseTypeMungers).equals(otherTypeMungers)) {
            changed = true;
            this.typeMungers = other.typeMungers;
        }
        if (!((Object)this.lateTypeMungers).equals(other.lateTypeMungers)) {
            changed = true;
            this.lateTypeMungers = other.lateTypeMungers;
        }
        if (!((Object)this.declareDominates).equals(other.declareDominates)) {
            changed = true;
            this.declareDominates = other.declareDominates;
        }
        if (!((Object)this.declareParents).equals(other.declareParents)) {
            changed = true;
            this.declareParents = other.declareParents;
        }
        if (!((Object)this.declareSofts).equals(other.declareSofts)) {
            changed = true;
            this.declareSofts = other.declareSofts;
        }
        if (!((Object)this.declareAnnotationsOnType).equals(other.declareAnnotationsOnType)) {
            changed = true;
            this.declareAnnotationsOnType = other.declareAnnotationsOnType;
        }
        if (!((Object)this.declareAnnotationsOnField).equals(other.declareAnnotationsOnField)) {
            changed = true;
            this.declareAnnotationsOnField = other.declareAnnotationsOnField;
        }
        if (!((Object)this.declareAnnotationsOnMethods).equals(other.declareAnnotationsOnMethods)) {
            changed = true;
            this.declareAnnotationsOnMethods = other.declareAnnotationsOnMethods;
        }
        return changed;
    }

    private boolean equivalent(Set theseInlinedAroundMungers, Set otherInlinedAroundMungers) {
        if (theseInlinedAroundMungers.size() != otherInlinedAroundMungers.size()) {
            return false;
        }
        Iterator iter = theseInlinedAroundMungers.iterator();
        while (iter.hasNext()) {
            Advice thisAdvice = (Advice)iter.next();
            boolean foundIt = false;
            Iterator iterator = otherInlinedAroundMungers.iterator();
            while (iterator.hasNext()) {
                Advice otherAdvice = (Advice)iterator.next();
                if (!thisAdvice.equals(otherAdvice)) continue;
                if (thisAdvice.getSignature() instanceof ResolvedMemberImpl && ((ResolvedMemberImpl)thisAdvice.getSignature()).isEquivalentTo(otherAdvice.getSignature())) {
                    foundIt = true;
                    continue;
                }
                return false;
            }
            if (foundIt) continue;
            return false;
        }
        return true;
    }

    private ShadowMunger rewritePointcutInMunger(ShadowMunger munger) {
        PointcutRewriter pr = new PointcutRewriter();
        Pointcut p = munger.getPointcut();
        Pointcut newP = pr.rewrite(p);
        if (p.m_ignoreUnboundBindingForNames.length != 0) {
            newP.m_ignoreUnboundBindingForNames = p.m_ignoreUnboundBindingForNames;
        }
        munger.setPointcut(newP);
        return munger;
    }

    public void setPerClause(PerClause perClause) {
        this.perClause = this.shouldConcretizeIfNeeded ? perClause.concretize(this.inAspect) : perClause;
    }

    public List getDeclareDominates() {
        return this.declareDominates;
    }

    public List getDeclareParents() {
        return this.declareParents;
    }

    public List getDeclareSofts() {
        return this.declareSofts;
    }

    public List getShadowMungers() {
        return this.shadowMungers;
    }

    public List getTypeMungers() {
        return this.typeMungers;
    }

    public List getLateTypeMungers() {
        return this.lateTypeMungers;
    }

    public List getDeclareAnnotationOnTypes() {
        return this.declareAnnotationsOnType;
    }

    public List getDeclareAnnotationOnFields() {
        return this.declareAnnotationsOnField;
    }

    public List getDeclareAnnotationOnMethods() {
        return this.declareAnnotationsOnMethods;
    }

    public Map getCflowBelowFields() {
        return this.cflowBelowFields;
    }

    public Map getCflowFields() {
        return this.cflowFields;
    }

    public void clearCaches() {
        this.cflowFields.clear();
        this.cflowBelowFields.clear();
    }
}

