/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AnnotatedElement;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.AnnotationTargetKind;
import org.aspectj.weaver.ArrayReferenceType;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.BoundedReferenceType;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.CrosscuttingMembers;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Iterators;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.MissingResolvedTypeWithKnownSignature;
import org.aspectj.weaver.NewMethodTypeMunger;
import org.aspectj.weaver.NewParentTypeMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeFactory;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.TypeVariableReference;
import org.aspectj.weaver.TypeVariableReferenceType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.PerClause;

public abstract class ResolvedType
extends UnresolvedType
implements AnnotatedElement {
    public static final ResolvedType[] EMPTY_RESOLVED_TYPE_ARRAY = new ResolvedType[0];
    public static final String PARAMETERIZED_TYPE_IDENTIFIER = "P";
    public ResolvedType[] temporaryAnnotationTypes;
    private ResolvedType[] resolvedTypeParams;
    private String binaryPath;
    protected World world;
    protected static Set validBoxing = new HashSet();
    public CrosscuttingMembers crosscuttingMembers;
    public static final ResolvedType[] NONE;
    public static final Primitive BYTE;
    public static final Primitive CHAR;
    public static final Primitive DOUBLE;
    public static final Primitive FLOAT;
    public static final Primitive INT;
    public static final Primitive LONG;
    public static final Primitive SHORT;
    public static final Primitive VOID;
    public static final Primitive BOOLEAN;
    public static final Missing MISSING;
    protected List interTypeMungers = new ArrayList(0);
    private FuzzyBoolean parameterizedWithTypeVariable = FuzzyBoolean.MAYBE;

    protected ResolvedType(String signature, World world) {
        super(signature);
        this.world = world;
    }

    protected ResolvedType(String signature, String signatureErasure, World world) {
        super(signature, signatureErasure);
        this.world = world;
    }

    public final Iterator getDirectSupertypes() {
        Iterator ifacesIterator = Iterators.array(this.getDeclaredInterfaces());
        ResolvedType superclass = this.getSuperclass();
        if (superclass == null) {
            return ifacesIterator;
        }
        return Iterators.snoc(ifacesIterator, superclass);
    }

    public abstract ResolvedMember[] getDeclaredFields();

    public abstract ResolvedMember[] getDeclaredMethods();

    public abstract ResolvedType[] getDeclaredInterfaces();

    public abstract ResolvedMember[] getDeclaredPointcuts();

    public abstract ResolvedType getSuperclass();

    public abstract int getModifiers();

    public boolean isMissing() {
        return false;
    }

    public static boolean isMissing(UnresolvedType unresolved) {
        if (unresolved instanceof ResolvedType) {
            ResolvedType resolved = (ResolvedType)unresolved;
            return resolved.isMissing();
        }
        return unresolved == MISSING;
    }

    public ResolvedType[] getAnnotationTypes() {
        return EMPTY_RESOLVED_TYPE_ARRAY;
    }

    public AnnotationAJ getAnnotationOfType(UnresolvedType ofType) {
        return null;
    }

    public ResolvedType getResolvedComponentType() {
        return null;
    }

    public World getWorld() {
        return this.world;
    }

    public final boolean equals(Object other) {
        if (other instanceof ResolvedType) {
            return this == other;
        }
        return super.equals(other);
    }

    public Iterator getFields() {
        final Iterators.Filter dupFilter = Iterators.dupFilter();
        Iterators.Getter typeGetter = new Iterators.Getter(){

            public Iterator get(Object o) {
                return dupFilter.filter(((ResolvedType)o).getDirectSupertypes());
            }
        };
        Iterators.Getter fieldGetter = new Iterators.Getter(){

            public Iterator get(Object o) {
                return Iterators.array(((ResolvedType)o).getDeclaredFields());
            }
        };
        return Iterators.mapOver(Iterators.recur(this, typeGetter), fieldGetter);
    }

    public Iterator getMethods() {
        final Iterators.Filter dupFilter = Iterators.dupFilter();
        Iterators.Getter ifaceGetter = new Iterators.Getter(){

            public Iterator get(Object o) {
                return dupFilter.filter(Iterators.array(((ResolvedType)o).getDeclaredInterfaces()));
            }
        };
        Iterators.Getter methodGetter = new Iterators.Getter(){

            public Iterator get(Object o) {
                return Iterators.array(((ResolvedType)o).getDeclaredMethods());
            }
        };
        return Iterators.mapOver(Iterators.append(new Iterator(this){
            ResolvedType curr;
            private final /* synthetic */ ResolvedType this$0;
            {
                this.curr = this.this$0 = resolvedType;
            }

            public boolean hasNext() {
                return this.curr != null;
            }

            public Object next() {
                ResolvedType ret = this.curr;
                this.curr = this.curr.getSuperclass();
                return ret;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }, Iterators.recur(this, ifaceGetter)), methodGetter);
    }

    public List getMethodsWithoutIterator(boolean includeITDs, boolean allowMissing) {
        ArrayList methods = new ArrayList();
        HashSet knowninterfaces = new HashSet();
        this.addAndRecurse(knowninterfaces, methods, this, includeITDs, allowMissing);
        return methods;
    }

    private void addAndRecurse(Set knowninterfaces, List collector, ResolvedType rtx, boolean includeITDs, boolean allowMissing) {
        ResolvedType superType;
        collector.addAll(Arrays.asList(rtx.getDeclaredMethods()));
        if (includeITDs && rtx.interTypeMungers != null) {
            Iterator i = this.interTypeMungers.iterator();
            while (i.hasNext()) {
                ConcreteTypeMunger tm = (ConcreteTypeMunger)i.next();
                ResolvedMember rm = tm.getSignature();
                if (rm == null) continue;
                collector.add(tm.getSignature());
            }
        }
        if (!rtx.equals(UnresolvedType.OBJECT) && (superType = rtx.getSuperclass()) != null && !superType.isMissing()) {
            this.addAndRecurse(knowninterfaces, collector, superType, includeITDs, allowMissing);
        }
        ResolvedType[] interfaces = rtx.getDeclaredInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            ResolvedType iface = interfaces[i];
            boolean shouldSkip = false;
            for (int j = 0; j < rtx.interTypeMungers.size(); ++j) {
                ConcreteTypeMunger munger = (ConcreteTypeMunger)rtx.interTypeMungers.get(j);
                if (munger.getMunger() == null || munger.getMunger().getKind() != ResolvedTypeMunger.Parent || !((NewParentTypeMunger)munger.getMunger()).getNewParent().equals(iface)) continue;
                shouldSkip = true;
                break;
            }
            if (shouldSkip || knowninterfaces.contains(iface)) continue;
            knowninterfaces.add(iface);
            if (allowMissing && iface.isMissing()) {
                if (!(iface instanceof MissingResolvedTypeWithKnownSignature)) continue;
                ((MissingResolvedTypeWithKnownSignature)iface).raiseWarningOnMissingInterfaceWhilstFindingMethods();
                continue;
            }
            this.addAndRecurse(knowninterfaces, collector, iface, includeITDs, allowMissing);
        }
    }

    public ResolvedType[] getResolvedTypeParameters() {
        if (this.resolvedTypeParams == null) {
            this.resolvedTypeParams = this.world.resolve(this.typeParameters);
        }
        return this.resolvedTypeParams;
    }

    public ResolvedMember lookupField(Member m) {
        return this.lookupMember(m, this.getFields());
    }

    public ResolvedMember lookupMethod(Member m) {
        return this.lookupMember(m, this.getMethods());
    }

    public ResolvedMember lookupMethodInITDs(Member m) {
        if (this.interTypeMungers != null) {
            Iterator i = this.interTypeMungers.iterator();
            while (i.hasNext()) {
                ConcreteTypeMunger tm = (ConcreteTypeMunger)i.next();
                if (!ResolvedType.matches(tm.getSignature(), m)) continue;
                return tm.getSignature();
            }
        }
        return null;
    }

    private ResolvedMember lookupMember(Member m, Iterator i) {
        while (i.hasNext()) {
            ResolvedMember f = (ResolvedMember)i.next();
            if (ResolvedType.matches(f, m)) {
                return f;
            }
            if (!f.hasBackingGenericMember() || !m.getName().equals(f.getName()) || !ResolvedType.matches(f.getBackingGenericMember(), m)) continue;
            return f;
        }
        return null;
    }

    private ResolvedMember lookupMember(Member m, ResolvedMember[] a) {
        for (int i = 0; i < a.length; ++i) {
            ResolvedMember f = a[i];
            if (!ResolvedType.matches(f, m)) continue;
            return f;
        }
        return null;
    }

    public ResolvedMember lookupResolvedMember(ResolvedMember aMember, boolean allowMissing) {
        Iterator toSearch = null;
        ResolvedMemberImpl found = null;
        if (aMember.getKind() == Member.METHOD || aMember.getKind() == Member.CONSTRUCTOR) {
            toSearch = this.getMethodsWithoutIterator(true, allowMissing).iterator();
        } else {
            if (aMember.getKind() != Member.FIELD) {
                throw new IllegalStateException("I didn't know you would look for members of kind " + aMember.getKind());
            }
            toSearch = this.getFields();
        }
        while (toSearch.hasNext()) {
            ResolvedMemberImpl candidate = (ResolvedMemberImpl)toSearch.next();
            if (!candidate.matches(aMember)) continue;
            found = candidate;
            break;
        }
        return found;
    }

    public static boolean matches(Member m1, Member m2) {
        if (m1 == null) {
            return m2 == null;
        }
        if (m2 == null) {
            return false;
        }
        boolean equalNames = m1.getName().equals(m2.getName());
        if (!equalNames) {
            return false;
        }
        boolean equalSignatures = m1.getSignature().equals(m2.getSignature());
        if (equalSignatures) {
            return true;
        }
        boolean equalCovariantSignatures = m1.getParameterSignature().equals(m2.getParameterSignature());
        return equalCovariantSignatures;
    }

    public static boolean conflictingSignature(Member m1, Member m2) {
        int n;
        if (m1 == null || m2 == null) {
            return false;
        }
        if (!m1.getName().equals(m2.getName())) {
            return false;
        }
        if (m1.getKind() != m2.getKind()) {
            return false;
        }
        if (m1.getKind() == Member.FIELD) {
            return m1.getDeclaringType().equals(m2.getDeclaringType());
        }
        if (m1.getKind() == Member.POINTCUT) {
            return true;
        }
        UnresolvedType[] p1 = m1.getGenericParameterTypes();
        UnresolvedType[] p2 = m2.getGenericParameterTypes();
        if (p1 == null) {
            p1 = m1.getParameterTypes();
        }
        if (p2 == null) {
            p2 = m2.getParameterTypes();
        }
        if ((n = p1.length) != p2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (p1[i].equals(p2[i])) continue;
            return false;
        }
        return true;
    }

    public Iterator getPointcuts() {
        final Iterators.Filter dupFilter = Iterators.dupFilter();
        Iterators.Getter typeGetter = new Iterators.Getter(){

            public Iterator get(Object o) {
                return dupFilter.filter(((ResolvedType)o).getDirectSupertypes());
            }
        };
        Iterators.Getter pointcutGetter = new Iterators.Getter(){

            public Iterator get(Object o) {
                return Iterators.array(((ResolvedType)o).getDeclaredPointcuts());
            }
        };
        return Iterators.mapOver(Iterators.recur(this, typeGetter), pointcutGetter);
    }

    public ResolvedPointcutDefinition findPointcut(String name) {
        Iterator i = this.getPointcuts();
        while (i.hasNext()) {
            ResolvedPointcutDefinition f = (ResolvedPointcutDefinition)i.next();
            if (!name.equals(f.getName())) continue;
            return f;
        }
        if (!this.getOutermostType().equals(this)) {
            ResolvedType outerType = this.getOutermostType().resolve(this.world);
            ResolvedPointcutDefinition rpd = outerType.findPointcut(name);
            return rpd;
        }
        return null;
    }

    public CrosscuttingMembers collectCrosscuttingMembers(boolean shouldConcretizeIfNeeded) {
        this.crosscuttingMembers = new CrosscuttingMembers(this, shouldConcretizeIfNeeded);
        if (this.getPerClause() == null) {
            return this.crosscuttingMembers;
        }
        this.crosscuttingMembers.setPerClause(this.getPerClause());
        this.crosscuttingMembers.addShadowMungers(this.collectShadowMungers());
        this.crosscuttingMembers.addTypeMungers(this.getTypeMungers());
        this.crosscuttingMembers.addDeclares(this.collectDeclares(!this.doesNotExposeShadowMungers()));
        this.crosscuttingMembers.addPrivilegedAccesses(this.getPrivilegedAccesses());
        return this.crosscuttingMembers;
    }

    public final Collection collectDeclares(boolean includeAdviceLike) {
        if (!this.isAspect()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Declare> ret = new ArrayList<Declare>();
        if (!this.isAbstract()) {
            final Iterators.Filter dupFilter = Iterators.dupFilter();
            Iterators.Getter typeGetter = new Iterators.Getter(){

                public Iterator get(Object o) {
                    return dupFilter.filter(((ResolvedType)o).getDirectSupertypes());
                }
            };
            Iterator typeIterator = Iterators.recur(this, typeGetter);
            while (typeIterator.hasNext()) {
                ResolvedType ty = (ResolvedType)typeIterator.next();
                Iterator i = ty.getDeclares().iterator();
                while (i.hasNext()) {
                    Declare dec = (Declare)i.next();
                    if (dec.isAdviceLike()) {
                        if (!includeAdviceLike) continue;
                        ret.add(dec);
                        continue;
                    }
                    ret.add(dec);
                }
            }
        }
        return ret;
    }

    private final Collection collectShadowMungers() {
        if (!this.isAspect() || this.isAbstract() || this.doesNotExposeShadowMungers()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList acc = new ArrayList();
        final Iterators.Filter dupFilter = Iterators.dupFilter();
        Iterators.Getter typeGetter = new Iterators.Getter(){

            public Iterator get(Object o) {
                return dupFilter.filter(((ResolvedType)o).getDirectSupertypes());
            }
        };
        Iterator typeIterator = Iterators.recur(this, typeGetter);
        while (typeIterator.hasNext()) {
            ResolvedType ty = (ResolvedType)typeIterator.next();
            acc.addAll(ty.getDeclaredShadowMungers());
        }
        return acc;
    }

    protected boolean doesNotExposeShadowMungers() {
        return false;
    }

    public PerClause getPerClause() {
        return null;
    }

    public Collection getDeclares() {
        return Collections.EMPTY_LIST;
    }

    protected Collection getTypeMungers() {
        return Collections.EMPTY_LIST;
    }

    protected Collection getPrivilegedAccesses() {
        return Collections.EMPTY_LIST;
    }

    public final boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public final boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isClass() {
        return false;
    }

    public boolean isAspect() {
        return false;
    }

    public boolean isAnnotationStyleAspect() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isAnnotation() {
        return false;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isNested() {
        return false;
    }

    public void addAnnotation(AnnotationAJ annotationX) {
        throw new RuntimeException("ResolvedType.addAnnotation() should never be called");
    }

    public AnnotationAJ[] getAnnotations() {
        throw new RuntimeException("ResolvedType.getAnnotations() should never be called");
    }

    public boolean canAnnotationTargetType() {
        return false;
    }

    public AnnotationTargetKind[] getAnnotationTargetKinds() {
        return null;
    }

    public boolean isAnnotationWithRuntimeRetention() {
        return false;
    }

    public boolean isSynthetic() {
        return this.signature.indexOf("$ajc") != -1;
    }

    public final boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    protected Map getMemberParameterizationMap() {
        if (!this.isParameterizedType()) {
            return Collections.EMPTY_MAP;
        }
        TypeVariable[] tvs = this.getGenericType().getTypeVariables();
        HashMap<String, UnresolvedType> parameterizationMap = new HashMap<String, UnresolvedType>();
        for (int i = 0; i < tvs.length; ++i) {
            parameterizationMap.put(tvs[i].getName(), this.typeParameters[i]);
        }
        return parameterizationMap;
    }

    public Collection getDeclaredAdvice() {
        ArrayList<ShadowMunger> l = new ArrayList<ShadowMunger>();
        ResolvedMember[] methods = this.getDeclaredMethods();
        if (this.isParameterizedType()) {
            methods = this.getGenericType().getDeclaredMethods();
        }
        Map typeVariableMap = this.getAjMemberParameterizationMap();
        int len = methods.length;
        for (int i = 0; i < len; ++i) {
            ShadowMunger munger = methods[i].getAssociatedShadowMunger();
            if (munger == null) continue;
            if (this.ajMembersNeedParameterization() && (munger = munger.parameterizeWith(this, typeVariableMap)) instanceof Advice) {
                Advice advice = (Advice)munger;
                UnresolvedType[] ptypes = methods[i].getGenericParameterTypes();
                UnresolvedType[] newPTypes = new UnresolvedType[ptypes.length];
                for (int j = 0; j < ptypes.length; ++j) {
                    if (ptypes[j] instanceof TypeVariableReferenceType) {
                        TypeVariableReferenceType tvrt = (TypeVariableReferenceType)ptypes[j];
                        if (typeVariableMap.containsKey(tvrt.getTypeVariable().getName())) {
                            newPTypes[j] = (UnresolvedType)typeVariableMap.get(tvrt.getTypeVariable().getName());
                            continue;
                        }
                        newPTypes[j] = ptypes[j];
                        continue;
                    }
                    newPTypes[j] = ptypes[j];
                }
                advice.setBindingParameterTypes(newPTypes);
            }
            munger.setDeclaringType(this);
            l.add(munger);
        }
        return l;
    }

    public Collection getDeclaredShadowMungers() {
        Collection c = this.getDeclaredAdvice();
        return c;
    }

    public ResolvedMember[] getDeclaredJavaFields() {
        return this.filterInJavaVisible(this.getDeclaredFields());
    }

    public ResolvedMember[] getDeclaredJavaMethods() {
        return this.filterInJavaVisible(this.getDeclaredMethods());
    }

    public ShadowMunger[] getDeclaredShadowMungersArray() {
        List l = (List)this.getDeclaredShadowMungers();
        return l.toArray(new ShadowMunger[l.size()]);
    }

    private ResolvedMember[] filterInJavaVisible(ResolvedMember[] ms) {
        ArrayList<ResolvedMember> l = new ArrayList<ResolvedMember>();
        int len = ms.length;
        for (int i = 0; i < len; ++i) {
            if (ms[i].isAjSynthetic() || ms[i].getAssociatedShadowMunger() != null) continue;
            l.add(ms[i]);
        }
        return l.toArray(new ResolvedMember[l.size()]);
    }

    public abstract ISourceContext getSourceContext();

    public static void resetPrimitives() {
        ResolvedType.BYTE.world = null;
        ResolvedType.CHAR.world = null;
        ResolvedType.DOUBLE.world = null;
        ResolvedType.FLOAT.world = null;
        ResolvedType.INT.world = null;
        ResolvedType.LONG.world = null;
        ResolvedType.SHORT.world = null;
        ResolvedType.VOID.world = null;
        ResolvedType.BOOLEAN.world = null;
    }

    public static ResolvedType makeArray(ResolvedType type, int dim) {
        if (dim == 0) {
            return type;
        }
        ArrayReferenceType array = new ArrayReferenceType("[" + type.getSignature(), "[" + type.getErasureSignature(), type.getWorld(), type);
        return ResolvedType.makeArray(array, dim - 1);
    }

    public ResolvedMember lookupMemberNoSupers(Member member) {
        ResolvedMember ret = this.lookupDirectlyDeclaredMemberNoSupers(member);
        if (ret == null && this.interTypeMungers != null) {
            Iterator i = this.interTypeMungers.iterator();
            while (i.hasNext()) {
                ConcreteTypeMunger tm = (ConcreteTypeMunger)i.next();
                if (!ResolvedType.matches(tm.getSignature(), member)) continue;
                return tm.getSignature();
            }
        }
        return ret;
    }

    public ResolvedMember lookupMemberWithSupersAndITDs(Member member) {
        ResolvedMember ret = this.lookupMemberNoSupers(member);
        if (ret != null) {
            return ret;
        }
        ResolvedType supert = this.getSuperclass();
        while (ret == null && supert != null) {
            ret = supert.lookupMemberNoSupers(member);
            if (ret != null) continue;
            supert = supert.getSuperclass();
        }
        return ret;
    }

    public ResolvedMember lookupDirectlyDeclaredMemberNoSupers(Member member) {
        ResolvedMember ret = member.getKind() == Member.FIELD ? this.lookupMember(member, this.getDeclaredFields()) : this.lookupMember(member, this.getDeclaredMethods());
        return ret;
    }

    public ResolvedMember lookupMemberIncludingITDsOnInterfaces(Member member) {
        return this.lookupMemberIncludingITDsOnInterfaces(member, this);
    }

    private ResolvedMember lookupMemberIncludingITDsOnInterfaces(Member member, ResolvedType onType) {
        ResolvedMember ret = onType.lookupMemberNoSupers(member);
        if (ret != null) {
            return ret;
        }
        ResolvedType superType = onType.getSuperclass();
        if (superType != null) {
            ret = this.lookupMemberIncludingITDsOnInterfaces(member, superType);
        }
        if (ret == null) {
            ResolvedType[] superInterfaces = onType.getDeclaredInterfaces();
            for (int i = 0; i < superInterfaces.length; ++i) {
                ret = superInterfaces[i].lookupMethodInITDs(member);
                if (ret == null) continue;
                return ret;
            }
        }
        return ret;
    }

    public List getInterTypeMungers() {
        return this.interTypeMungers;
    }

    public List getInterTypeParentMungers() {
        ArrayList<ConcreteTypeMunger> l = new ArrayList<ConcreteTypeMunger>();
        Iterator iter = this.interTypeMungers.iterator();
        while (iter.hasNext()) {
            ConcreteTypeMunger element = (ConcreteTypeMunger)iter.next();
            if (!(element.getMunger() instanceof NewParentTypeMunger)) continue;
            l.add(element);
        }
        return l;
    }

    public List getInterTypeMungersIncludingSupers() {
        ArrayList ret = new ArrayList();
        this.collectInterTypeMungers(ret);
        return ret;
    }

    public List getInterTypeParentMungersIncludingSupers() {
        ArrayList ret = new ArrayList();
        this.collectInterTypeParentMungers(ret);
        return ret;
    }

    private void collectInterTypeParentMungers(List collector) {
        Iterator iter = this.getDirectSupertypes();
        while (iter.hasNext()) {
            ResolvedType superType = (ResolvedType)iter.next();
            superType.collectInterTypeParentMungers(collector);
        }
        collector.addAll(this.getInterTypeParentMungers());
    }

    protected void collectInterTypeMungers(List collector) {
        Iterator iter = this.getDirectSupertypes();
        while (iter.hasNext()) {
            ResolvedType superType = (ResolvedType)iter.next();
            if (superType == null) {
                throw new BCException("UnexpectedProblem: a supertype in the hierarchy for " + this.getName() + " is null");
            }
            superType.collectInterTypeMungers(collector);
        }
        Iterator iter1 = collector.iterator();
        block1: while (iter1.hasNext()) {
            ConcreteTypeMunger superMunger = (ConcreteTypeMunger)iter1.next();
            if (superMunger.getSignature() == null || !superMunger.getSignature().isAbstract()) continue;
            Iterator iter2 = this.getInterTypeMungers().iterator();
            while (iter2.hasNext()) {
                ConcreteTypeMunger myMunger = (ConcreteTypeMunger)iter2.next();
                if (!ResolvedType.conflictingSignature(myMunger.getSignature(), superMunger.getSignature())) continue;
                iter1.remove();
                continue block1;
            }
            if (!superMunger.getSignature().isPublic()) continue;
            iter2 = this.getMethods();
            while (iter2.hasNext()) {
                ResolvedMember method = (ResolvedMember)iter2.next();
                if (!ResolvedType.conflictingSignature(method, superMunger.getSignature())) continue;
                iter1.remove();
                continue block1;
            }
        }
        collector.addAll(this.getInterTypeMungers());
    }

    public void checkInterTypeMungers() {
        ConcreteTypeMunger munger;
        if (this.isAbstract()) {
            return;
        }
        boolean itdProblem = false;
        Iterator iter = this.getInterTypeMungersIncludingSupers().iterator();
        while (iter.hasNext()) {
            munger = (ConcreteTypeMunger)iter.next();
            itdProblem = this.checkAbstractDeclaration(munger) || itdProblem;
        }
        if (itdProblem) {
            return;
        }
        iter = this.getInterTypeMungersIncludingSupers().iterator();
        while (iter.hasNext()) {
            munger = (ConcreteTypeMunger)iter.next();
            if (munger.getSignature() == null || !munger.getSignature().isAbstract() || munger.getMunger().getKind() == ResolvedTypeMunger.MethodDelegate) continue;
            this.world.getMessageHandler().handleMessage(new Message("must implement abstract inter-type declaration: " + munger.getSignature(), "", IMessage.ERROR, this.getSourceLocation(), null, new ISourceLocation[]{this.getMungerLocation(munger)}));
        }
    }

    private boolean checkAbstractDeclaration(ConcreteTypeMunger munger) {
        ResolvedMember itdMember;
        ResolvedType onType;
        if (munger.getMunger() != null && munger.getMunger() instanceof NewMethodTypeMunger && (onType = (itdMember = munger.getSignature()).getDeclaringType().resolve(this.world)).isInterface() && itdMember.isAbstract() && !itdMember.isPublic()) {
            this.world.getMessageHandler().handleMessage(new Message(WeaverMessages.format("itdAbstractMustBePublicOnInterface", munger.getSignature(), onType), "", IMessage.ERROR, this.getSourceLocation(), null, new ISourceLocation[]{this.getMungerLocation(munger)}));
            return true;
        }
        return false;
    }

    private ISourceLocation getMungerLocation(ConcreteTypeMunger munger) {
        ISourceLocation sloc = munger.getSourceLocation();
        if (sloc == null) {
            sloc = munger.getAspectType().getSourceLocation();
        }
        return sloc;
    }

    public ResolvedType getDeclaringType() {
        if (this.isArray()) {
            return null;
        }
        String name = this.getName();
        int lastDollar = name.lastIndexOf(36);
        while (lastDollar > 0) {
            ResolvedType ret = this.world.resolve(UnresolvedType.forName(name.substring(0, lastDollar)), true);
            if (!ResolvedType.isMissing(ret)) {
                return ret;
            }
            lastDollar = name.lastIndexOf(36, lastDollar - 1);
        }
        return null;
    }

    public static boolean isVisible(int modifiers, ResolvedType targetType, ResolvedType fromType) {
        if (Modifier.isPublic(modifiers)) {
            return true;
        }
        if (Modifier.isPrivate(modifiers)) {
            return targetType.getOutermostType().equals(fromType.getOutermostType());
        }
        if (Modifier.isProtected(modifiers)) {
            return ResolvedType.samePackage(targetType, fromType) || targetType.isAssignableFrom(fromType);
        }
        return ResolvedType.samePackage(targetType, fromType);
    }

    private static boolean samePackage(ResolvedType targetType, ResolvedType fromType) {
        String p1 = targetType.getPackageName();
        String p2 = fromType.getPackageName();
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        return p1.equals(p2);
    }

    private boolean genericTypeEquals(ResolvedType other) {
        ResolvedType rt = other;
        if (rt.isParameterizedType() || rt.isRawType()) {
            rt.getGenericType();
        }
        return (this.isParameterizedType() || this.isRawType()) && this.getGenericType().equals(rt) || this.equals(other);
    }

    public ResolvedType discoverActualOccurrenceOfTypeInHierarchy(ResolvedType lookingFor) {
        if (!lookingFor.isGenericType()) {
            throw new BCException("assertion failed: method should only be called with generic type, but " + lookingFor + " is " + lookingFor.typeKind);
        }
        if (this.equals(UnresolvedType.OBJECT)) {
            return null;
        }
        if (this.genericTypeEquals(lookingFor)) {
            return this;
        }
        ResolvedType superT = this.getSuperclass();
        if (superT.genericTypeEquals(lookingFor)) {
            return superT;
        }
        ResolvedType[] superIs = this.getDeclaredInterfaces();
        for (int i = 0; i < superIs.length; ++i) {
            ResolvedType superI = superIs[i];
            if (superI.genericTypeEquals(lookingFor)) {
                return superI;
            }
            ResolvedType checkTheSuperI = superI.discoverActualOccurrenceOfTypeInHierarchy(lookingFor);
            if (checkTheSuperI == null) continue;
            return checkTheSuperI;
        }
        return superT.discoverActualOccurrenceOfTypeInHierarchy(lookingFor);
    }

    public ConcreteTypeMunger fillInAnyTypeParameters(ConcreteTypeMunger munger) {
        boolean debug = false;
        ResolvedMember member = munger.getSignature();
        if (munger.isTargetTypeParameterized()) {
            ResolvedType actualTarget;
            if (debug) {
                System.err.println("Processing attempted parameterization of " + munger + " targetting type " + this);
            }
            if (debug) {
                System.err.println("  This type is " + this + "  (" + this.typeKind + ")");
            }
            if (debug) {
                System.err.println("  Signature that needs parameterizing: " + member);
            }
            ResolvedType onType = this.world.resolve(member.getDeclaringType()).getGenericType();
            member.resolve(this.world);
            if (debug) {
                System.err.println("  Actual target ontype: " + onType + "  (" + onType.typeKind + ")");
            }
            if ((actualTarget = this.discoverActualOccurrenceOfTypeInHierarchy(onType)) == null) {
                throw new BCException("assertion failed: asked " + this + " for occurrence of " + onType + " in its hierarchy??");
            }
            if (!actualTarget.isGenericType() && debug) {
                System.err.println("Occurrence in " + this + " is actually " + actualTarget + "  (" + actualTarget.typeKind + ")");
            }
            munger = munger.parameterizedFor(actualTarget);
            if (debug) {
                System.err.println("New sig: " + munger.getSignature());
            }
            if (debug) {
                System.err.println("=====================================");
            }
        }
        return munger;
    }

    public void addInterTypeMunger(ConcreteTypeMunger munger) {
        ResolvedMember sig = munger.getSignature();
        if (sig == null || munger.getMunger() == null || munger.getMunger().getKind() == ResolvedTypeMunger.PrivilegedAccess) {
            this.interTypeMungers.add(munger);
            return;
        }
        sig = (munger = this.fillInAnyTypeParameters(munger)).getSignature();
        if (sig.getKind() == Member.METHOD) {
            if (!this.compareToExistingMembers(munger, this.getMethodsWithoutIterator(false, true))) {
                return;
            }
            if (this.isInterface() && !this.compareToExistingMembers(munger, Arrays.asList(this.world.getCoreType(UnresolvedType.OBJECT).getDeclaredMethods()).iterator())) {
                return;
            }
        } else if (sig.getKind() == Member.FIELD ? !this.compareToExistingMembers(munger, Arrays.asList(this.getDeclaredFields()).iterator()) : !this.compareToExistingMembers(munger, Arrays.asList(this.getDeclaredMethods()).iterator())) {
            return;
        }
        Iterator i = this.interTypeMungers.iterator();
        while (i.hasNext()) {
            ConcreteTypeMunger existingMunger = (ConcreteTypeMunger)i.next();
            if (!ResolvedType.conflictingSignature(existingMunger.getSignature(), munger.getSignature()) || !ResolvedType.isVisible(munger.getSignature().getModifiers(), munger.getAspectType(), existingMunger.getAspectType())) continue;
            int c = this.compareMemberPrecedence(sig, existingMunger.getSignature());
            if (c == 0) {
                c = this.getWorld().compareByPrecedenceAndHierarchy(munger.getAspectType(), existingMunger.getAspectType());
            }
            if (c < 0) {
                this.checkLegalOverride(munger.getSignature(), existingMunger.getSignature());
                return;
            }
            if (c > 0) {
                this.checkLegalOverride(existingMunger.getSignature(), munger.getSignature());
                i.remove();
                break;
            }
            this.interTypeConflictError(munger, existingMunger);
            this.interTypeConflictError(existingMunger, munger);
            return;
        }
        this.interTypeMungers.add(munger);
    }

    private boolean compareToExistingMembers(ConcreteTypeMunger munger, List existingMembersList) {
        return this.compareToExistingMembers(munger, existingMembersList.iterator());
    }

    private boolean compareToExistingMembers(ConcreteTypeMunger munger, Iterator existingMembers) {
        ResolvedMember sig = munger.getSignature();
        while (existingMembers.hasNext()) {
            ResolvedMember existingMember = (ResolvedMember)existingMembers.next();
            if (existingMember.isBridgeMethod() || !ResolvedType.conflictingSignature(existingMember, munger.getSignature())) continue;
            if (ResolvedType.isVisible(existingMember.getModifiers(), this, munger.getAspectType())) {
                List mungersAffectingThisType;
                int c = this.compareMemberPrecedence(sig, existingMember);
                if (c < 0) {
                    this.checkLegalOverride(munger.getSignature(), existingMember);
                    return false;
                }
                if (c > 0) {
                    this.checkLegalOverride(existingMember, munger.getSignature());
                    continue;
                }
                boolean sameReturnTypes = existingMember.getReturnType().equals(sig.getReturnType());
                if (!sameReturnTypes) continue;
                boolean isDuplicateOfPreviousITD = false;
                ResolvedType declaringRt = existingMember.getDeclaringType().resolve(this.world);
                WeaverStateInfo wsi = declaringRt.getWeaverState();
                if (wsi != null && (mungersAffectingThisType = wsi.getTypeMungers(declaringRt)) != null) {
                    Iterator iterator = mungersAffectingThisType.iterator();
                    while (iterator.hasNext() && !isDuplicateOfPreviousITD) {
                        ConcreteTypeMunger ctMunger = (ConcreteTypeMunger)iterator.next();
                        if (!ctMunger.getSignature().equals(existingMember) || !ctMunger.aspectType.equals(munger.getAspectType())) continue;
                        isDuplicateOfPreviousITD = true;
                    }
                }
                if (isDuplicateOfPreviousITD) continue;
                this.getWorld().getMessageHandler().handleMessage(MessageUtil.error(WeaverMessages.format("itdMemberConflict", munger.getAspectType().getName(), existingMember), munger.getSourceLocation()));
                continue;
            }
            if (!this.isDuplicateMemberWithinTargetType(existingMember, this, sig)) continue;
            this.getWorld().getMessageHandler().handleMessage(MessageUtil.error(WeaverMessages.format("itdMemberConflict", munger.getAspectType().getName(), existingMember), munger.getSourceLocation()));
        }
        return true;
    }

    private boolean isDuplicateMemberWithinTargetType(ResolvedMember existingMember, ResolvedType targetType, ResolvedMember itdMember) {
        if (existingMember.isAbstract() || itdMember.isAbstract()) {
            return false;
        }
        UnresolvedType declaringType = existingMember.getDeclaringType();
        if (!targetType.equals(declaringType)) {
            return false;
        }
        if (itdMember.isPrivate()) {
            return false;
        }
        if (itdMember.isPublic()) {
            return true;
        }
        return targetType.getPackageName().equals(itdMember.getDeclaringType().getPackageName());
    }

    public boolean checkLegalOverride(ResolvedMember parent, ResolvedMember child) {
        Object[] cTypes;
        Object[] pTypes;
        if (Modifier.isFinal(parent.getModifiers())) {
            this.world.showMessage(IMessage.ERROR, WeaverMessages.format("cantOverrideFinalMember", parent), child.getSourceLocation(), null);
            return false;
        }
        boolean incompatibleReturnTypes = false;
        if (this.world.isInJava5Mode() && parent.getKind() == Member.METHOD) {
            ResolvedType rtChildReturnType;
            ResolvedType rtParentReturnType = parent.resolve(this.world).getGenericReturnType().resolve(this.world);
            incompatibleReturnTypes = !rtParentReturnType.isAssignableFrom(rtChildReturnType = child.resolve(this.world).getGenericReturnType().resolve(this.world));
        } else {
            boolean bl = incompatibleReturnTypes = !parent.getReturnType().equals(child.getReturnType());
        }
        if (incompatibleReturnTypes) {
            this.world.showMessage(IMessage.ERROR, WeaverMessages.format("returnTypeMismatch", parent, child), child.getSourceLocation(), parent.getSourceLocation());
            return false;
        }
        if (parent.getKind() == Member.POINTCUT && !Arrays.equals(pTypes = parent.getParameterTypes(), cTypes = child.getParameterTypes())) {
            this.world.showMessage(IMessage.ERROR, WeaverMessages.format("paramTypeMismatch", parent, child), child.getSourceLocation(), parent.getSourceLocation());
            return false;
        }
        if (ResolvedType.isMoreVisible(parent.getModifiers(), child.getModifiers())) {
            this.world.showMessage(IMessage.ERROR, WeaverMessages.format("visibilityReduction", parent, child), child.getSourceLocation(), parent.getSourceLocation());
            return false;
        }
        ResolvedType[] childExceptions = this.world.resolve(child.getExceptions());
        ResolvedType[] parentExceptions = this.world.resolve(parent.getExceptions());
        ResolvedType runtimeException = this.world.resolve("java.lang.RuntimeException");
        ResolvedType error = this.world.resolve("java.lang.Error");
        int leni = childExceptions.length;
        block0: for (int i = 0; i < leni; ++i) {
            if (runtimeException.isAssignableFrom(childExceptions[i]) || error.isAssignableFrom(childExceptions[i])) continue;
            int lenj = parentExceptions.length;
            for (int j = 0; j < lenj; ++j) {
                if (parentExceptions[j].isAssignableFrom(childExceptions[i])) continue block0;
            }
            return false;
        }
        if (parent.isStatic() && !child.isStatic()) {
            this.world.showMessage(IMessage.ERROR, WeaverMessages.format("overriddenStatic", child, parent), child.getSourceLocation(), null);
            return false;
        }
        if (child.isStatic() && !parent.isStatic()) {
            this.world.showMessage(IMessage.ERROR, WeaverMessages.format("overridingStatic", child, parent), child.getSourceLocation(), null);
            return false;
        }
        return true;
    }

    private int compareMemberPrecedence(ResolvedMember m1, ResolvedMember m2) {
        ResolvedType t2;
        UnresolvedType declaring;
        if (m2.isProtected() && m2.getName().charAt(0) == 'c' && (declaring = m2.getDeclaringType()) != null && declaring.getName().equals("java.lang.Object") && m2.getName().equals("clone")) {
            return 1;
        }
        if (Modifier.isAbstract(m1.getModifiers())) {
            return -1;
        }
        if (Modifier.isAbstract(m2.getModifiers())) {
            return 1;
        }
        if (m1.getDeclaringType().equals(m2.getDeclaringType())) {
            return 0;
        }
        ResolvedType t1 = m1.getDeclaringType().resolve(this.world);
        if (t1.isAssignableFrom(t2 = m2.getDeclaringType().resolve(this.world))) {
            return -1;
        }
        if (t2.isAssignableFrom(t1)) {
            return 1;
        }
        return 0;
    }

    public static boolean isMoreVisible(int m1, int m2) {
        if (Modifier.isPrivate(m1)) {
            return false;
        }
        if (ResolvedType.isPackage(m1)) {
            return Modifier.isPrivate(m2);
        }
        if (Modifier.isProtected(m1)) {
            return Modifier.isPrivate(m2) || ResolvedType.isPackage(m2);
        }
        if (Modifier.isPublic(m1)) {
            return !Modifier.isPublic(m2);
        }
        throw new RuntimeException("bad modifier: " + m1);
    }

    private static boolean isPackage(int i) {
        return 0 == (i & 7);
    }

    private void interTypeConflictError(ConcreteTypeMunger m1, ConcreteTypeMunger m2) {
        this.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("itdConflict", m1.getAspectType().getName(), m2.getSignature(), m2.getAspectType().getName()), m2.getSourceLocation(), this.getSourceLocation());
    }

    public ResolvedMember lookupSyntheticMember(Member member) {
        Iterator i = this.interTypeMungers.iterator();
        while (i.hasNext()) {
            ConcreteTypeMunger m = (ConcreteTypeMunger)i.next();
            ResolvedMember ret = m.getMatchingSyntheticMember(member);
            if (ret == null) continue;
            return ret;
        }
        if (this.world.isJoinpointArrayConstructionEnabled() && this.isArray() && member.getKind() == Member.CONSTRUCTOR) {
            ResolvedMemberImpl ret = new ResolvedMemberImpl(Member.CONSTRUCTOR, this, 1, VOID, "<init>", this.world.resolve(member.getParameterTypes()));
            return ret;
        }
        return null;
    }

    public void clearInterTypeMungers() {
        if (this.isRawType()) {
            this.getGenericType().clearInterTypeMungers();
        }
        this.interTypeMungers = new ArrayList();
    }

    public boolean isTopmostImplementor(ResolvedType interfaceType) {
        if (this.isInterface()) {
            return false;
        }
        if (!interfaceType.isAssignableFrom(this, true)) {
            return false;
        }
        if (this.getSuperclass().isMissing()) {
            return true;
        }
        return !interfaceType.isAssignableFrom(this.getSuperclass(), true);
    }

    public ResolvedType getTopmostImplementor(ResolvedType interfaceType) {
        if (this.isInterface()) {
            return null;
        }
        if (!interfaceType.isAssignableFrom(this)) {
            return null;
        }
        ResolvedType higherType = this.getSuperclass().getTopmostImplementor(interfaceType);
        if (higherType != null) {
            return higherType;
        }
        return this;
    }

    public List getExposedPointcuts() {
        ArrayList ret = new ArrayList();
        if (this.getSuperclass() != null) {
            ret.addAll(this.getSuperclass().getExposedPointcuts());
        }
        Iterator<ResolvedType> i = Arrays.asList(this.getDeclaredInterfaces()).iterator();
        while (i.hasNext()) {
            ResolvedType t = i.next();
            this.addPointcutsResolvingConflicts(ret, Arrays.asList(t.getDeclaredPointcuts()), false);
        }
        this.addPointcutsResolvingConflicts(ret, Arrays.asList(this.getDeclaredPointcuts()), true);
        i = ret.iterator();
        while (i.hasNext()) {
            ResolvedPointcutDefinition inherited = (ResolvedPointcutDefinition)((Object)i.next());
            if (!inherited.isAbstract() || this.isAbstract()) continue;
            this.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("abstractPointcutNotMadeConcrete", inherited, this.getName()), inherited.getSourceLocation(), this.getSourceLocation());
        }
        return ret;
    }

    private void addPointcutsResolvingConflicts(List acc, List added, boolean isOverriding) {
        Iterator i = added.iterator();
        while (i.hasNext()) {
            ResolvedPointcutDefinition toAdd = (ResolvedPointcutDefinition)i.next();
            Iterator j = acc.iterator();
            while (j.hasNext()) {
                ResolvedPointcutDefinition existing = (ResolvedPointcutDefinition)j.next();
                if (existing == toAdd) continue;
                if (!ResolvedType.isVisible(existing.getModifiers(), existing.getDeclaringType().resolve(this.getWorld()), this)) {
                    if (!existing.isAbstract() || !ResolvedType.conflictingSignature(existing, toAdd)) continue;
                    this.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("pointcutNotVisible", existing.getDeclaringType().getName() + "." + existing.getName() + "()", this.getName()), toAdd.getSourceLocation(), null);
                    j.remove();
                    continue;
                }
                if (!ResolvedType.conflictingSignature(existing, toAdd)) continue;
                if (isOverriding) {
                    this.checkLegalOverride(existing, toAdd);
                    j.remove();
                    continue;
                }
                this.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("conflictingInheritedPointcuts", this.getName() + toAdd.getSignature()), existing.getSourceLocation(), toAdd.getSourceLocation());
                j.remove();
            }
            acc.add(toAdd);
        }
    }

    public ISourceLocation getSourceLocation() {
        return null;
    }

    public boolean isExposedToWeaver() {
        return false;
    }

    public WeaverStateInfo getWeaverState() {
        return null;
    }

    public ResolvedType getGenericType() {
        if (!this.isParameterizedType() && !this.isRawType()) {
            throw new BCException("The type " + this.getBaseName() + " is not parameterized or raw - it has no generic type");
        }
        return null;
    }

    public ResolvedType parameterizedWith(UnresolvedType[] typeParameters) {
        if (!this.isGenericType() && !this.isParameterizedType()) {
            return this;
        }
        return TypeFactory.createParameterizedType(this.getGenericType(), typeParameters, this.getWorld());
    }

    public UnresolvedType parameterize(Map typeBindings) {
        if (!this.isParameterizedType()) {
            return this;
        }
        boolean workToDo = false;
        for (int i = 0; i < this.typeParameters.length; ++i) {
            if (!this.typeParameters[i].isTypeVariableReference() && !(this.typeParameters[i] instanceof BoundedReferenceType)) continue;
            workToDo = true;
        }
        if (!workToDo) {
            return this;
        }
        UnresolvedType[] newTypeParams = new UnresolvedType[this.typeParameters.length];
        for (int i = 0; i < newTypeParams.length; ++i) {
            newTypeParams[i] = this.typeParameters[i];
            if (newTypeParams[i].isTypeVariableReference()) {
                TypeVariableReferenceType tvrt = (TypeVariableReferenceType)newTypeParams[i];
                UnresolvedType binding = (UnresolvedType)typeBindings.get(tvrt.getTypeVariable().getName());
                if (binding == null) continue;
                newTypeParams[i] = binding;
                continue;
            }
            if (!(newTypeParams[i] instanceof BoundedReferenceType)) continue;
            BoundedReferenceType brType = (BoundedReferenceType)newTypeParams[i];
            newTypeParams[i] = brType.parameterize(typeBindings);
        }
        return TypeFactory.createParameterizedType(this.getGenericType(), newTypeParams, this.getWorld());
    }

    public boolean isException() {
        return this.world.getCoreType(UnresolvedType.JAVA_LANG_EXCEPTION).isAssignableFrom(this);
    }

    public boolean isCheckedException() {
        if (!this.isException()) {
            return false;
        }
        return !this.world.getCoreType(UnresolvedType.RUNTIME_EXCEPTION).isAssignableFrom(this);
    }

    public final boolean isConvertableFrom(ResolvedType other) {
        if (this.equals(UnresolvedType.OBJECT)) {
            return true;
        }
        if (this.world.isInJava5Mode() && this.isPrimitiveType() ^ other.isPrimitiveType() && validBoxing.contains(this.getSignature() + other.getSignature())) {
            return true;
        }
        if (this.isPrimitiveType() || other.isPrimitiveType()) {
            return this.isAssignableFrom(other);
        }
        return this.isCoerceableFrom(other);
    }

    public abstract boolean isAssignableFrom(ResolvedType var1);

    public abstract boolean isAssignableFrom(ResolvedType var1, boolean var2);

    public abstract boolean isCoerceableFrom(ResolvedType var1);

    public boolean needsNoConversionFrom(ResolvedType o) {
        return this.isAssignableFrom(o);
    }

    public String getSignatureForAttribute() {
        return this.signature;
    }

    public boolean isParameterizedWithTypeVariable() {
        if (this.parameterizedWithTypeVariable == FuzzyBoolean.MAYBE) {
            if (this.typeParameters == null || this.typeParameters.length == 0) {
                this.parameterizedWithTypeVariable = FuzzyBoolean.NO;
                return false;
            }
            for (int i = 0; i < this.typeParameters.length; ++i) {
                boolean b;
                boolean b2;
                ResolvedType aType = (ResolvedType)this.typeParameters[i];
                if (aType.isTypeVariableReference()) {
                    this.parameterizedWithTypeVariable = FuzzyBoolean.YES;
                    return true;
                }
                if (aType.isParameterizedType() && (b2 = aType.isParameterizedWithTypeVariable())) {
                    this.parameterizedWithTypeVariable = FuzzyBoolean.YES;
                    return true;
                }
                if (!aType.isGenericWildcard()) continue;
                BoundedReferenceType boundedRT = (BoundedReferenceType)aType;
                if (boundedRT.isExtends()) {
                    b = false;
                    UnresolvedType upperBound = boundedRT.getUpperBound();
                    if (upperBound.isParameterizedType()) {
                        b = ((ResolvedType)upperBound).isParameterizedWithTypeVariable();
                    } else if (upperBound.isTypeVariableReference() && ((TypeVariableReference)((Object)upperBound)).getTypeVariable().getDeclaringElementKind() == 1) {
                        b = true;
                    }
                    if (b) {
                        this.parameterizedWithTypeVariable = FuzzyBoolean.YES;
                        return true;
                    }
                }
                if (!boundedRT.isSuper()) continue;
                b = false;
                UnresolvedType lowerBound = boundedRT.getLowerBound();
                if (lowerBound.isParameterizedType()) {
                    b = ((ResolvedType)lowerBound).isParameterizedWithTypeVariable();
                } else if (lowerBound.isTypeVariableReference() && ((TypeVariableReference)((Object)lowerBound)).getTypeVariable().getDeclaringElementKind() == 1) {
                    b = true;
                }
                if (!b) continue;
                this.parameterizedWithTypeVariable = FuzzyBoolean.YES;
                return true;
            }
            this.parameterizedWithTypeVariable = FuzzyBoolean.NO;
        }
        return this.parameterizedWithTypeVariable.alwaysTrue();
    }

    protected boolean ajMembersNeedParameterization() {
        if (this.isParameterizedType()) {
            return true;
        }
        if (this.getSuperclass() != null) {
            return this.getSuperclass().ajMembersNeedParameterization();
        }
        return false;
    }

    protected Map getAjMemberParameterizationMap() {
        Map myMap = this.getMemberParameterizationMap();
        if (myMap.isEmpty() && this.getSuperclass() != null) {
            return this.getSuperclass().getAjMemberParameterizationMap();
        }
        return myMap;
    }

    public void setBinaryPath(String binaryPath) {
        this.binaryPath = binaryPath;
    }

    public String getBinaryPath() {
        return this.binaryPath;
    }

    public abstract /* synthetic */ boolean hasAnnotation(UnresolvedType var1);

    static {
        validBoxing.add("Ljava/lang/Byte;B");
        validBoxing.add("Ljava/lang/Character;C");
        validBoxing.add("Ljava/lang/Double;D");
        validBoxing.add("Ljava/lang/Float;F");
        validBoxing.add("Ljava/lang/Integer;I");
        validBoxing.add("Ljava/lang/Long;J");
        validBoxing.add("Ljava/lang/Short;S");
        validBoxing.add("Ljava/lang/Boolean;Z");
        validBoxing.add("BLjava/lang/Byte;");
        validBoxing.add("CLjava/lang/Character;");
        validBoxing.add("DLjava/lang/Double;");
        validBoxing.add("FLjava/lang/Float;");
        validBoxing.add("ILjava/lang/Integer;");
        validBoxing.add("JLjava/lang/Long;");
        validBoxing.add("SLjava/lang/Short;");
        validBoxing.add("ZLjava/lang/Boolean;");
        NONE = new ResolvedType[0];
        BYTE = new Primitive("B", 1, 0);
        CHAR = new Primitive("C", 1, 1);
        DOUBLE = new Primitive("D", 2, 2);
        FLOAT = new Primitive("F", 1, 3);
        INT = new Primitive("I", 1, 4);
        LONG = new Primitive("J", 2, 5);
        SHORT = new Primitive("S", 1, 6);
        VOID = new Primitive("V", 0, 8);
        BOOLEAN = new Primitive("Z", 1, 7);
        MISSING = new Missing();
    }

    static class Missing
    extends ResolvedType {
        Missing() {
            super("@missing@", (World)null);
        }

        public final String getName() {
            return "@missing@";
        }

        public final boolean isMissing() {
            return true;
        }

        public boolean hasAnnotation(UnresolvedType ofType) {
            return false;
        }

        public final ResolvedMember[] getDeclaredFields() {
            return ResolvedMember.NONE;
        }

        public final ResolvedMember[] getDeclaredMethods() {
            return ResolvedMember.NONE;
        }

        public final ResolvedType[] getDeclaredInterfaces() {
            return NONE;
        }

        public final ResolvedMember[] getDeclaredPointcuts() {
            return ResolvedMember.NONE;
        }

        public final ResolvedType getSuperclass() {
            return null;
        }

        public final int getModifiers() {
            return 0;
        }

        public final boolean isAssignableFrom(ResolvedType other) {
            return false;
        }

        public final boolean isAssignableFrom(ResolvedType other, boolean allowMissing) {
            return false;
        }

        public final boolean isCoerceableFrom(ResolvedType other) {
            return false;
        }

        public boolean needsNoConversionFrom(ResolvedType other) {
            return false;
        }

        public ISourceContext getSourceContext() {
            return null;
        }
    }

    static class Primitive
    extends ResolvedType {
        private final int size;
        private final int index;
        private static final boolean[][] assignTable = new boolean[][]{{true, true, true, true, true, true, true, false, false}, {false, true, true, true, true, true, false, false, false}, {false, false, true, false, false, false, false, false, false}, {false, false, true, true, false, false, false, false, false}, {false, false, true, true, true, true, false, false, false}, {false, false, true, true, false, true, false, false, false}, {false, false, true, true, true, true, true, false, false}, {false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, true}};
        private static final boolean[][] noConvertTable = new boolean[][]{{true, true, false, false, true, false, true, false, false}, {false, true, false, false, true, false, false, false, false}, {false, false, true, false, false, false, false, false, false}, {false, false, false, true, false, false, false, false, false}, {false, false, false, false, true, false, false, false, false}, {false, false, false, false, false, true, false, false, false}, {false, false, false, false, true, false, true, false, false}, {false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, true}};

        Primitive(String signature, int size, int index) {
            super(signature, (World)null);
            this.size = size;
            this.index = index;
            this.typeKind = UnresolvedType.TypeKind.PRIMITIVE;
        }

        public final int getSize() {
            return this.size;
        }

        public final int getModifiers() {
            return 17;
        }

        public final boolean isPrimitiveType() {
            return true;
        }

        public boolean hasAnnotation(UnresolvedType ofType) {
            return false;
        }

        public final boolean isAssignableFrom(ResolvedType other) {
            if (!other.isPrimitiveType()) {
                if (!this.world.isInJava5Mode()) {
                    return false;
                }
                return validBoxing.contains(this.getSignature() + other.getSignature());
            }
            return assignTable[((Primitive)other).index][this.index];
        }

        public final boolean isAssignableFrom(ResolvedType other, boolean allowMissing) {
            return this.isAssignableFrom(other);
        }

        public final boolean isCoerceableFrom(ResolvedType other) {
            if (this == other) {
                return true;
            }
            if (!other.isPrimitiveType()) {
                return false;
            }
            return this.index <= 6 && ((Primitive)other).index <= 6;
        }

        public ResolvedType resolve(World world) {
            this.world = world;
            return super.resolve(world);
        }

        public final boolean needsNoConversionFrom(ResolvedType other) {
            if (!other.isPrimitiveType()) {
                return false;
            }
            return noConvertTable[((Primitive)other).index][this.index];
        }

        public final ResolvedMember[] getDeclaredFields() {
            return ResolvedMember.NONE;
        }

        public final ResolvedMember[] getDeclaredMethods() {
            return ResolvedMember.NONE;
        }

        public final ResolvedType[] getDeclaredInterfaces() {
            return NONE;
        }

        public final ResolvedMember[] getDeclaredPointcuts() {
            return ResolvedMember.NONE;
        }

        public final ResolvedType getSuperclass() {
            return null;
        }

        public ISourceContext getSourceContext() {
            return null;
        }
    }
}

