/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;
import org.aspectj.asm.IRelationshipMap;
import org.aspectj.asm.internal.ProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.Checker;
import org.aspectj.weaver.Lint;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelShadow;
import org.aspectj.weaver.model.AsmRelationshipUtils;
import org.aspectj.weaver.patterns.DeclareErrorOrWarning;
import org.aspectj.weaver.patterns.Pointcut;

public class AsmRelationshipProvider {
    protected static AsmRelationshipProvider INSTANCE = new AsmRelationshipProvider();
    public static final String ADVISES = "advises";
    public static final String ADVISED_BY = "advised by";
    public static final String DECLARES_ON = "declares on";
    public static final String DECLAREDY_BY = "declared by";
    public static final String SOFTENS = "softens";
    public static final String SOFTENED_BY = "softened by";
    public static final String MATCHED_BY = "matched by";
    public static final String MATCHES_DECLARE = "matches declare";
    public static final String INTER_TYPE_DECLARES = "declared on";
    public static final String INTER_TYPE_DECLARED_BY = "aspect declarations";
    public static final String ANNOTATES = "annotates";
    public static final String ANNOTATED_BY = "annotated by";

    public static void checkerMunger(AsmManager asm, Shadow shadow, Checker checker) {
        IProgramElement targetNode;
        if (asm == null) {
            return;
        }
        if (shadow.getSourceLocation() == null || checker.getSourceLocation() == null) {
            return;
        }
        if (World.createInjarHierarchy) {
            AsmRelationshipProvider.createHierarchy(asm, checker);
        }
        if ((targetNode = AsmRelationshipProvider.getNode(asm, shadow)) == null) {
            return;
        }
        String targetHandle = asm.getHandleProvider().createHandleIdentifier(targetNode);
        if (targetHandle == null) {
            return;
        }
        IProgramElement sourceNode = asm.getHierarchy().findElementForSourceLine(checker.getSourceLocation());
        String sourceHandle = asm.getHandleProvider().createHandleIdentifier(sourceNode);
        if (sourceHandle == null) {
            return;
        }
        IRelationshipMap mapper = asm.getRelationshipMap();
        IRelationship foreward = mapper.get(sourceHandle, IRelationship.Kind.DECLARE, MATCHED_BY, false, true);
        foreward.addTarget(targetHandle);
        IRelationship back = mapper.get(targetHandle, IRelationship.Kind.DECLARE, MATCHES_DECLARE, false, true);
        if (back != null && back.getTargets() != null) {
            back.addTarget(sourceHandle);
        }
        if (sourceNode.getSourceLocation() != null) {
            asm.addAspectInEffectThisBuild(sourceNode.getSourceLocation().getSourceFile());
        }
    }

    public void addRelationship(AsmManager asm, ResolvedType onType, ResolvedTypeMunger munger, ResolvedType originatingAspect) {
        if (asm == null) {
            return;
        }
        if (originatingAspect.getSourceLocation() != null) {
            String sourceHandle = "";
            IProgramElement sourceNode = null;
            if (munger.getSourceLocation() != null && munger.getSourceLocation().getOffset() != -1) {
                sourceNode = asm.getHierarchy().findElementForSourceLine(munger.getSourceLocation());
                sourceHandle = asm.getHandleProvider().createHandleIdentifier(sourceNode);
            } else {
                sourceNode = asm.getHierarchy().findElementForSourceLine(originatingAspect.getSourceLocation());
                sourceHandle = asm.getHandleProvider().createHandleIdentifier(sourceNode);
            }
            if (sourceHandle == null) {
                return;
            }
            IProgramElement targetNode = asm.getHierarchy().findElementForSourceLine(onType.getSourceLocation());
            String targetHandle = asm.getHandleProvider().createHandleIdentifier(targetNode);
            if (targetHandle == null) {
                return;
            }
            IRelationshipMap mapper = asm.getRelationshipMap();
            IRelationship foreward = mapper.get(sourceHandle, IRelationship.Kind.DECLARE_INTER_TYPE, INTER_TYPE_DECLARES, false, true);
            foreward.addTarget(targetHandle);
            IRelationship back = mapper.get(targetHandle, IRelationship.Kind.DECLARE_INTER_TYPE, INTER_TYPE_DECLARED_BY, false, true);
            back.addTarget(sourceHandle);
            asm.addAspectInEffectThisBuild(sourceNode.getSourceLocation().getSourceFile());
        }
    }

    public void addDeclareAnnotationRelationship(AsmManager asm, ISourceLocation declareAnnotationLocation, ISourceLocation annotatedLocation) {
        if (asm == null) {
            return;
        }
        IProgramElement sourceNode = asm.getHierarchy().findElementForSourceLine(declareAnnotationLocation);
        String sourceHandle = asm.getHandleProvider().createHandleIdentifier(sourceNode);
        if (sourceHandle == null) {
            return;
        }
        IProgramElement targetNode = asm.getHierarchy().findElementForSourceLine(annotatedLocation);
        String targetHandle = asm.getHandleProvider().createHandleIdentifier(targetNode);
        if (targetHandle == null) {
            return;
        }
        IRelationshipMap mapper = asm.getRelationshipMap();
        IRelationship foreward = mapper.get(sourceHandle, IRelationship.Kind.DECLARE_INTER_TYPE, ANNOTATES, false, true);
        foreward.addTarget(targetHandle);
        IRelationship back = mapper.get(targetHandle, IRelationship.Kind.DECLARE_INTER_TYPE, ANNOTATED_BY, false, true);
        back.addTarget(sourceHandle);
        if (sourceNode.getSourceLocation() != null) {
            asm.addAspectInEffectThisBuild(sourceNode.getSourceLocation().getSourceFile());
        }
    }

    public static void createHierarchy(AsmManager asm, ShadowMunger munger) {
        if (!munger.isBinary()) {
            return;
        }
        IProgramElement sourceFileNode = asm.getHierarchy().findElementForSourceLine(munger.getSourceLocation());
        if (!sourceFileNode.getKind().equals(IProgramElement.Kind.FILE_JAVA)) {
            return;
        }
        ResolvedType aspect = munger.getDeclaringType();
        ProgramElement classFileNode = new ProgramElement(asm, sourceFileNode.getName(), IProgramElement.Kind.FILE, munger.getBinarySourceLocation(aspect.getSourceLocation()), 0, null, null);
        IProgramElement root = asm.getHierarchy().getRoot();
        IProgramElement binaries = asm.getHierarchy().findElementForLabel(root, IProgramElement.Kind.SOURCE_FOLDER, "binaries");
        if (binaries == null) {
            binaries = new ProgramElement(asm, "binaries", IProgramElement.Kind.SOURCE_FOLDER, new ArrayList());
            root.addChild(binaries);
        }
        String packagename = aspect.getPackageName() == null ? "" : aspect.getPackageName();
        IProgramElement pkgNode = asm.getHierarchy().findElementForLabel(binaries, IProgramElement.Kind.PACKAGE, packagename);
        if (pkgNode == null) {
            pkgNode = new ProgramElement(asm, packagename, IProgramElement.Kind.PACKAGE, new ArrayList());
            binaries.addChild(pkgNode);
            pkgNode.addChild(classFileNode);
        } else {
            pkgNode.addChild(classFileNode);
            Iterator iter = pkgNode.getChildren().iterator();
            while (iter.hasNext()) {
                IProgramElement element = (IProgramElement)iter.next();
                if (element.equals(classFileNode) || !element.getHandleIdentifier().equals(classFileNode.getHandleIdentifier())) continue;
                pkgNode.removeChild(classFileNode);
                return;
            }
        }
        classFileNode.addChild(new ProgramElement(asm, "import declarations", IProgramElement.Kind.IMPORT_REFERENCE, null, 0, null, null));
        ProgramElement aspectNode = new ProgramElement(asm, aspect.getSimpleName(), IProgramElement.Kind.ASPECT, munger.getBinarySourceLocation(aspect.getSourceLocation()), aspect.getModifiers(), null, null);
        classFileNode.addChild(aspectNode);
        AsmRelationshipProvider.addChildNodes(asm, munger, (IProgramElement)aspectNode, aspect.getDeclaredPointcuts());
        AsmRelationshipProvider.addChildNodes(asm, munger, (IProgramElement)aspectNode, aspect.getDeclaredAdvice());
        AsmRelationshipProvider.addChildNodes(asm, munger, (IProgramElement)aspectNode, aspect.getDeclares());
    }

    private static void addChildNodes(AsmManager asm, ShadowMunger munger, IProgramElement parent, ResolvedMember[] children) {
        for (int i = 0; i < children.length; ++i) {
            ISourceLocation sLoc;
            ResolvedMember pcd = children[i];
            if (!(pcd instanceof ResolvedPointcutDefinition)) continue;
            ResolvedPointcutDefinition rpcd = (ResolvedPointcutDefinition)pcd;
            Pointcut p = rpcd.getPointcut();
            ISourceLocation iSourceLocation = sLoc = p == null ? null : p.getSourceLocation();
            if (sLoc == null) {
                sLoc = rpcd.getSourceLocation();
            }
            parent.addChild(new ProgramElement(asm, pcd.getName(), IProgramElement.Kind.POINTCUT, munger.getBinarySourceLocation(sLoc), pcd.getModifiers(), null, Collections.EMPTY_LIST));
        }
    }

    private static void addChildNodes(AsmManager asm, ShadowMunger munger, IProgramElement parent, Collection children) {
        int deCtr = 1;
        int dwCtr = 1;
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof DeclareErrorOrWarning) {
                DeclareErrorOrWarning decl = (DeclareErrorOrWarning)element;
                int counter = 0;
                counter = decl.isError() ? deCtr++ : dwCtr++;
                parent.addChild(AsmRelationshipProvider.createDeclareErrorOrWarningChild(asm, munger, decl, counter));
                continue;
            }
            if (!(element instanceof Advice)) continue;
            Advice advice = (Advice)element;
            parent.addChild(AsmRelationshipProvider.createAdviceChild(asm, advice));
        }
    }

    private static IProgramElement createDeclareErrorOrWarningChild(AsmManager asm, ShadowMunger munger, DeclareErrorOrWarning decl, int count) {
        ProgramElement deowNode = new ProgramElement(asm, decl.getName(), decl.isError() ? IProgramElement.Kind.DECLARE_ERROR : IProgramElement.Kind.DECLARE_WARNING, munger.getBinarySourceLocation(decl.getSourceLocation()), decl.getDeclaringType().getModifiers(), null, null);
        deowNode.setDetails("\"" + AsmRelationshipUtils.genDeclareMessage(decl.getMessage()) + "\"");
        if (count != -1) {
            deowNode.setBytecodeName(decl.getName() + "_" + count);
        }
        return deowNode;
    }

    private static IProgramElement createAdviceChild(AsmManager asm, Advice advice) {
        ProgramElement adviceNode = new ProgramElement(asm, advice.getKind().getName(), IProgramElement.Kind.ADVICE, advice.getBinarySourceLocation(advice.getSourceLocation()), advice.getSignature().getModifiers(), null, Collections.EMPTY_LIST);
        adviceNode.setDetails(AsmRelationshipUtils.genPointcutDetails(advice.getPointcut()));
        adviceNode.setBytecodeName(advice.getSignature().getName());
        return adviceNode;
    }

    public static String getHandle(Advice advice, AsmManager asm) {
        ISourceLocation sl;
        if (null == advice.handle && (sl = advice.getSourceLocation()) != null) {
            IProgramElement ipe = asm.getHierarchy().findElementForSourceLine(sl);
            advice.handle = asm.getHandleProvider().createHandleIdentifier(ipe);
        }
        return advice.handle;
    }

    public static void adviceMunger(AsmManager asm, Shadow shadow, ShadowMunger munger) {
        if (asm == null) {
            return;
        }
        if (munger instanceof Advice) {
            Advice advice = (Advice)munger;
            if (advice.getKind().isPerEntry() || advice.getKind().isCflow()) {
                return;
            }
            if (World.createInjarHierarchy) {
                AsmRelationshipProvider.createHierarchy(asm, advice);
            }
            IRelationshipMap mapper = asm.getRelationshipMap();
            IProgramElement targetNode = AsmRelationshipProvider.getNode(asm, shadow);
            if (targetNode == null) {
                return;
            }
            boolean runtimeTest = advice.hasDynamicTests();
            IProgramElement.ExtraInformation ai = new IProgramElement.ExtraInformation();
            String adviceHandle = AsmRelationshipProvider.getHandle(advice, asm);
            if (adviceHandle == null) {
                return;
            }
            AdviceKind ak = ((Advice)munger).getKind();
            ai.setExtraAdviceInformation(ak.getName());
            IProgramElement adviceElement = asm.getHierarchy().findElementForHandle(adviceHandle);
            if (adviceElement != null) {
                adviceElement.setExtraInfo(ai);
            }
            String targetHandle = targetNode.getHandleIdentifier();
            if (advice.getKind().equals(AdviceKind.Softener)) {
                IRelationship back;
                IRelationship foreward = mapper.get(adviceHandle, IRelationship.Kind.DECLARE_SOFT, SOFTENS, runtimeTest, true);
                if (foreward != null) {
                    foreward.addTarget(targetHandle);
                }
                if ((back = mapper.get(targetHandle, IRelationship.Kind.DECLARE, SOFTENED_BY, runtimeTest, true)) != null) {
                    back.addTarget(adviceHandle);
                }
            } else {
                IRelationship back;
                IRelationship foreward = mapper.get(adviceHandle, IRelationship.Kind.ADVICE, ADVISES, runtimeTest, true);
                if (foreward != null) {
                    foreward.addTarget(targetHandle);
                }
                if ((back = mapper.get(targetHandle, IRelationship.Kind.ADVICE, ADVISED_BY, runtimeTest, true)) != null) {
                    back.addTarget(adviceHandle);
                }
            }
            if (adviceElement.getSourceLocation() != null) {
                asm.addAspectInEffectThisBuild(adviceElement.getSourceLocation().getSourceFile());
            }
        }
    }

    protected static IProgramElement getNode(AsmManager model, Shadow shadow) {
        UnresolvedType actualType;
        UnresolvedType type;
        Member actualEnclosingMember;
        Member enclosingMember = shadow.getEnclosingCodeSignature();
        IProgramElement enclosingNode = null;
        enclosingNode = shadow instanceof BcelShadow ? ((actualEnclosingMember = ((BcelShadow)shadow).getRealEnclosingCodeSignature()) == null ? AsmRelationshipProvider.lookupMember(model.getHierarchy(), shadow.getEnclosingType(), enclosingMember) : ((type = enclosingMember.getDeclaringType()).equals(actualType = actualEnclosingMember.getDeclaringType()) ? AsmRelationshipProvider.lookupMember(model.getHierarchy(), shadow.getEnclosingType(), enclosingMember) : AsmRelationshipProvider.lookupMember(model.getHierarchy(), shadow.getEnclosingType(), actualEnclosingMember))) : AsmRelationshipProvider.lookupMember(model.getHierarchy(), shadow.getEnclosingType(), enclosingMember);
        if (enclosingNode == null) {
            Lint.Kind err = shadow.getIWorld().getLint().shadowNotInStructure;
            if (err.isEnabled()) {
                err.signal(shadow.toString(), shadow.getSourceLocation());
            }
            return null;
        }
        Member shadowSig = shadow.getSignature();
        if (shadow.getKind() == Shadow.MethodCall || !shadowSig.equals(enclosingMember)) {
            IProgramElement bodyNode = AsmRelationshipProvider.findOrCreateCodeNode(model, enclosingNode, shadowSig, shadow);
            return bodyNode;
        }
        return enclosingNode;
    }

    private static boolean sourceLinesMatch(ISourceLocation loc1, ISourceLocation loc2) {
        return loc1.getLine() == loc2.getLine();
    }

    private static IProgramElement findOrCreateCodeNode(AsmManager asm, IProgramElement enclosingNode, Member shadowSig, Shadow shadow) {
        Iterator it = enclosingNode.getChildren().iterator();
        while (it.hasNext()) {
            IProgramElement node = (IProgramElement)it.next();
            int excl = node.getBytecodeName().lastIndexOf(33);
            if ((excl == -1 || !shadowSig.getName().equals(node.getBytecodeName().substring(0, excl))) && !shadowSig.getName().equals(node.getBytecodeName()) || !shadowSig.getSignature().equals(node.getBytecodeSignature()) || !AsmRelationshipProvider.sourceLinesMatch(node.getSourceLocation(), shadow.getSourceLocation())) continue;
            return node;
        }
        ISourceLocation sl = shadow.getSourceLocation();
        SourceLocation peLoc = new SourceLocation(enclosingNode.getSourceLocation().getSourceFile(), sl.getLine());
        peLoc.setOffset(sl.getOffset());
        ProgramElement peNode = new ProgramElement(asm, shadow.toString(), IProgramElement.Kind.CODE, peLoc, 0, null, null);
        int numberOfChildrenWithThisName = 0;
        Iterator it2 = enclosingNode.getChildren().iterator();
        while (it2.hasNext()) {
            IProgramElement child = (IProgramElement)it2.next();
            if (!child.getName().equals(shadow.toString())) continue;
            ++numberOfChildrenWithThisName;
        }
        peNode.setBytecodeName(shadowSig.getName() + "!" + String.valueOf(numberOfChildrenWithThisName + 1));
        peNode.setBytecodeSignature(shadowSig.getSignature());
        enclosingNode.addChild(peNode);
        return peNode;
    }

    protected static IProgramElement lookupMember(IHierarchy model, Member member) {
        UnresolvedType declaringType = member.getDeclaringType();
        IProgramElement classNode = model.findElementForType(declaringType.getPackageName(), declaringType.getClassName());
        return AsmRelationshipProvider.findMemberInClass(classNode, member);
    }

    protected static IProgramElement lookupMember(IHierarchy model, UnresolvedType declaringType, Member member) {
        IProgramElement classNode = model.findElementForType(declaringType.getPackageName(), declaringType.getClassName());
        return AsmRelationshipProvider.findMemberInClass(classNode, member);
    }

    protected static IProgramElement findMemberInClass(IProgramElement classNode, Member member) {
        if (classNode == null) {
            return null;
        }
        Iterator it = classNode.getChildren().iterator();
        while (it.hasNext()) {
            IProgramElement node = (IProgramElement)it.next();
            if (!member.getName().equals(node.getBytecodeName()) || !member.getSignature().equals(node.getBytecodeSignature())) continue;
            return node;
        }
        return classNode;
    }

    public static AsmRelationshipProvider getDefault() {
        return INSTANCE;
    }

    public void addDeclareAnnotationMethodRelationship(ISourceLocation sourceLocation, String typename, ResolvedMember method, AsmManager structureModel) {
        IHierarchy hierarchy;
        IProgramElement typeElem;
        if (structureModel == null) {
            return;
        }
        String pkg = null;
        String type = typename;
        int packageSeparator = typename.lastIndexOf(".");
        if (packageSeparator != -1) {
            pkg = typename.substring(0, packageSeparator);
            type = typename.substring(packageSeparator + 1);
        }
        if ((typeElem = (hierarchy = structureModel.getHierarchy()).findElementForType(pkg, type)) == null) {
            return;
        }
        StringBuffer parmString = new StringBuffer("(");
        UnresolvedType[] args = method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            String s = args[i].getName();
            parmString.append(s);
            if (i + 1 >= args.length) continue;
            parmString.append(",");
        }
        parmString.append(")");
        IProgramElement methodElem = null;
        if (method.getName().startsWith("<init>")) {
            methodElem = hierarchy.findElementForSignature(typeElem, IProgramElement.Kind.CONSTRUCTOR, type + parmString);
            if (methodElem == null && args.length == 0) {
                methodElem = typeElem;
            }
        } else {
            methodElem = hierarchy.findElementForSignature(typeElem, IProgramElement.Kind.METHOD, method.getName() + parmString);
        }
        if (methodElem == null) {
            return;
        }
        try {
            String targetHandle = methodElem.getHandleIdentifier();
            if (targetHandle == null) {
                return;
            }
            IProgramElement sourceNode = hierarchy.findElementForSourceLine(sourceLocation);
            String sourceHandle = structureModel.getHandleProvider().createHandleIdentifier(sourceNode);
            if (sourceHandle == null) {
                return;
            }
            IRelationshipMap mapper = structureModel.getRelationshipMap();
            IRelationship foreward = mapper.get(sourceHandle, IRelationship.Kind.DECLARE_INTER_TYPE, ANNOTATES, false, true);
            foreward.addTarget(targetHandle);
            IRelationship back = mapper.get(targetHandle, IRelationship.Kind.DECLARE_INTER_TYPE, ANNOTATED_BY, false, true);
            back.addTarget(sourceHandle);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void addDeclareAnnotationFieldRelationship(AsmManager asm, ISourceLocation sourceLocation, String typename, ResolvedMember field) {
        IHierarchy hierarchy;
        IProgramElement typeElem;
        if (asm == null) {
            return;
        }
        String pkg = null;
        String type = typename;
        int packageSeparator = typename.lastIndexOf(".");
        if (packageSeparator != -1) {
            pkg = typename.substring(0, packageSeparator);
            type = typename.substring(packageSeparator + 1);
        }
        if ((typeElem = (hierarchy = asm.getHierarchy()).findElementForType(pkg, type)) == null) {
            return;
        }
        IProgramElement fieldElem = hierarchy.findElementForSignature(typeElem, IProgramElement.Kind.FIELD, field.getName());
        if (fieldElem == null) {
            return;
        }
        String targetHandle = fieldElem.getHandleIdentifier();
        if (targetHandle == null) {
            return;
        }
        IProgramElement sourceNode = hierarchy.findElementForSourceLine(sourceLocation);
        String sourceHandle = asm.getHandleProvider().createHandleIdentifier(sourceNode);
        if (sourceHandle == null) {
            return;
        }
        IRelationshipMap mapper = asm.getRelationshipMap();
        IRelationship foreward = mapper.get(sourceHandle, IRelationship.Kind.DECLARE_INTER_TYPE, ANNOTATES, false, true);
        foreward.addTarget(targetHandle);
        IRelationship back = mapper.get(targetHandle, IRelationship.Kind.DECLARE_INTER_TYPE, ANNOTATED_BY, false, true);
        back.addTarget(sourceHandle);
    }
}

