/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;

public class TypeAnnotationGen {
    public static final TypeAnnotationGen[] NO_TYPE_ANNOTATIONS = new TypeAnnotationGen[0];
    public static final int[] NO_TYPE_PATH = new int[0];
    private ConstantPool cpool;
    private int targetType;
    private int[] typePath;
    private AnnotationGen annotation;
    private int info;
    private int info2;
    private int[] localVarTarget;
    public static final int CLASS_TYPE_PARAMETER = 0;
    public static final int METHOD_TYPE_PARAMETER = 1;
    public static final int CLASS_EXTENDS = 16;
    public static final int CLASS_TYPE_PARAMETER_BOUND = 17;
    public static final int METHOD_TYPE_PARAMETER_BOUND = 18;
    public static final int FIELD = 19;
    public static final int METHOD_RETURN = 20;
    public static final int METHOD_RECEIVER = 21;
    public static final int METHOD_FORMAL_PARAMETER = 22;
    public static final int THROWS = 23;
    public static final int LOCAL_VARIABLE = 64;
    public static final int RESOURCE_VARIABLE = 65;
    public static final int EXCEPTION_PARAMETER = 66;
    public static final int INSTANCEOF = 67;
    public static final int NEW = 68;
    public static final int CONSTRUCTOR_REFERENCE = 69;
    public static final int METHOD_REFERENCE = 70;
    public static final int CAST = 71;
    public static final int CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT = 72;
    public static final int METHOD_INVOCATION_TYPE_ARGUMENT = 73;
    public static final int CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT = 74;
    public static final int METHOD_REFERENCE_TYPE_ARGUMENT = 75;
    public static final int TYPE_PATH_ENTRY_KIND_ARRAY = 0;
    public static final int TYPE_PATH_ENTRY_KIND_INNER_TYPE = 1;
    public static final int TYPE_PATH_ENTRY_KIND_WILDCARD = 2;
    public static final int TYPE_PATH_ENTRY_KIND_TYPE_ARGUMENT = 3;

    private TypeAnnotationGen(ConstantPool constantPool) {
        this.cpool = constantPool;
    }

    public static TypeAnnotationGen read(DataInputStream dataInputStream, ConstantPool constantPool, boolean bl) throws IOException {
        int n;
        TypeAnnotationGen typeAnnotationGen = new TypeAnnotationGen(constantPool);
        typeAnnotationGen.targetType = dataInputStream.readUnsignedByte();
        switch (typeAnnotationGen.targetType) {
            case 0: {
                typeAnnotationGen.info = dataInputStream.readUnsignedByte();
                break;
            }
            case 1: {
                typeAnnotationGen.info = dataInputStream.readUnsignedByte();
                break;
            }
            case 16: {
                n = dataInputStream.readUnsignedShort();
                if (n == 65535) {
                    typeAnnotationGen.info = -1;
                    break;
                }
                typeAnnotationGen.info = n;
                break;
            }
            case 17: 
            case 18: {
                typeAnnotationGen.info = dataInputStream.readUnsignedByte();
                typeAnnotationGen.info2 = dataInputStream.readUnsignedByte();
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 22: {
                typeAnnotationGen.info = dataInputStream.readUnsignedByte();
                break;
            }
            case 23: {
                typeAnnotationGen.info = dataInputStream.readUnsignedShort();
                break;
            }
            case 64: 
            case 65: {
                typeAnnotationGen.localVarTarget = TypeAnnotationGen.readLocalVarTarget(dataInputStream);
                break;
            }
            case 66: {
                typeAnnotationGen.info = dataInputStream.readUnsignedByte();
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                typeAnnotationGen.info = dataInputStream.readUnsignedShort();
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                typeAnnotationGen.info = dataInputStream.readUnsignedShort();
                typeAnnotationGen.info2 = dataInputStream.readUnsignedByte();
                break;
            }
            default: {
                throw new IllegalStateException("nyi " + typeAnnotationGen.targetType);
            }
        }
        n = dataInputStream.readUnsignedByte();
        if (n == 0) {
            typeAnnotationGen.typePath = NO_TYPE_PATH;
        } else {
            typeAnnotationGen.typePath = new int[n * 2];
            int n2 = n * 2;
            for (int i = 0; i < n2; ++i) {
                typeAnnotationGen.typePath[i] = dataInputStream.readUnsignedByte();
            }
        }
        typeAnnotationGen.annotation = AnnotationGen.read(dataInputStream, constantPool, bl);
        return typeAnnotationGen;
    }

    public static int[] readLocalVarTarget(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        int[] nArray = new int[n * 3];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            nArray[n2++] = dataInputStream.readUnsignedShort();
            nArray[n2++] = dataInputStream.readUnsignedShort();
            nArray[n2++] = dataInputStream.readUnsignedShort();
        }
        return nArray;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        int n;
        dataOutputStream.writeByte(this.targetType);
        switch (this.targetType) {
            case 0: {
                dataOutputStream.writeByte(this.info);
                break;
            }
            case 1: {
                dataOutputStream.writeByte(this.info);
                break;
            }
            case 16: {
                dataOutputStream.writeShort(this.info);
                break;
            }
            case 17: 
            case 18: {
                dataOutputStream.writeByte(this.info);
                dataOutputStream.writeByte(this.info2);
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 22: {
                dataOutputStream.writeByte(this.info);
                break;
            }
            case 23: {
                dataOutputStream.writeShort(this.info);
                break;
            }
            case 64: 
            case 65: {
                dataOutputStream.writeShort(this.localVarTarget.length / 3);
                for (n = 0; n < this.localVarTarget.length; ++n) {
                    dataOutputStream.writeShort(this.localVarTarget[n]);
                }
                break;
            }
            case 66: {
                dataOutputStream.writeByte(this.info);
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                dataOutputStream.writeShort(this.info);
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                dataOutputStream.writeShort(this.info);
                dataOutputStream.writeByte(this.info);
                break;
            }
            default: {
                throw new IllegalStateException("nyi " + this.targetType);
            }
        }
        dataOutputStream.writeByte(this.typePath.length);
        for (n = 0; n < this.typePath.length; ++n) {
            dataOutputStream.writeByte(this.typePath[n]);
        }
        this.annotation.dump(dataOutputStream);
    }

    public int getSupertypeIndex() {
        assert (this.targetType == 16);
        return this.info;
    }

    public int getOffset() {
        assert (this.targetType == 67 || this.targetType == 68 || this.targetType == 69 || this.targetType == 70 || this.targetType == 71 || this.targetType == 72 || this.targetType == 73 || this.targetType == 74 || this.targetType == 75);
        return this.info;
    }

    public int getTypeParameterIndex() {
        assert (this.targetType == 0 || this.targetType == 1 || this.targetType == 17 || this.targetType == 18);
        return this.info;
    }

    public int getTypeArgumentIndex() {
        assert (this.targetType == 71 || this.targetType == 72 || this.targetType == 73 || this.targetType == 74 || this.targetType == 75);
        return this.info2;
    }

    public int getBoundIndex() {
        assert (this.targetType == 17 || this.targetType == 18);
        return this.info2;
    }

    public int getMethodFormalParameterIndex() {
        assert (this.targetType == 22);
        return this.info;
    }

    public int getThrowsTypeIndex() {
        assert (this.targetType == 23);
        return this.info;
    }

    public int[] getLocalVarTarget() {
        assert (this.targetType == 64 || this.targetType == 65);
        return this.localVarTarget;
    }

    public int getExceptionTableIndex() {
        assert (this.targetType == 66);
        return this.info;
    }

    public int getTargetType() {
        return this.targetType;
    }

    public AnnotationGen getAnnotation() {
        return this.annotation;
    }

    public int[] getTypePath() {
        return this.typePath;
    }

    public String getTypePathString() {
        return TypeAnnotationGen.toTypePathString(this.typePath);
    }

    public static String toTypePathString(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        stringBuilder.append("[");
        while (n < nArray.length) {
            if (n > 0) {
                stringBuilder.append(",");
            }
            switch (nArray[n++]) {
                case 0: {
                    stringBuilder.append("ARRAY");
                    ++n;
                    break;
                }
                case 1: {
                    stringBuilder.append("INNER_TYPE");
                    ++n;
                    break;
                }
                case 2: {
                    stringBuilder.append("WILDCARD");
                    ++n;
                    break;
                }
                case 3: {
                    stringBuilder.append("TYPE_ARGUMENT(").append(nArray[n++]).append(")");
                }
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

