/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.generic.ClassGenException;
import org.aspectj.apache.bcel.generic.InstructionBranch;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.util.ByteSequence;

public abstract class InstructionSelect
extends InstructionBranch {
    protected int[] match;
    protected int[] indices;
    protected InstructionHandle[] targets;
    protected int fixedLength;
    protected int matchLength;
    protected int padding = 0;
    protected short length;

    InstructionSelect(short s, int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle) {
        super(s, instructionHandle);
        this.targets = instructionHandleArray;
        for (int i = 0; i < instructionHandleArray.length; ++i) {
            InstructionSelect.notifyTarget(null, instructionHandleArray[i], this);
        }
        this.match = nArray;
        this.matchLength = nArray.length;
        if (this.matchLength != instructionHandleArray.length) {
            throw new ClassGenException("Match and target array have not the same length");
        }
        this.indices = new int[this.matchLength];
    }

    protected int getTargetOffset(InstructionHandle instructionHandle) {
        if (instructionHandle == null) {
            throw new ClassGenException("Target of " + super.toString(true) + " is invalid null handle");
        }
        int n = instructionHandle.getPosition();
        if (n < 0) {
            throw new ClassGenException("Invalid branch target position offset for " + super.toString(true) + ":" + n + ":" + instructionHandle);
        }
        return n - this.positionOfThisInstruction;
    }

    @Override
    protected int updatePosition(int n, int n2) {
        this.positionOfThisInstruction += n;
        short s = this.length;
        this.padding = (4 - (this.positionOfThisInstruction + 1) % 4) % 4;
        this.length = (short)(this.fixedLength + this.padding);
        return this.length - s;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
        for (int i = 0; i < this.padding; ++i) {
            dataOutputStream.writeByte(0);
        }
        this.targetIndex = this.getTargetOffset();
        dataOutputStream.writeInt(this.targetIndex);
    }

    public InstructionSelect(short s, ByteSequence byteSequence) throws IOException {
        super(s);
        this.padding = (4 - byteSequence.getIndex() % 4) % 4;
        for (int i = 0; i < this.padding; ++i) {
            byteSequence.readByte();
        }
        this.targetIndex = byteSequence.readInt();
    }

    @Override
    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(super.toString(bl));
        if (bl) {
            for (int i = 0; i < this.matchLength; ++i) {
                String string = "null";
                if (this.targets[i] != null) {
                    string = this.targets[i].getInstruction().toString();
                }
                stringBuffer.append("(" + this.match[i] + ", " + string + " = {" + this.indices[i] + "})");
            }
        } else {
            stringBuffer.append(" ...");
        }
        return stringBuffer.toString();
    }

    public void setTarget(int n, InstructionHandle instructionHandle) {
        InstructionSelect.notifyTarget(this.targets[n], instructionHandle, this);
        this.targets[n] = instructionHandle;
    }

    @Override
    public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        boolean bl = false;
        if (this.targetInstruction == instructionHandle) {
            bl = true;
            this.setTarget(instructionHandle2);
        }
        for (int i = 0; i < this.targets.length; ++i) {
            if (this.targets[i] != instructionHandle) continue;
            bl = true;
            this.setTarget(i, instructionHandle2);
        }
        if (!bl) {
            throw new ClassGenException("Not targeting " + instructionHandle);
        }
    }

    @Override
    public boolean containsTarget(InstructionHandle instructionHandle) {
        if (this.targetInstruction == instructionHandle) {
            return true;
        }
        for (int i = 0; i < this.targets.length; ++i) {
            if (this.targets[i] != instructionHandle) continue;
            return true;
        }
        return false;
    }

    @Override
    void dispose() {
        super.dispose();
        for (int i = 0; i < this.targets.length; ++i) {
            this.targets[i].removeTargeter(this);
        }
    }

    public int[] getMatchs() {
        return this.match;
    }

    public int[] getIndices() {
        return this.indices;
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int hashCode() {
        return this.opcode * 37;
    }

    public InstructionHandle[] getTargets() {
        return this.targets;
    }

    @Override
    public int getLength() {
        return this.length;
    }
}

