/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.assertj.assertions.generator.Template;
import org.assertj.core.util.Files;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.maven.generator.AssertionsGeneratorReport;

public class Templates {
    public String templatesDirectory;
    public String assertionClass;
    public String hierarchicalAssertionConcreteClass;
    public String hierarchicalAssertionAbstractClass;
    public String objectAssertion;
    public String booleanAssertion;
    public String booleanWrapperAssertion;
    public String arrayAssertion;
    public String iterableAssertion;
    public String charAssertion;
    public String characterAssertion;
    public String realNumberAssertion;
    public String realNumberWrapperAssertion;
    public String wholeNumberAssertion;
    public String wholeNumberWrapperAssertion;
    public String assertionsEntryPointClass;
    public String assertionEntryPointMethod;
    public String softEntryPointAssertionClass;
    public String junitSoftEntryPointAssertionClass;
    public String softEntryPointAssertionMethod;
    public String bddEntryPointAssertionClass;
    public String bddEntryPointAssertionMethod;

    public List<Template> getTemplates(AssertionsGeneratorReport report) {
        if (this.templatesDirectory == null) {
            this.templatesDirectory = "./";
        }
        if (!this.templatesDirectory.endsWith("/")) {
            this.templatesDirectory = this.templatesDirectory + "/";
        }
        ArrayList<Template> userTemplates = new ArrayList<Template>();
        this.loadUserTemplate(this.assertionClass, Template.Type.ASSERT_CLASS, "'class assertions'", userTemplates, report);
        this.loadUserTemplate(this.hierarchicalAssertionConcreteClass, Template.Type.HIERARCHICAL_ASSERT_CLASS, "'hierarchical concrete class assertions'", userTemplates, report);
        this.loadUserTemplate(this.hierarchicalAssertionAbstractClass, Template.Type.ABSTRACT_ASSERT_CLASS, "'hierarchical abstract class assertions'", userTemplates, report);
        this.loadUserTemplate(this.objectAssertion, Template.Type.HAS, "'object assertions'", userTemplates, report);
        this.loadUserTemplate(this.booleanAssertion, Template.Type.IS, "'boolean assertions'", userTemplates, report);
        this.loadUserTemplate(this.booleanWrapperAssertion, Template.Type.IS_WRAPPER, "'boolean wrapper assertions'", userTemplates, report);
        this.loadUserTemplate(this.arrayAssertion, Template.Type.HAS_FOR_ARRAY, "'array assertions'", userTemplates, report);
        this.loadUserTemplate(this.iterableAssertion, Template.Type.HAS_FOR_ITERABLE, "'iterable assertions'", userTemplates, report);
        this.loadUserTemplate(this.realNumberAssertion, Template.Type.HAS_FOR_REAL_NUMBER, "'real number assertions (float, double)'", userTemplates, report);
        this.loadUserTemplate(this.realNumberWrapperAssertion, Template.Type.HAS_FOR_REAL_NUMBER_WRAPPER, "'real number wrapper assertions (Float, Double)'", userTemplates, report);
        this.loadUserTemplate(this.wholeNumberAssertion, Template.Type.HAS_FOR_WHOLE_NUMBER, "'whole number assertions (int, long, short, byte)'", userTemplates, report);
        this.loadUserTemplate(this.wholeNumberWrapperAssertion, Template.Type.HAS_FOR_WHOLE_NUMBER_WRAPPER, "'whole number has assertions (Integer, Long, Short, Byte)'", userTemplates, report);
        this.loadUserTemplate(this.charAssertion, Template.Type.HAS_FOR_CHAR, "'char assertions'", userTemplates, report);
        this.loadUserTemplate(this.characterAssertion, Template.Type.HAS_FOR_CHARACTER, "'Character assertions'", userTemplates, report);
        this.loadUserTemplate(this.assertionsEntryPointClass, Template.Type.ASSERTIONS_ENTRY_POINT_CLASS, "'assertions entry point class'", userTemplates, report);
        this.loadUserTemplate(this.assertionEntryPointMethod, Template.Type.ASSERTION_ENTRY_POINT, "'assertions entry point method'", userTemplates, report);
        this.loadUserTemplate(this.softEntryPointAssertionClass, Template.Type.SOFT_ASSERTIONS_ENTRY_POINT_CLASS, "'soft assertions entry point class'", userTemplates, report);
        this.loadUserTemplate(this.junitSoftEntryPointAssertionClass, Template.Type.JUNIT_SOFT_ASSERTIONS_ENTRY_POINT_CLASS, "'junit soft assertions entry point class'", userTemplates, report);
        this.loadUserTemplate(this.softEntryPointAssertionMethod, Template.Type.SOFT_ENTRY_POINT_METHOD_ASSERTION, "'soft assertions entry point method'", userTemplates, report);
        this.loadUserTemplate(this.bddEntryPointAssertionClass, Template.Type.BDD_ASSERTIONS_ENTRY_POINT_CLASS, "'BDD assertions entry point class'", userTemplates, report);
        this.loadUserTemplate(this.bddEntryPointAssertionMethod, Template.Type.BDD_ENTRY_POINT_METHOD_ASSERTION, "'BDD assertions entry point method'", userTemplates, report);
        return userTemplates;
    }

    @VisibleForTesting
    void loadUserTemplate(String userTemplate, Template.Type type, String templateDescription, List<Template> userTemplates, AssertionsGeneratorReport report) {
        if (userTemplate != null) {
            try {
                File templateFile = new File(this.templatesDirectory, userTemplate);
                String templateContent = Files.contentOf((File)templateFile, (String)"UTF-8");
                userTemplates.add(new Template(type, templateContent));
                report.registerUserTemplate("Using custom template for " + templateDescription + " loaded from " + this.templatesDirectory + userTemplate);
            }
            catch (Exception e) {
                report.registerUserTemplate("Use default " + templateDescription + " assertion template as we failed to to read user template from " + this.templatesDirectory + userTemplate);
            }
        }
    }
}

