/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator;

import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLDecoder;

public class Template {
    private String content;
    private final Type type;

    public Template(Type type, String templateContent) {
        this.content = templateContent;
        this.type = type;
    }

    public Template(Type type, URL url) {
        this.type = type;
        try {
            File urlFile = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
            if (!urlFile.isFile()) {
                throw new RuntimeException("Failed to read template from an URL which is not a file, URL was :" + url);
            }
            this.content = this.readContentThenClose(url.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read template from " + url, e);
        }
    }

    public Template(Type type, File file) {
        this.type = type;
        String path = file.getPath();
        try {
            this.content = this.readTemplateFile(file, file.getPath());
        }
        catch (RuntimeException e) {
            this.content = this.readTemplateFile(file, path.replace('\\', '/'));
        }
    }

    private String readTemplateFile(File file, String path) {
        try {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            return this.readContentThenClose(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read template from file " + file, e);
        }
    }

    public String getContent() {
        return this.content;
    }

    public Type getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readContentThenClose(InputStream input) throws IOException {
        InputStreamReader reader = new InputStreamReader(input);
        try {
            String string = CharStreams.toString((Readable)reader);
            return string;
        }
        finally {
            Closeables.closeQuietly((InputStream)input);
            Closeables.closeQuietly((Reader)reader);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Template template = (Template)o;
        return this.type == template.type;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public static enum Type {
        IS,
        IS_WITHOUT_NEGATION,
        IS_WRAPPER,
        IS_WRAPPER_WITHOUT_NEGATION,
        HAS,
        HAS_FOR_ARRAY,
        HAS_FOR_ITERABLE,
        HAS_FOR_PRIMITIVE,
        HAS_FOR_PRIMITIVE_WRAPPER,
        HAS_FOR_REAL_NUMBER,
        HAS_FOR_REAL_NUMBER_WRAPPER,
        HAS_FOR_WHOLE_NUMBER,
        HAS_FOR_WHOLE_NUMBER_WRAPPER,
        HAS_FOR_CHAR,
        HAS_FOR_CHARACTER,
        ASSERT_CLASS,
        HIERARCHICAL_ASSERT_CLASS,
        ABSTRACT_ASSERT_CLASS,
        ASSERTIONS_ENTRY_POINT_CLASS,
        ASSERTION_ENTRY_POINT,
        SOFT_ASSERTIONS_ENTRY_POINT_CLASS,
        JUNIT_SOFT_ASSERTIONS_ENTRY_POINT_CLASS,
        SOFT_ENTRY_POINT_METHOD_ASSERTION,
        BDD_ASSERTIONS_ENTRY_POINT_CLASS,
        BDD_ENTRY_POINT_METHOD_ASSERTION,
        BDD_SOFT_ASSERTIONS_ENTRY_POINT_CLASS,
        BDD_SOFT_ENTRY_POINT_METHOD_ASSERTION,
        JUNIT_BDD_SOFT_ASSERTIONS_ENTRY_POINT_CLASS,
        AUTO_CLOSEABLE_SOFT_ASSERTIONS_ENTRY_POINT_CLASS,
        AUTO_CLOSEABLE_BDD_SOFT_ASSERTIONS_ENTRY_POINT_CLASS;

    }
}

