/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.reflect.ClassPath;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.assertions.generator.description.Visibility;

public class ClassUtil {
    public static final String GET_PREFIX = "get";
    private static final String CLASS_SUFFIX = ".class";
    private static final Comparator<Method> GETTER_COMPARATOR = new Comparator<Method>(){

        @Override
        public int compare(Method m1, Method m2) {
            return m1.getName().compareTo(m2.getName());
        }
    };
    public static final Package JAVA_LANG_PACKAGE = Object.class.getPackage();
    private static final String CAPITAL_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final Pattern PREFIX_PATTERN;
    public static final Map<String, String> PREDICATE_PREFIXES;
    private static final Comparator<String> LONGEST_TO_SHORTEST;

    public static Set<TypeToken<?>> collectClasses(String ... classOrPackageNames) {
        return ClassUtil.collectClasses(Thread.currentThread().getContextClassLoader(), classOrPackageNames);
    }

    public static Set<TypeToken<?>> collectClasses(ClassLoader classLoader, String ... classOrPackageNames) {
        return ClassUtil.collectClasses(classLoader, false, classOrPackageNames);
    }

    public static Set<TypeToken<?>> collectClasses(ClassLoader classLoader, boolean includePrivateClasses, String ... classOrPackageNames) {
        LinkedHashSet classes = Sets.newLinkedHashSet();
        for (String classOrPackageName : classOrPackageNames) {
            TypeToken<?> clazz = ClassUtil.tryToLoadClass(classOrPackageName, classLoader);
            if (ClassUtil.isClassCandidateToAssertionsGeneration(clazz, includePrivateClasses)) {
                classes.add(clazz);
                continue;
            }
            classes.addAll(ClassUtil.getClassesInPackage(classOrPackageName, classLoader));
        }
        return classes;
    }

    private static Set<TypeToken<?>> getClassesInPackage(String packageName, ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Null class loader.");
        }
        Set<TypeToken<?>> packageClasses = ClassUtil.getPackageClassesFromClasspathFiles(packageName, classLoader);
        try {
            packageClasses.addAll(ClassUtil.getPackageClassesFromClasspathJars(packageName, classLoader));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packageClasses;
    }

    private static Set<TypeToken<?>> getPackageClassesFromClasspathJars(String packageName, ClassLoader classLoader) throws IOException {
        ImmutableSet classesInfo = ClassPath.from((ClassLoader)classLoader).getTopLevelClassesRecursive(packageName);
        HashSet<TypeToken> classesInPackage = new HashSet<TypeToken>();
        for (ClassPath.ClassInfo classInfo : classesInfo) {
            classesInPackage.add(TypeToken.of((Class)classInfo.load()));
        }
        HashSet filteredClassesInPackage = new HashSet();
        for (TypeToken classFromJar : classesInPackage) {
            if (!ClassUtil.isClassCandidateToAssertionsGeneration(classFromJar, false)) continue;
            filteredClassesInPackage.add(classFromJar);
        }
        return filteredClassesInPackage;
    }

    private static Set<TypeToken<?>> getPackageClassesFromClasspathFiles(String packageName, ClassLoader classLoader) {
        try {
            String packagePath = packageName.replace('.', File.separatorChar);
            Enumeration<URL> resources = classLoader.getResources(packagePath);
            LinkedHashSet classes = Sets.newLinkedHashSet();
            while (resources.hasMoreElements()) {
                File directory = new File(URLDecoder.decode(resources.nextElement().getPath(), "UTF-8"));
                if (!directory.canRead()) continue;
                classes.addAll(ClassUtil.getClassesInDirectory(directory, packageName, classLoader));
            }
            return classes;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(packageName + " does not appear to be a valid package (Unsupported encoding)", e);
        }
        catch (IOException ioException) {
            throw new RuntimeException("IOException was thrown when trying to get all classes for " + packageName, ioException);
        }
    }

    private static Set<TypeToken<?>> getClassesInDirectory(File directory, String packageName, ClassLoader classLoader) throws UnsupportedEncodingException {
        LinkedHashSet classes = new LinkedHashSet();
        File[] files = directory.listFiles();
        Preconditions.checkNotNull((Object)files, (String)"No files were present in directory: %s", (Object)directory);
        for (File currentFile : files) {
            String currentFileName = currentFile.getName();
            if (ClassUtil.isClass(currentFileName)) {
                try {
                    String className = packageName + '.' + StringUtils.remove((String)currentFileName, (String)CLASS_SUFFIX);
                    TypeToken<?> loadedClass = ClassUtil.loadClass(className, classLoader);
                    if (!ClassUtil.isClassCandidateToAssertionsGeneration(loadedClass, false)) continue;
                    classes.add(loadedClass);
                }
                catch (Throwable className) {}
                continue;
            }
            if (!currentFile.isDirectory()) continue;
            String subPackageName = packageName + ClassUtils.PACKAGE_SEPARATOR + currentFileName;
            String path = subPackageName.replace('.', File.separatorChar);
            URL resource = classLoader.getResource(path);
            Preconditions.checkNotNull((Object)resource, (String)"resource URL from package is null, package %s", (Object)path);
            File subDirectory = new File(URLDecoder.decode(resource.getPath(), "UTF-8"));
            Set<TypeToken<?>> classesForSubPackage = ClassUtil.getClassesInDirectory(subDirectory, subPackageName, classLoader);
            classes.addAll(classesForSubPackage);
        }
        return classes;
    }

    private static boolean isClassCandidateToAssertionsGeneration(TypeToken<?> typeToken, boolean includePrivate) {
        if (typeToken == null) {
            return false;
        }
        if (ClassUtil.isPackageInfo(typeToken)) {
            return false;
        }
        Class raw = typeToken.getRawType();
        return (includePrivate || Modifier.isPublic(raw.getModifiers())) && !raw.isAnonymousClass() && !raw.isLocalClass();
    }

    private static boolean isPackageInfo(TypeToken<?> typeToken) {
        return typeToken.getRawType().getName().contains("package-info");
    }

    private static boolean isClass(String fileName) {
        return fileName.endsWith(CLASS_SUFFIX);
    }

    private static TypeToken<?> tryToLoadClass(String className, ClassLoader classLoader) {
        try {
            return ClassUtil.loadClass(className, classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static TypeToken<?> loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return TypeToken.of(Class.forName(className, false, classLoader));
    }

    public static String propertyNameOf(Method method) {
        String methodName = method.getName();
        return ClassUtil.isPredicate(method) ? ClassUtil.booleanPropertyOf(methodName) : ClassUtil.getterProperty(methodName);
    }

    public static String propertyNameOf(Field field) {
        String fieldName = field.getName();
        return ClassUtil.isBoolean(field.getType()) ? ClassUtil.booleanPropertyOf(fieldName) : fieldName;
    }

    public static boolean inheritsCollectionOrIsIterable(Class<?> returnType) {
        return Collection.class.isAssignableFrom(returnType) || Iterable.class.equals(returnType);
    }

    public static boolean isStandardGetter(Method method) {
        return ClassUtil.isValidStandardGetterName(method.getName()) && !Void.TYPE.equals(method.getReturnType()) && method.getParameterTypes().length == 0;
    }

    public static boolean isPredicate(Method method) {
        return ClassUtil.isValidPredicateName(method.getName()) && ClassUtil.isBoolean(method.getReturnType()) && method.getParameterTypes().length == 0;
    }

    private static boolean isBoolean(Class<?> type) {
        return Boolean.TYPE.equals(type) || Boolean.class.equals(type);
    }

    private static boolean isAnnotated(Method method, Set<Class<?>> includeAnnotations, boolean isClassAnnotated) {
        if (!Void.TYPE.equals(method.getReturnType()) && method.getParameterTypes().length == 0 && !Modifier.isStatic(method.getModifiers())) {
            Annotation[] methodAnnotations = method.getAnnotations();
            return isClassAnnotated || ClassUtil.containsAny(methodAnnotations, includeAnnotations);
        }
        return false;
    }

    private static boolean containsAny(Annotation[] methodAnnotations, Set<Class<?>> includeAnnotations) {
        for (Annotation annotation : methodAnnotations) {
            if (!includeAnnotations.contains(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidGetterName(String methodName) {
        return PREFIX_PATTERN.matcher(methodName).find();
    }

    private static boolean isValidStandardGetterName(String name) {
        Matcher m = PREFIX_PATTERN.matcher(name);
        return m.find() && m.group().equals(GET_PREFIX);
    }

    public static String getPredicatePrefix(String name) {
        Matcher m = PREFIX_PATTERN.matcher(name);
        return m.find() ? m.group() : null;
    }

    public static boolean isValidPredicateName(String name) {
        Matcher m = PREFIX_PATTERN.matcher(name);
        return m.find() && PREDICATE_PREFIXES.containsKey(m.group());
    }

    public static String getNegativePredicateFor(String name) {
        Matcher m = PREFIX_PATTERN.matcher(name);
        if (m.find()) {
            return m.replaceFirst(PREDICATE_PREFIXES.get(m.group()));
        }
        return null;
    }

    public static Set<Method> declaredGetterMethodsOf(TypeToken<?> type, Set<Class<?>> includeAnnotations) {
        Class clazz = type.getRawType();
        boolean isClassAnnotated = ClassUtil.containsAny(clazz.getDeclaredAnnotations(), includeAnnotations);
        return ClassUtil.filterGetterMethods(clazz.getDeclaredMethods(), includeAnnotations, isClassAnnotated);
    }

    public static Set<Method> getterMethodsOf(TypeToken<?> type, Set<Class<?>> includeAnnotations) {
        Class clazz = type.getRawType();
        boolean isClassAnnotated = ClassUtil.containsAny(clazz.getDeclaredAnnotations(), includeAnnotations);
        return ClassUtil.filterGetterMethods(clazz.getMethods(), includeAnnotations, isClassAnnotated);
    }

    private static Set<Method> filterGetterMethods(Method[] methods, Set<Class<?>> includeAnnotations, boolean isClassAnnotated) {
        TreeSet<Method> getters = new TreeSet<Method>(GETTER_COMPARATOR);
        for (Method method : methods) {
            if (!Modifier.isPublic(method.getModifiers()) || !ClassUtil.isNotDefinedInObjectClass(method) || !ClassUtil.isGetter(method, includeAnnotations, isClassAnnotated)) continue;
            getters.add(method);
        }
        return getters;
    }

    private static boolean isGetter(Method method, Set<Class<?>> includeAnnotations, boolean isClassAnnotated) {
        return ClassUtil.isStandardGetter(method) || ClassUtil.isPredicate(method) || ClassUtil.isAnnotated(method, includeAnnotations, isClassAnnotated);
    }

    public static List<Field> nonStaticFieldsOf(TypeToken<?> clazz) {
        List<Field> fields = ClassUtil.getAllFieldsInHierarchy(clazz);
        return ClassUtil.filterNonStaticFields(fields);
    }

    private static List<Field> filterNonStaticFields(List<Field> fields) {
        ArrayList<Field> nonStaticFields = new ArrayList<Field>();
        for (Field field : fields) {
            if (!ClassUtil.isNotStaticField(field)) continue;
            nonStaticFields.add(field);
        }
        return nonStaticFields;
    }

    public static List<Field> declaredFieldsOf(TypeToken<?> type) {
        Field[] fields = type.getRawType().getDeclaredFields();
        return ClassUtil.filterNonStaticFields(Arrays.asList(fields));
    }

    public static List<Field> getAllFieldsInHierarchy(TypeToken<?> clazz) {
        ArrayList fields = Lists.newArrayList((Object[])clazz.getRawType().getDeclaredFields());
        Class parentClass = clazz.getRawType().getSuperclass();
        if (parentClass != null && !Object.class.equals(parentClass)) {
            fields.addAll(ClassUtil.getAllFieldsInHierarchy(TypeToken.of(parentClass)));
        }
        return fields;
    }

    private static boolean isNotStaticField(Field field) {
        return !Modifier.isStatic(field.getModifiers());
    }

    private static boolean isNotDefinedInObjectClass(Method method) {
        return !Object.class.equals(method.getDeclaringClass());
    }

    public static Set<Class<?>> getClassesRelatedTo(Type type) {
        HashSet classes = new HashSet();
        if (type instanceof Class) {
            classes.add((Class)type);
            return classes;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            for (Type actualTypeArgument : parameterizedType.getActualTypeArguments()) {
                if (actualTypeArgument instanceof ParameterizedType) {
                    classes.addAll(ClassUtil.getClassesRelatedTo(actualTypeArgument));
                    continue;
                }
                if (actualTypeArgument instanceof Class) {
                    classes.add((Class)actualTypeArgument);
                    continue;
                }
                if (!(actualTypeArgument instanceof GenericArrayType)) continue;
                classes.addAll(ClassUtil.getClassesRelatedTo(actualTypeArgument));
            }
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class) {
                classes.add((Class)rawType);
            }
        }
        return classes;
    }

    public static String getSimpleNameWithOuterClass(Class<?> clazz) {
        if (ClassUtil.isNotNestedClass(clazz)) {
            return clazz.getSimpleName();
        }
        String nestedClassName = clazz.getName();
        nestedClassName = nestedClassName.substring(clazz.getPackage().getName().length() + 1);
        nestedClassName = nestedClassName.replace('$', '.');
        return nestedClassName;
    }

    private static boolean isNotNestedClass(Class<?> clazz) {
        return clazz.getDeclaringClass() == null;
    }

    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ClassUtil.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = ClassUtil.getClass(componentType);
            return componentClass == null ? null : Array.newInstance(componentClass, 0).getClass();
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return wildcardType.getUpperBounds() != null ? ClassUtil.getClass(wildcardType.getUpperBounds()[0]) : (wildcardType.getLowerBounds() != null ? ClassUtil.getClass(wildcardType.getLowerBounds()[0]) : null);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            Type[] bounds = typeVariable.getBounds();
            return bounds.length > 0 ? ClassUtil.getClass(bounds[0]) : Object.class;
        }
        return null;
    }

    public static boolean isInnerPackageOf(Package child, Package parent) {
        return child != null && parent != null && child.getName().startsWith(parent.getName());
    }

    public static boolean isJavaLangType(TypeToken<?> type) {
        return type.isPrimitive() || type.isArray() || Objects.equals(JAVA_LANG_PACKAGE, type.getRawType().getPackage());
    }

    public static boolean isJavaLangType(Type type) {
        return ClassUtil.isJavaLangType(TypeToken.of((Type)type));
    }

    public static String packageOf(String fullyQualifiedType) {
        int indexOfClassName = StringUtils.indexOfAny((CharSequence)fullyQualifiedType, (String)CAPITAL_LETTERS);
        if (indexOfClassName > 0) {
            return fullyQualifiedType.substring(0, indexOfClassName - 1);
        }
        return "";
    }

    public static String getTypeDeclaration(TypeToken<?> type) {
        if (type.isArray()) {
            return ClassUtil.getTypeDeclaration(type.getComponentType()) + "[]";
        }
        if (type.isPrimitive()) {
            return type.getRawType().toString();
        }
        Class rawClass = type.getRawType();
        StringBuilder typeDeclaration = new StringBuilder("");
        if (rawClass.isMemberClass()) {
            TypeToken outerType = type.resolveType(rawClass.getEnclosingClass());
            typeDeclaration.append(ClassUtil.getTypeDeclaration(outerType)).append(".").append(rawClass.getSimpleName());
        } else if (type.getType() instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type.getType();
            String name = typeVariable.getName();
            name = StringUtils.removeAll((String)name, (String)"capture#\\d+-of\\s+");
            name = StringUtils.removeAll((String)name, (String)" class");
            typeDeclaration.append(name);
        } else if (!ClassUtil.isJavaLangType(type)) {
            typeDeclaration.append(type.getRawType().getPackage().getName()).append(".").append(rawClass.getSimpleName());
        } else {
            typeDeclaration.append(rawClass.getSimpleName());
        }
        return typeDeclaration.toString();
    }

    public static String getAssertType(TypeToken<?> type, String packageName) {
        TypeToken wrapped = type.wrap();
        Class raw = wrapped.getRawType();
        String typeName = null;
        if (ClassUtil.isJavaLangType(wrapped)) {
            try {
                String builtInName = "org.assertj.core.api." + raw.getSimpleName() + "Assert";
                Class.forName(builtInName);
                typeName = builtInName.substring(0, builtInName.length() - "Assert".length());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (typeName == null) {
            typeName = type.getRawType().getName();
        }
        return ClassUtil.resolveTypeNameInPackage(typeName + "Assert", packageName);
    }

    public static String resolveTypeNameInPackage(TypeToken<?> type, String currentPackage) {
        if (ClassUtil.isJavaLangType(type)) {
            return type.getRawType().getSimpleName();
        }
        return ClassUtil.resolveTypeNameInPackage(type.getRawType().getName(), currentPackage);
    }

    public static String resolveTypeNameInPackage(Type type, String currentPackage) {
        return ClassUtil.resolveTypeNameInPackage(TypeToken.of((Type)type), currentPackage);
    }

    private static String resolveTypeNameInPackage(String type, String currentPackage) {
        if (!Strings.isNullOrEmpty((String)currentPackage) && type.startsWith(currentPackage)) {
            return type.substring(currentPackage.length() + 1, type.length());
        }
        return type;
    }

    public static String getTypeNameWithoutDots(String typeName) {
        int indexOfClassName = StringUtils.indexOfAny((CharSequence)typeName, (String)CAPITAL_LETTERS);
        String typeSimpleNameWithOuterClass = indexOfClassName > 0 ? typeName.substring(indexOfClassName) : typeName;
        return StringUtils.remove((String)typeSimpleNameWithOuterClass, (String)".");
    }

    public static boolean isBoolean(TypeToken<?> type) {
        TypeToken unwrapped = type.unwrap();
        return unwrapped.isSubtypeOf(Boolean.TYPE);
    }

    public static String safePackageName(TypeToken<?> typeToken) {
        return typeToken.getRawType().getPackage() == null ? "" : typeToken.getRawType().getPackage().getName();
    }

    public static String packageNameRegex(String packageName) {
        return Pattern.quote(packageName + ".") + "(?=[A-Z])";
    }

    public static Visibility visibilityOf(Field field) {
        int fieldModifiers = field.getModifiers();
        if (Modifier.isPublic(fieldModifiers)) {
            return Visibility.PUBLIC;
        }
        if (Modifier.isProtected(fieldModifiers)) {
            return Visibility.PROTECTED;
        }
        if (Modifier.isPrivate(fieldModifiers)) {
            return Visibility.PRIVATE;
        }
        return Visibility.PACKAGE;
    }

    private static String booleanPropertyOf(String memberName) {
        String prefixToRemove = ClassUtil.getPredicatePrefix(memberName);
        if (prefixToRemove != null && memberName.startsWith(prefixToRemove)) {
            String propertyWithCapitalLetter = StringUtils.removeStart((String)memberName, (String)prefixToRemove);
            return StringUtils.uncapitalize((String)propertyWithCapitalLetter);
        }
        return memberName;
    }

    private static String getterProperty(String memberName) {
        if (memberName.startsWith(GET_PREFIX)) {
            String propertyWithCapitalLetter = StringUtils.removeStart((String)memberName, (String)GET_PREFIX);
            return StringUtils.uncapitalize((String)propertyWithCapitalLetter);
        }
        return memberName;
    }

    static {
        LONGEST_TO_SHORTEST = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int lengthComp = o2.length() - o1.length();
                return lengthComp == 0 ? o1.compareTo(o2) : lengthComp;
            }
        };
        String[][] predicates = new String[][]{{"is", "isNot"}, {"was", "wasNot"}, {"can", "cannot"}, {"canBe", "cannotBe"}, {"should", "shouldNot"}, {"shouldBe", "shouldNotBe"}, {"has", "doesNotHave"}, {"willBe", "willNotBe"}, {"will", "willNot"}};
        StringBuilder pattern = new StringBuilder("^(?:get");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String[] pair : predicates) {
            map.put(pair[0], pair[1]);
            map.put(pair[1], pair[0]);
        }
        TreeSet<String> sort = new TreeSet<String>(LONGEST_TO_SHORTEST);
        sort.addAll(map.keySet());
        for (String prefix : sort) {
            pattern.append('|').append(prefix);
        }
        pattern.append(")(?=\\p{Upper})");
        PREFIX_PATTERN = Pattern.compile(pattern.toString());
        PREDICATE_PREFIXES = Collections.unmodifiableMap(map);
    }
}

