/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator.description;

import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.assertions.generator.description.FieldDescription;
import org.assertj.assertions.generator.description.GetterDescription;
import org.assertj.assertions.generator.util.ClassUtil;

public class ClassDescription
implements Comparable<ClassDescription> {
    private static final String ABSTRACT_ASSERT_CLASS_PREFIX = "Abstract";
    private static final String ASSERT_CLASS_SUFFIX = "Assert";
    private Set<GetterDescription> gettersDescriptions;
    private Set<FieldDescription> fieldsDescriptions;
    private Set<GetterDescription> declaredGettersDescriptions;
    private Set<FieldDescription> declaredFieldsDescriptions;
    private TypeToken<?> type;
    private TypeToken<?> superType;

    public ClassDescription(TypeToken<?> type) {
        this.type = type;
        this.superType = null;
        this.gettersDescriptions = new TreeSet<GetterDescription>();
        this.fieldsDescriptions = new TreeSet<FieldDescription>();
        this.declaredGettersDescriptions = new TreeSet<GetterDescription>();
        this.declaredFieldsDescriptions = new TreeSet<FieldDescription>();
    }

    public String getFullyQualifiedClassName() {
        return ClassUtil.getTypeDeclaration(this.type);
    }

    public String getFullyQualifiedOuterClassName() {
        String outerClassNameWithInner = StringUtils.remove((String)this.getFullyQualifiedClassName(), (String)(this.getPackageName() + "."));
        String outerClassNameOnly = StringUtils.substringBefore((String)outerClassNameWithInner, (String)".");
        return this.getPackageName() + "." + outerClassNameOnly;
    }

    public String getFullyQualifiedClassNameWithoutGenerics() {
        return this.getFullyQualifiedClassName();
    }

    public String getClassNameWithOuterClass() {
        String typeDeclaration = ClassUtil.getTypeDeclaration(this.type);
        return RegExUtils.removeAll((String)typeDeclaration, (String)ClassUtil.packageNameRegex(this.getPackageName()));
    }

    public String getPackageName() {
        return this.type.getRawType().getPackage().getName();
    }

    public Set<GetterDescription> getGettersDescriptions() {
        return this.gettersDescriptions;
    }

    public void addGetterDescriptions(Collection<GetterDescription> getterDescriptions) {
        this.gettersDescriptions.addAll(getterDescriptions);
    }

    public void addFieldDescriptions(Set<FieldDescription> fieldDescriptions) {
        this.fieldsDescriptions.addAll(fieldDescriptions);
    }

    public Set<FieldDescription> getFieldsDescriptions() {
        return this.fieldsDescriptions;
    }

    public Set<GetterDescription> getDeclaredGettersDescriptions() {
        return this.declaredGettersDescriptions;
    }

    public Set<FieldDescription> getDeclaredFieldsDescriptions() {
        return this.declaredFieldsDescriptions;
    }

    public void addDeclaredGetterDescriptions(Collection<GetterDescription> declaredGetterDescriptions) {
        this.declaredGettersDescriptions.addAll(declaredGetterDescriptions);
    }

    public void addDeclaredFieldDescriptions(Set<FieldDescription> declaredFieldDescriptions) {
        this.declaredFieldsDescriptions.addAll(declaredFieldDescriptions);
    }

    public boolean hasGetterForField(FieldDescription field) {
        HashSet<String> gettersCompatibleWithFieldType = new HashSet<String>();
        for (GetterDescription getter : Sets.union(this.gettersDescriptions, this.declaredGettersDescriptions)) {
            if (!Objects.equals(field.getValueType(), getter.getValueType())) continue;
            gettersCompatibleWithFieldType.add(getter.getOriginalMember().getName());
        }
        String capName = StringUtils.capitalize((String)field.getName());
        if (field.isPredicate()) {
            for (String prefix : ClassUtil.PREDICATE_PREFIXES.keySet()) {
                if (!gettersCompatibleWithFieldType.contains(prefix + capName)) continue;
                return true;
            }
        }
        return gettersCompatibleWithFieldType.contains("get" + capName);
    }

    public TypeToken<?> getSuperType() {
        return this.superType;
    }

    public void setSuperType(Class<?> superType) {
        if (superType != null) {
            this.superType = this.type.getSupertype(superType);
        }
    }

    public String getAssertClassName() {
        return ClassDescription.assertClassNameOf(this.type);
    }

    public String getAssertClassFilename() {
        String assertClassName = ClassDescription.assertClassNameOf(this.type);
        return assertClassName + ".java";
    }

    public String getFullyQualifiedAssertClassName() {
        return this.getPackageName() + "." + this.getAssertClassName();
    }

    public String getAbstractAssertClassName() {
        return ClassDescription.abstractAssertClassNameOf(this.type);
    }

    public String getAbstractAssertClassFilename() {
        String abstractAssertClassName = ClassDescription.abstractAssertClassNameOf(this.type);
        return abstractAssertClassName + ".java";
    }

    public String getFullyQualifiedParentAssertClassName() {
        if (this.superType.getRawType().equals(Object.class)) {
            return "org.assertj.core.api.AbstractObjectAssert";
        }
        return this.superType.getRawType().getPackage().getName() + "." + ClassDescription.abstractAssertClassNameOf(this.superType);
    }

    public String toString() {
        return "ClassDescription [valueType=" + String.valueOf(this.type) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassDescription)) {
            return false;
        }
        ClassDescription that = (ClassDescription)o;
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    @Override
    public int compareTo(ClassDescription o) {
        return this.type.getRawType().getName().compareTo(o.type.getRawType().getName());
    }

    private static String assertClassNameOf(TypeToken<?> type) {
        String typeDeclaration = ClassUtil.getTypeDeclaration(type);
        String typeNameWithoutDots = ClassUtil.getTypeNameWithoutDots(typeDeclaration);
        return typeNameWithoutDots + ASSERT_CLASS_SUFFIX;
    }

    private static String abstractAssertClassNameOf(TypeToken<?> type) {
        return ABSTRACT_ASSERT_CLASS_PREFIX + ClassDescription.assertClassNameOf(type);
    }

    public boolean implementsComparable() {
        return this.type.isSubtypeOf(Comparable.class);
    }
}

