/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator.description;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import org.assertj.assertions.generator.description.DataDescription;
import org.assertj.assertions.generator.description.Visibility;
import org.assertj.assertions.generator.util.ClassUtil;

public class GetterDescription
extends DataDescription
implements Comparable<GetterDescription> {
    private final Invokable<?, ?> invokable;
    private final ImmutableList<TypeToken<? extends Throwable>> exceptions;

    public GetterDescription(String propertyName, TypeToken<?> owningType, Method method) {
        super(propertyName, method, Visibility.PUBLIC, owningType.method(method).getReturnType(), owningType);
        this.invokable = owningType.method(method);
        this.exceptions = this.invokable.getExceptionTypes();
    }

    @Override
    public Method getOriginalMember() {
        return (Method)super.getOriginalMember();
    }

    @Override
    public int compareTo(GetterDescription other) {
        return super.compareTo(other);
    }

    public ImmutableList<TypeToken<? extends Throwable>> getExceptions() {
        return this.exceptions;
    }

    @Override
    public boolean isPredicate() {
        return ClassUtil.isBoolean(this.valueType) && ClassUtil.isValidPredicateName(this.originalMember.getName());
    }
}

