/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api;

import java.lang.reflect.Constructor;
import java.util.List;
import org.assertj.db.api.AbstractColumnValueAssert;
import org.assertj.db.api.AbstractDbAssert;
import org.assertj.db.api.AbstractRowAssert;
import org.assertj.db.api.AbstractRowValueAssert;
import org.assertj.db.api.AbstractSubAssert;
import org.assertj.db.api.assertions.AssertOnColumnEquality;
import org.assertj.db.api.assertions.AssertOnColumnName;
import org.assertj.db.api.assertions.AssertOnColumnNullity;
import org.assertj.db.api.assertions.AssertOnColumnType;
import org.assertj.db.api.assertions.AssertOnNumberOfRows;
import org.assertj.db.api.assertions.impl.AssertionsOnColumnEquality;
import org.assertj.db.api.assertions.impl.AssertionsOnColumnName;
import org.assertj.db.api.assertions.impl.AssertionsOnColumnNullity;
import org.assertj.db.api.assertions.impl.AssertionsOnColumnType;
import org.assertj.db.api.assertions.impl.AssertionsOnNumberOfRows;
import org.assertj.db.api.navigation.ColumnAssert;
import org.assertj.db.type.AbstractDbData;
import org.assertj.db.type.Column;
import org.assertj.db.type.DateTimeValue;
import org.assertj.db.type.DateValue;
import org.assertj.db.type.TimeValue;
import org.assertj.db.type.ValueType;

public abstract class AbstractColumnAssert<D extends AbstractDbData<D>, A extends AbstractDbAssert<D, A, C, CV, R, RV>, C extends AbstractColumnAssert<D, A, C, CV, R, RV>, CV extends AbstractColumnValueAssert<D, A, C, CV, R, RV>, R extends AbstractRowAssert<D, A, C, CV, R, RV>, RV extends AbstractRowValueAssert<D, A, C, CV, R, RV>>
extends AbstractSubAssert<D, A, C, CV, C, CV, R, RV>
implements ColumnAssert,
AssertOnColumnEquality<C>,
AssertOnNumberOfRows<C>,
AssertOnColumnName<C>,
AssertOnColumnType<C>,
AssertOnColumnNullity<C> {
    private final Column column;

    AbstractColumnAssert(A originalDbAssert, Class<C> selfType, Class<CV> valueType, Column column) {
        super(originalDbAssert, selfType, valueType);
        this.column = column;
    }

    @Override
    protected CV getValueAssertInstance(Class<CV> valueAssertType, int index, Object value) throws Exception {
        Constructor<CV> constructor = valueAssertType.getDeclaredConstructor(((AbstractColumnAssert)this.myself).getClass(), Object.class);
        AbstractColumnValueAssert instance = (AbstractColumnValueAssert)constructor.newInstance(this, value);
        return (CV)((AbstractColumnValueAssert)instance.as("Value at index " + index + " of " + this.info.descriptionText(), new Object[0]));
    }

    @Override
    protected List<Object> getValuesList() {
        return this.column.getValuesList();
    }

    @Override
    public C hasNumberOfRows(int expected) {
        return (C)((AbstractColumnAssert)AssertionsOnNumberOfRows.hasNumberOfRows(this.myself, this.info, this.column.getValuesList().size(), expected));
    }

    @Override
    public C isOfType(ValueType expected, boolean lenient) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnType.isOfType(this.myself, this.info, this.getValuesList(), expected, lenient));
    }

    @Override
    public C isOfAnyTypeIn(ValueType ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnType.isOfAnyTypeIn(this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C isNumber(boolean lenient) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnType.isNumber(this.myself, this.info, this.getValuesList(), lenient));
    }

    @Override
    public C isBoolean(boolean lenient) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnType.isBoolean(this.myself, this.info, this.getValuesList(), lenient));
    }

    @Override
    public C isDate(boolean lenient) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnType.isDate(this.myself, this.info, this.getValuesList(), lenient));
    }

    @Override
    public C isTime(boolean lenient) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnType.isTime(this.myself, this.info, this.getValuesList(), lenient));
    }

    @Override
    public C isDateTime(boolean lenient) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnType.isDateTime(this.myself, this.info, this.getValuesList(), lenient));
    }

    @Override
    public C isBytes(boolean lenient) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnType.isBytes(this.myself, this.info, this.getValuesList(), lenient));
    }

    @Override
    public C isText(boolean lenient) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnType.isText(this.myself, this.info, this.getValuesList(), lenient));
    }

    @Override
    public C hasOnlyNullValues() {
        return (C)((AbstractColumnAssert)AssertionsOnColumnNullity.hasOnlyNullValues(this.myself, this.info, this.getValuesList()));
    }

    @Override
    public C hasOnlyNotNullValues() {
        return (C)((AbstractColumnAssert)AssertionsOnColumnNullity.hasOnlyNotNullValues(this.myself, this.info, this.getValuesList()));
    }

    @Override
    public C hasValues(Boolean ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnEquality.hasValues(this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C hasValues(Number ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnEquality.hasValues(this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C hasValues(byte[] ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnEquality.hasValues(this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C hasValues(String ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnEquality.hasValues(this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C hasValues(DateValue ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnEquality.hasValues(this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C hasValues(TimeValue ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnEquality.hasValues(this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C hasValues(DateTimeValue ... expected) {
        return (C)((AbstractColumnAssert)AssertionsOnColumnEquality.hasValues(this.myself, this.info, this.getValuesList(), expected));
    }

    @Override
    public C hasColumnName(String columnName) {
        String name = this.column.getName();
        return (C)((AbstractColumnAssert)AssertionsOnColumnName.hasColumnName(this.myself, this.info, name, columnName));
    }
}

