/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api;

import java.lang.reflect.Constructor;
import java.util.List;
import org.assertj.db.api.AbstractColumnAssert;
import org.assertj.db.api.AbstractColumnValueAssert;
import org.assertj.db.api.AbstractDbAssert;
import org.assertj.db.api.AbstractRowValueAssert;
import org.assertj.db.api.AbstractSubAssert;
import org.assertj.db.api.assertions.AssertOnNumberOfColumns;
import org.assertj.db.api.assertions.AssertOnRowEquality;
import org.assertj.db.api.assertions.impl.AssertionsOnNumberOfColumns;
import org.assertj.db.api.assertions.impl.AssertionsOnRowEquality;
import org.assertj.db.api.navigation.RowAssert;
import org.assertj.db.api.navigation.ToValueFromRow;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.AbstractDbData;
import org.assertj.db.type.Row;

public abstract class AbstractRowAssert<D extends AbstractDbData<D>, A extends AbstractDbAssert<D, A, C, CV, R, RV>, C extends AbstractColumnAssert<D, A, C, CV, R, RV>, CV extends AbstractColumnValueAssert<D, A, C, CV, R, RV>, R extends AbstractRowAssert<D, A, C, CV, R, RV>, RV extends AbstractRowValueAssert<D, A, C, CV, R, RV>>
extends AbstractSubAssert<D, A, R, RV, C, CV, R, RV>
implements RowAssert,
ToValueFromRow<RV>,
AssertOnRowEquality<R>,
AssertOnNumberOfColumns<R> {
    private final Row row;

    AbstractRowAssert(A originalDbAssert, Class<R> selfType, Class<RV> valueType, Row row) {
        super(originalDbAssert, selfType, valueType);
        this.row = row;
    }

    @Override
    protected RV getValueAssertInstance(Class<RV> valueAssertType, int index, Object value) throws Exception {
        List<String> columnsNameList = this.row.getColumnsNameList();
        String columnName = columnsNameList.get(index);
        Constructor<RV> constructor = valueAssertType.getDeclaredConstructor(((AbstractRowAssert)this.myself).getClass(), String.class, Object.class);
        AbstractRowValueAssert instance = (AbstractRowValueAssert)constructor.newInstance(this, columnName, value);
        return (RV)((AbstractRowValueAssert)instance.as("Value at index " + index + " (column name : " + columnName + ") of " + this.info.descriptionText(), new Object[0]));
    }

    @Override
    protected List<Object> getValuesList() {
        return this.row.getValuesList();
    }

    @Override
    public RV value(String columnName) {
        if (columnName == null) {
            throw new NullPointerException("Column name must be not null");
        }
        List<String> columnsNameList = this.row.getColumnsNameList();
        int index = columnsNameList.indexOf(columnName.toUpperCase());
        if (index == -1) {
            throw new AssertJDBException("Column <%s> does not exist", columnName);
        }
        return (RV)((AbstractRowValueAssert)this.getValueAssertInstance(index));
    }

    @Override
    public R hasNumberOfColumns(int expected) {
        return (R)((AbstractRowAssert)AssertionsOnNumberOfColumns.hasNumberOfColumns(this.myself, this.info, this.getValuesList().size(), expected));
    }

    @Override
    public R hasValues(Object ... expected) {
        return (R)((AbstractRowAssert)AssertionsOnRowEquality.hasValues(this.myself, this.info, this.getValuesList(), expected));
    }
}

