/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.db.api.AbstractAssertWithOriginWithColumnsAndRowsFromChange;
import org.assertj.db.api.ChangeAssert;
import org.assertj.db.api.ChangeRowValueAssert;
import org.assertj.db.api.assertions.AssertOnNumberOfColumns;
import org.assertj.db.api.assertions.AssertOnRowEquality;
import org.assertj.db.api.assertions.AssertOnRowOfChangeExistence;
import org.assertj.db.api.assertions.impl.AssertionsOnNumberOfColumns;
import org.assertj.db.api.assertions.impl.AssertionsOnRowEquality;
import org.assertj.db.api.assertions.impl.AssertionsOnRowOfChangeExistence;
import org.assertj.db.api.navigation.RowAssert;
import org.assertj.db.api.origin.OriginWithValuesFromRow;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.Row;

public class ChangeRowAssert
extends AbstractAssertWithOriginWithColumnsAndRowsFromChange<ChangeRowAssert, ChangeAssert>
implements RowAssert,
OriginWithValuesFromRow,
AssertOnRowEquality<ChangeRowAssert>,
AssertOnNumberOfColumns<ChangeRowAssert>,
AssertOnRowOfChangeExistence<ChangeRowAssert> {
    private final Row row;
    private int indexNextValue;
    private final Map<Integer, ChangeRowValueAssert> changeValueAssertMap = new HashMap<Integer, ChangeRowValueAssert>();

    ChangeRowAssert(ChangeAssert origin, Row row) {
        super(ChangeRowAssert.class, origin);
        this.row = row;
    }

    private Object getValue(int index) {
        if (this.row == null) {
            throw new AssertJDBException("Row do not exist", new Object[0]);
        }
        int size = this.row.getValuesList().size();
        if (index < 0 || index >= size) {
            throw new AssertJDBException("Index %s out of the limits [0, %s[", index, size);
        }
        Object object = this.row.getValuesList().get(index);
        this.indexNextValue = index + 1;
        return object;
    }

    private ChangeRowValueAssert getChangeValueAssertInstance(int index) {
        if (this.changeValueAssertMap.containsKey(index)) {
            ChangeRowValueAssert changeRowValueAssert = this.changeValueAssertMap.get(index);
            this.indexNextValue = index + 1;
            return changeRowValueAssert;
        }
        Object value = this.getValue(index);
        List<String> columnsNameList = this.row.getColumnsNameList();
        String columnName = columnsNameList.get(index);
        ChangeRowValueAssert instance = new ChangeRowValueAssert(this, columnName, value);
        this.changeValueAssertMap.put(index, instance);
        return (ChangeRowValueAssert)instance.as("Value at index " + index + " (column name : " + columnName + ") of " + this.info.descriptionText(), new Object[0]);
    }

    @Override
    public ChangeRowValueAssert value() {
        return this.getChangeValueAssertInstance(this.indexNextValue);
    }

    @Override
    public ChangeRowValueAssert value(int index) {
        return this.getChangeValueAssertInstance(index);
    }

    @Override
    public ChangeRowValueAssert value(String columnName) {
        if (columnName == null) {
            throw new NullPointerException("Column name must be not null");
        }
        List<String> columnsNameList = this.row.getColumnsNameList();
        int index = columnsNameList.indexOf(columnName.toUpperCase());
        if (index == -1) {
            throw new AssertJDBException("Column <%s> does not exist", columnName);
        }
        return this.getChangeValueAssertInstance(index);
    }

    @Override
    public ChangeRowAssert hasNumberOfColumns(int expected) {
        this.exists();
        List<String> columnsNameList = this.row.getColumnsNameList();
        int size = columnsNameList.size();
        return (ChangeRowAssert)AssertionsOnNumberOfColumns.hasNumberOfColumns(this.myself, this.info, size, expected);
    }

    @Override
    public ChangeRowAssert hasValues(Object ... expected) {
        this.exists();
        return (ChangeRowAssert)AssertionsOnRowEquality.hasValues(this.myself, this.info, this.row.getValuesList(), expected);
    }

    @Override
    public ChangeRowAssert exists() {
        return (ChangeRowAssert)AssertionsOnRowOfChangeExistence.exists(this.myself, this.info, this.row);
    }

    @Override
    public ChangeRowAssert doesNotExist() {
        return (ChangeRowAssert)AssertionsOnRowOfChangeExistence.doesNotExist(this.myself, this.info, this.row);
    }

    public ChangeAssert returnToChange() {
        return (ChangeAssert)this.returnToOrigin();
    }
}

