/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.db.api.AbstractAssertWithOrigin;
import org.assertj.db.api.ChangeAssert;
import org.assertj.db.api.assertions.AssertOnNumberOfChanges;
import org.assertj.db.api.assertions.impl.AssertionsOnNumberOfChanges;
import org.assertj.db.api.origin.OriginWithChanges;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.Change;
import org.assertj.db.type.ChangeType;
import org.assertj.db.type.Changes;
import org.assertj.db.util.Values;

public class ChangesAssert
extends AbstractAssertWithOrigin<ChangesAssert, ChangesAssert>
implements OriginWithChanges,
AssertOnNumberOfChanges<ChangesAssert> {
    private final Changes changes;
    private final Map<ChangeType, Map<String, Integer>> indexNextChangeMap = new HashMap<ChangeType, Map<String, Integer>>();
    private final Map<ChangeType, Map<String, ChangesAssert>> changesAssertMap = new HashMap<ChangeType, Map<String, ChangesAssert>>();
    private final Map<Change, ChangeAssert> changeMap = new HashMap<Change, ChangeAssert>();

    ChangesAssert(Changes changes) {
        this((ChangesAssert)null, changes);
    }

    private ChangesAssert(ChangesAssert origin, Changes changes) {
        super(ChangesAssert.class, origin);
        this.changes = changes;
    }

    private ChangesAssert getAssertFromCache(ChangeType changeType, String tableName) {
        Map<String, ChangesAssert> mapWithTableName = this.changesAssertMap.get((Object)changeType);
        if (mapWithTableName == null) {
            return null;
        }
        return mapWithTableName.get(tableName);
    }

    private void setAssertInCache(ChangeType changeType, String tableName, ChangesAssert changesAssert) {
        Map<String, ChangesAssert> mapWithTableName = this.changesAssertMap.get((Object)changeType);
        if (mapWithTableName == null) {
            mapWithTableName = new HashMap<String, ChangesAssert>();
            this.changesAssertMap.put(changeType, mapWithTableName);
        }
        mapWithTableName.put(tableName, changesAssert);
    }

    private StringBuilder getStringBuilderAboutChangeTypeAndTableName(ChangeType changeType, String tableName) {
        StringBuilder stringBuilder = new StringBuilder();
        if (changeType != null || tableName != null) {
            stringBuilder.append(" (only");
            if (changeType != null) {
                stringBuilder.append(" ");
                stringBuilder.append(changeType.name().toLowerCase());
            }
            stringBuilder.append(" ");
            stringBuilder.append("changes");
            if (tableName != null) {
                stringBuilder.append(" on ");
                stringBuilder.append(tableName);
                stringBuilder.append(" table");
            }
            stringBuilder.append(")");
        }
        return stringBuilder;
    }

    private ChangesAssert getChangeAssertInstance(ChangeType changeType, String tableName) {
        ChangesAssert changesAssert = this.getAssertFromCache(changeType, tableName);
        if (changesAssert != null) {
            return changesAssert;
        }
        Changes changes = this.changes;
        if (changeType != null) {
            changes = changes.getChangesOfType(changeType);
        }
        if (tableName != null) {
            changes = changes.getChangesOfTable(tableName);
        }
        changesAssert = (ChangesAssert)new ChangesAssert(this, changes).as(this.info.descriptionText() + this.getStringBuilderAboutChangeTypeAndTableName(changeType, tableName), new Object[0]);
        this.setAssertInCache(changeType, tableName, changesAssert);
        return changesAssert;
    }

    @Override
    public ChangesAssert ofAll() {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).ofAll();
        }
        return this;
    }

    @Override
    public ChangesAssert ofCreation() {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).ofCreation();
        }
        return this.getChangeAssertInstance(ChangeType.CREATION, null);
    }

    @Override
    public ChangesAssert ofModification() {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).ofModification();
        }
        return this.getChangeAssertInstance(ChangeType.MODIFICATION, null);
    }

    @Override
    public ChangesAssert ofDeletion() {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).ofDeletion();
        }
        return this.getChangeAssertInstance(ChangeType.DELETION, null);
    }

    @Override
    public ChangesAssert ofCreationOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).ofCreationOnTable(tableName);
        }
        return this.getChangeAssertInstance(ChangeType.CREATION, tableName);
    }

    @Override
    public ChangesAssert ofModificationOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).ofModificationOnTable(tableName);
        }
        return this.getChangeAssertInstance(ChangeType.MODIFICATION, tableName);
    }

    @Override
    public ChangesAssert ofDeletionOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).ofDeletionOnTable(tableName);
        }
        return this.getChangeAssertInstance(ChangeType.DELETION, tableName);
    }

    @Override
    public ChangesAssert onTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).onTable(tableName);
        }
        return this.getChangeAssertInstance(null, tableName);
    }

    private Change getChange(int index, ChangeType changeType, String tableName) {
        Changes changes = this.changes;
        if (changeType != null) {
            changes = changes.getChangesOfType(changeType);
        }
        if (tableName != null) {
            changes = changes.getChangesOfTable(tableName);
        }
        List<Change> changesList = changes.getChangesList();
        int size = changesList.size();
        if (index < 0 || index >= size) {
            throw new AssertJDBException("Index %s out of the limits [0, %s[", index, size);
        }
        Change change = changesList.get(index);
        this.setIndexNextChange(changeType, tableName, index + 1);
        return change;
    }

    private ChangeAssert getChangeAssertInstance(ChangeType changeType, String tableName, int index) {
        boolean havePksValues;
        Change change = this.getChange(index, changeType, tableName);
        ChangeAssert changeAssert = this.changeMap.get(change);
        if (changeAssert != null) {
            return changeAssert;
        }
        ChangeAssert instance = new ChangeAssert(this, change);
        this.changeMap.put(change, instance);
        this.setIndexNextChange(changeType, tableName, index + 1);
        StringBuilder stringBuilder = new StringBuilder("Change at index " + index);
        List<Object> pksValueList = change.getPksValueList();
        boolean isAChangeOnATableAmongOtherTables = this.changes.getTablesList() != null && this.changes.getTablesList().size() > 1;
        boolean bl = havePksValues = pksValueList.size() > 0;
        if (isAChangeOnATableAmongOtherTables || havePksValues) {
            stringBuilder.append(" (");
            if (isAChangeOnATableAmongOtherTables) {
                stringBuilder.append("on table : ").append(change.getDataName());
            }
            if (isAChangeOnATableAmongOtherTables && havePksValues) {
                stringBuilder.append(" and ");
            }
            if (havePksValues) {
                stringBuilder.append("with primary key : ").append(pksValueList);
            }
            stringBuilder.append(")");
        }
        stringBuilder.append(" of ").append(this.info.descriptionText());
        stringBuilder.append((CharSequence)this.getStringBuilderAboutChangeTypeAndTableName(changeType, tableName));
        return (ChangeAssert)instance.as(stringBuilder.toString(), new Object[0]);
    }

    private Integer getIndexNextChange(ChangeType changeType, String tableName) {
        Integer index;
        Map<String, Integer> map = this.indexNextChangeMap.get((Object)changeType);
        if (map != null && (index = map.get(tableName)) != null) {
            return index;
        }
        return 0;
    }

    private void setIndexNextChange(ChangeType changeType, String tableName, int index) {
        Map<String, Integer> map = this.indexNextChangeMap.get((Object)changeType);
        if (map == null) {
            map = new HashMap<String, Integer>();
            this.indexNextChangeMap.put(changeType, map);
        }
        map.put(tableName, index);
    }

    @Override
    public ChangeAssert change() {
        return this.getChangeAssertInstance(null, null, this.getIndexNextChange(null, null));
    }

    @Override
    public ChangeAssert change(int index) {
        return this.getChangeAssertInstance(null, null, index);
    }

    @Override
    public ChangeAssert changeOfCreation() {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfCreation();
        }
        return this.getChangeAssertInstance(ChangeType.CREATION, null, this.getIndexNextChange(ChangeType.CREATION, null));
    }

    @Override
    public ChangeAssert changeOfCreation(int index) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfCreation(index);
        }
        return this.getChangeAssertInstance(ChangeType.CREATION, null, index);
    }

    @Override
    public ChangeAssert changeOfModification() {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfModification();
        }
        return this.getChangeAssertInstance(ChangeType.MODIFICATION, null, this.getIndexNextChange(ChangeType.MODIFICATION, null));
    }

    @Override
    public ChangeAssert changeOfModification(int index) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfModification(index);
        }
        return this.getChangeAssertInstance(ChangeType.MODIFICATION, null, index);
    }

    @Override
    public ChangeAssert changeOfDeletion() {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfDeletion();
        }
        return this.getChangeAssertInstance(ChangeType.DELETION, null, this.getIndexNextChange(ChangeType.DELETION, null));
    }

    @Override
    public ChangeAssert changeOfDeletion(int index) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfDeletion(index);
        }
        return this.getChangeAssertInstance(ChangeType.DELETION, null, index);
    }

    @Override
    public ChangeAssert changeOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOnTable(tableName);
        }
        return this.getChangeAssertInstance(null, tableName, this.getIndexNextChange(null, tableName));
    }

    @Override
    public ChangeAssert changeOnTable(String tableName, int index) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOnTable(tableName, index);
        }
        return this.getChangeAssertInstance(null, tableName, index);
    }

    @Override
    public ChangeAssert changeOnTableWithPks(String tableName, Object ... pksValues) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOnTableWithPks(tableName, pksValues);
        }
        Changes changes = this.changes.getChangesOfTable(tableName);
        List<Change> changesList = changes.getChangesList();
        int index = 0;
        for (Change change : changesList) {
            List<Object> pksValueList = change.getPksValueList();
            Object[] values = pksValueList.toArray(new Object[pksValueList.size()]);
            boolean equal = false;
            if (pksValues.length == values.length) {
                equal = true;
                for (int i = 0; i < pksValues.length; ++i) {
                    if (Values.areEqual(values[i], pksValues[i])) continue;
                    equal = false;
                }
            }
            if (equal) {
                return this.getChangeAssertInstance(null, tableName, index);
            }
            ++index;
        }
        throw new AssertJDBException("No change found for table " + tableName + " and primary keys " + Arrays.asList(pksValues), new Object[0]);
    }

    @Override
    public ChangeAssert changeOfCreationOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfCreationOnTable(tableName);
        }
        return this.getChangeAssertInstance(ChangeType.CREATION, tableName, this.getIndexNextChange(ChangeType.CREATION, tableName));
    }

    @Override
    public ChangeAssert changeOfCreationOnTable(String tableName, int index) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfCreationOnTable(tableName, index);
        }
        return this.getChangeAssertInstance(ChangeType.CREATION, tableName, index);
    }

    @Override
    public ChangeAssert changeOfModificationOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfModificationOnTable(tableName);
        }
        return this.getChangeAssertInstance(ChangeType.MODIFICATION, tableName, this.getIndexNextChange(ChangeType.MODIFICATION, tableName));
    }

    @Override
    public ChangeAssert changeOfModificationOnTable(String tableName, int index) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfModificationOnTable(tableName, index);
        }
        return this.getChangeAssertInstance(ChangeType.MODIFICATION, tableName, index);
    }

    @Override
    public ChangeAssert changeOfDeletionOnTable(String tableName) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfDeletionOnTable(tableName);
        }
        return this.getChangeAssertInstance(ChangeType.DELETION, tableName, this.getIndexNextChange(ChangeType.DELETION, tableName));
    }

    @Override
    public ChangeAssert changeOfDeletionOnTable(String tableName, int index) {
        if (this.origin != null) {
            return ((ChangesAssert)this.origin).changeOfDeletionOnTable(tableName, index);
        }
        return this.getChangeAssertInstance(ChangeType.DELETION, tableName, index);
    }

    @Override
    public ChangesAssert hasNumberOfChanges(int expected) {
        return (ChangesAssert)AssertionsOnNumberOfChanges.hasNumberOfChanges(this.myself, this.info, this.changes, expected);
    }
}

