/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldBeValueType;
import org.assertj.db.error.ShouldBeValueTypeOfAny;
import org.assertj.db.type.ValueType;

public class AssertionsOnColumnType {
    private static final Failures failures = Failures.instance();

    private AssertionsOnColumnType() {
    }

    public static <A extends AbstractAssert> A isOfType(A assertion, WritableAssertionInfo info, List<Object> valuesList, ValueType expected, boolean lenient) {
        if (lenient) {
            return AssertionsOnColumnType.isOfAnyTypeIn(assertion, info, valuesList, expected, ValueType.NOT_IDENTIFIED);
        }
        int index = 0;
        for (Object value : valuesList) {
            ValueType type = ValueType.getType(value);
            if (type != expected) {
                throw failures.failure((AssertionInfo)info, ShouldBeValueType.shouldBeValueType(index, value, expected, type));
            }
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A isOfAnyTypeIn(A assertion, WritableAssertionInfo info, List<Object> valuesList, ValueType ... expected) {
        int index = 0;
        block0: for (Object value : valuesList) {
            ValueType type = ValueType.getType(value);
            for (ValueType valueType : expected) {
                if (type != valueType) continue;
                ++index;
                continue block0;
            }
            throw failures.failure((AssertionInfo)info, ShouldBeValueTypeOfAny.shouldBeValueTypeOfAny(index, value, type, expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A isNumber(A assertion, WritableAssertionInfo info, List<Object> valuesList, boolean lenient) {
        return AssertionsOnColumnType.isOfType(assertion, info, valuesList, ValueType.NUMBER, lenient);
    }

    public static <A extends AbstractAssert> A isBoolean(A assertion, WritableAssertionInfo info, List<Object> valuesList, boolean lenient) {
        return AssertionsOnColumnType.isOfType(assertion, info, valuesList, ValueType.BOOLEAN, lenient);
    }

    public static <A extends AbstractAssert> A isDate(A assertion, WritableAssertionInfo info, List<Object> valuesList, boolean lenient) {
        return AssertionsOnColumnType.isOfType(assertion, info, valuesList, ValueType.DATE, lenient);
    }

    public static <A extends AbstractAssert> A isTime(A assertion, WritableAssertionInfo info, List<Object> valuesList, boolean lenient) {
        return AssertionsOnColumnType.isOfType(assertion, info, valuesList, ValueType.TIME, lenient);
    }

    public static <A extends AbstractAssert> A isDateTime(A assertion, WritableAssertionInfo info, List<Object> valuesList, boolean lenient) {
        return AssertionsOnColumnType.isOfType(assertion, info, valuesList, ValueType.DATE_TIME, lenient);
    }

    public static <A extends AbstractAssert> A isBytes(A assertion, WritableAssertionInfo info, List<Object> valuesList, boolean lenient) {
        return AssertionsOnColumnType.isOfType(assertion, info, valuesList, ValueType.BYTES, lenient);
    }

    public static <A extends AbstractAssert> A isText(A assertion, WritableAssertionInfo info, List<Object> valuesList, boolean lenient) {
        return AssertionsOnColumnType.isOfType(assertion, info, valuesList, ValueType.TEXT, lenient);
    }
}

