/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldBeModified;
import org.assertj.db.error.ShouldNotBeModified;

public class AssertionsOnModifiedColumn {
    private static final Failures failures = Failures.instance();

    private AssertionsOnModifiedColumn() {
    }

    public static <A extends AbstractAssert> A isModified(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint) {
        if (valueAtStartPoint == null && valueAtEndPoint == null || valueAtStartPoint != null && valueAtStartPoint.equals(valueAtEndPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeModified.shouldBeModified(valueAtStartPoint, valueAtEndPoint));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A isNotModified(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint) {
        if (valueAtStartPoint == null && valueAtEndPoint != null || valueAtStartPoint != null && !valueAtStartPoint.equals(valueAtEndPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldNotBeModified.shouldNotBeModified(valueAtStartPoint, valueAtEndPoint));
        }
        return assertion;
    }
}

