/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldHaveModifications;
import org.assertj.db.error.ShouldHaveNumberOfModifications;
import org.assertj.db.type.Change;
import org.assertj.db.util.Changes;

public class AssertionsOnModifiedColumns {
    private static final Failures failures = Failures.instance();

    private AssertionsOnModifiedColumns() {
    }

    public static <A extends AbstractAssert> A hasNumberOfModifiedColumns(A assertion, WritableAssertionInfo info, Change change, int number) {
        Integer[] indexesOfModifiedColumns = Changes.getIndexesOfModifiedColumns(change);
        if (number != indexesOfModifiedColumns.length) {
            throw failures.failure((AssertionInfo)info, ShouldHaveNumberOfModifications.shouldHaveNumberOfModifications(indexesOfModifiedColumns.length, number));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasModifiedColumns(A assertion, WritableAssertionInfo info, Change change, Integer ... indexes) {
        if (indexes == null) {
            throw new NullPointerException("Columns indexes must be not null");
        }
        Integer[] indexesOfModifiedColumns = Changes.getIndexesOfModifiedColumns(change);
        List<Integer> indexesOfModifiedList = Arrays.asList(indexesOfModifiedColumns);
        Collections.sort(indexesOfModifiedList);
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        for (Integer index : indexes) {
            if (index == null) {
                throw new NullPointerException("Column index must be not null");
            }
            indexesList.add(index);
        }
        Collections.sort(indexesList);
        if (!indexesList.equals(indexesOfModifiedList)) {
            throw failures.failure((AssertionInfo)info, ShouldHaveModifications.shouldHaveModifications(indexesOfModifiedColumns, indexes));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasModifiedColumns(A assertion, WritableAssertionInfo info, Change change, String ... names) {
        if (names == null) {
            throw new NullPointerException("Columns names must be not null");
        }
        ArrayList<String> namesList = new ArrayList<String>();
        for (String name : names) {
            if (name == null) {
                throw new NullPointerException("Column name must be not null");
            }
            namesList.add(name.toUpperCase());
        }
        Collections.sort(namesList);
        Integer[] indexesOfModifiedColumns = Changes.getIndexesOfModifiedColumns(change);
        String[] namesOfModifiedColumns = new String[names.length];
        List<String> columnsNameList = change.getColumnsNameList();
        for (int i = 0; i < indexesOfModifiedColumns.length; ++i) {
            namesOfModifiedColumns[i] = columnsNameList.get(indexesOfModifiedColumns[i]);
        }
        List<String> namesOfModifiedList = Arrays.asList(namesOfModifiedColumns);
        Collections.sort(namesOfModifiedList);
        if (!namesList.equals(namesOfModifiedList)) {
            throw failures.failure((AssertionInfo)info, ShouldHaveModifications.shouldHaveModifications(namesOfModifiedColumns, names));
        }
        return assertion;
    }
}

