/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldHaveChangesSize;
import org.assertj.db.type.Change;
import org.assertj.db.type.Changes;

public class AssertionsOnNumberOfChanges {
    private static final Failures failures = Failures.instance();

    private AssertionsOnNumberOfChanges() {
    }

    public static <A extends AbstractAssert> A hasNumberOfChanges(A assertion, WritableAssertionInfo info, Changes changes, int expected) {
        List<Change> changesList = changes.getChangesList();
        int size = changesList.size();
        if (size != expected) {
            throw failures.failure((AssertionInfo)info, ShouldHaveChangesSize.shouldHaveChangesSize(size, expected));
        }
        return assertion;
    }
}

