/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.api.assertions.impl.AssertionsOnValueType;
import org.assertj.db.error.ShouldBeEqual;
import org.assertj.db.type.DateTimeValue;
import org.assertj.db.type.DateValue;
import org.assertj.db.type.TimeValue;
import org.assertj.db.type.ValueType;
import org.assertj.db.util.Values;

public class AssertionsOnValueEquality {
    private static final Failures failures = Failures.instance();

    private AssertionsOnValueEquality() {
    }

    public static <A extends AbstractAssert> A isEqualTo(A assertion, WritableAssertionInfo info, Object value, Boolean expected) {
        AssertionsOnValueType.isBoolean(assertion, info, value);
        if (Values.areEqual(value, expected)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(value, expected));
    }

    public static <A extends AbstractAssert> A isTrue(A assertion, WritableAssertionInfo info, Object value) {
        return AssertionsOnValueEquality.isEqualTo(assertion, info, value, true);
    }

    public static <A extends AbstractAssert> A isFalse(A assertion, WritableAssertionInfo info, Object value) {
        return AssertionsOnValueEquality.isEqualTo(assertion, info, value, false);
    }

    public static <A extends AbstractAssert> A isEqualTo(A assertion, WritableAssertionInfo info, Object value, Number expected) {
        AssertionsOnValueType.isNumber(assertion, info, value);
        if (Values.areEqual(value, expected)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(value, expected));
    }

    public static <A extends AbstractAssert> A isEqualTo(A assertion, WritableAssertionInfo info, Object value, byte[] expected) {
        AssertionsOnValueType.isBytes(assertion, info, value);
        if (Values.areEqual(value, expected)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual());
    }

    public static <A extends AbstractAssert> A isEqualTo(A assertion, WritableAssertionInfo info, Object value, String expected) {
        AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.TEXT, ValueType.NUMBER, ValueType.DATE, ValueType.TIME, ValueType.DATE_TIME);
        if (Values.areEqual(value, expected)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(Values.getRepresentationFromValueInFrontOfExpected(value, expected), expected));
    }

    public static <A extends AbstractAssert> A isEqualTo(A assertion, WritableAssertionInfo info, Object value, DateValue expected) {
        AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.DATE_TIME);
        if (Values.areEqual(value, expected)) {
            return assertion;
        }
        if (ValueType.getType(value) == ValueType.DATE) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(DateValue.from((Date)value), expected));
        }
        throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(DateTimeValue.from((Timestamp)value), DateTimeValue.of(expected)));
    }

    public static <A extends AbstractAssert> A isEqualTo(A assertion, WritableAssertionInfo info, Object value, TimeValue expected) {
        AssertionsOnValueType.isTime(assertion, info, value);
        if (Values.areEqual(value, expected)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(TimeValue.from((Time)value), expected));
    }

    public static <A extends AbstractAssert> A isEqualTo(A assertion, WritableAssertionInfo info, Object value, DateTimeValue expected) {
        AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.DATE_TIME);
        if (Values.areEqual(value, expected)) {
            return assertion;
        }
        if (ValueType.getType(value) == ValueType.DATE) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(DateTimeValue.of(DateValue.from((Date)value)), expected));
        }
        throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(DateTimeValue.from((Timestamp)value), expected));
    }

    public static <A extends AbstractAssert> A isZero(A assertion, WritableAssertionInfo info, Object value) {
        return AssertionsOnValueEquality.isEqualTo(assertion, info, value, 0);
    }
}

