/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.assertj.db.type.Source;

public abstract class AbstractDbElement<D extends AbstractDbElement<D>> {
    protected final D myself;
    private Source source;
    private DataSource dataSource;

    AbstractDbElement(Class<D> selfType) {
        this.myself = (AbstractDbElement)selfType.cast(this);
    }

    AbstractDbElement(Class<D> selfType, Source source) {
        this(selfType);
        this.source = source;
    }

    AbstractDbElement(Class<D> selfType, DataSource dataSource) {
        this(selfType);
        this.dataSource = dataSource;
    }

    public Source getSource() {
        return this.source;
    }

    public D setSource(Source source) {
        if (source == null) {
            throw new NullPointerException("source must be not null");
        }
        this.source = source;
        this.dataSource = null;
        return this.myself;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public D setDataSource(DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource must be not null");
        }
        this.source = null;
        this.dataSource = dataSource;
        return this.myself;
    }

    protected Connection getConnection() throws SQLException {
        if (this.dataSource == null && this.source == null) {
            throw new NullPointerException("connection or dataSource must be not null");
        }
        if (this.dataSource != null) {
            return this.dataSource.getConnection();
        }
        return DriverManager.getConnection(this.source.getUrl(), this.source.getUser(), this.source.getPassword());
    }

    protected static String getCatalog(Connection connection) throws SQLException {
        Method[] methods;
        Class<?> connectionClass = connection.getClass();
        for (Method method : methods = connectionClass.getMethods()) {
            int modifiers;
            if (!"getCatalog".equals(method.getName()) || !Modifier.isAbstract(modifiers = method.getModifiers())) continue;
            return null;
        }
        return connection.getCatalog();
    }

    protected static String getSchema(Connection connection) throws SQLException {
        Method[] methods;
        Class<?> connectionClass = connection.getClass();
        for (Method method : methods = connectionClass.getMethods()) {
            int modifiers;
            if (!"getSchema".equals(method.getName()) || !Modifier.isAbstract(modifiers = method.getModifiers())) continue;
            return null;
        }
        return connection.getSchema();
    }
}

