/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.util.List;
import org.assertj.db.type.ChangeType;
import org.assertj.db.type.DataType;
import org.assertj.db.type.Row;

public class Change {
    private final DataType dataType;
    private final String dataName;
    private final List<String> pksNameList;
    private final List<String> columnsNameList;
    private final ChangeType changeType;
    private final Row rowAtStartPoint;
    private final Row rowAtEndPoint;

    static Change createCreationChange(DataType dataType, String dataName, Row rowAtEndPoint) {
        return new Change(dataType, dataName, ChangeType.CREATION, null, rowAtEndPoint);
    }

    static Change createModificationChange(DataType dataType, String dataName, Row rowAtStartPoint, Row rowAtEndPoint) {
        return new Change(dataType, dataName, ChangeType.MODIFICATION, rowAtStartPoint, rowAtEndPoint);
    }

    static Change createDeletionChange(DataType dataType, String dataName, Row rowAtStartPoint) {
        return new Change(dataType, dataName, ChangeType.DELETION, rowAtStartPoint, null);
    }

    private Change(DataType dataType, String dataName, ChangeType changeType, Row rowAtStartPoint, Row rowAtEndPoint) {
        if (dataType == null) {
            throw new NullPointerException("The type of the data must be not null");
        }
        if (dataName == null) {
            throw new NullPointerException("The name of the data must be not null");
        }
        this.dataType = dataType;
        this.dataName = dataName;
        if (rowAtStartPoint != null) {
            this.pksNameList = rowAtStartPoint.getPksNameList();
            this.columnsNameList = rowAtStartPoint.getColumnsNameList();
        } else {
            this.pksNameList = rowAtEndPoint.getPksNameList();
            this.columnsNameList = rowAtEndPoint.getColumnsNameList();
        }
        this.changeType = changeType;
        this.rowAtStartPoint = rowAtStartPoint;
        this.rowAtEndPoint = rowAtEndPoint;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getDataName() {
        return this.dataName;
    }

    public List<String> getPksNameList() {
        return this.pksNameList;
    }

    public List<Object> getPksValueList() {
        if (this.rowAtStartPoint != null) {
            return this.rowAtStartPoint.getPksValueList();
        }
        return this.rowAtEndPoint.getPksValueList();
    }

    public List<String> getColumnsNameList() {
        return this.columnsNameList;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public Row getRowAtStartPoint() {
        return this.rowAtStartPoint;
    }

    public Row getRowAtEndPoint() {
        return this.rowAtEndPoint;
    }
}

