/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.AbstractDbData;
import org.assertj.db.type.AbstractDbElement;
import org.assertj.db.type.Change;
import org.assertj.db.type.ChangeType;
import org.assertj.db.type.Request;
import org.assertj.db.type.Row;
import org.assertj.db.type.Source;
import org.assertj.db.type.Table;
import org.assertj.db.util.ChangeComparator;

public class Changes
extends AbstractDbElement<Changes> {
    private List<Table> tablesList;
    private List<Table> tablesAtStartPointList;
    private List<Table> tablesAtEndPointList;
    private Request request;
    private Request requestAtStartPoint;
    private Request requestAtEndPoint;
    private List<Change> changesList;

    public Changes() {
        super(Changes.class);
    }

    public Changes(Source source) {
        super(Changes.class, source);
    }

    public Changes(DataSource dataSource) {
        super(Changes.class, dataSource);
    }

    public Changes(Table ... tables) {
        super(Changes.class);
        this.setTables(tables);
    }

    public Changes(Request request) {
        super(Changes.class);
        this.setRequest(request);
    }

    public Changes setTables(Table ... tables) {
        this.request = null;
        this.requestAtStartPoint = null;
        this.requestAtEndPoint = null;
        this.tablesList = new ArrayList<Table>();
        this.tablesAtStartPointList = null;
        this.tablesAtEndPointList = null;
        this.changesList = null;
        for (Table table : tables) {
            if (table == null) {
                throw new NullPointerException("The tables must be not null");
            }
            Table t = Changes.getDuplicatedTable(table);
            this.tablesList.add(t);
        }
        if (tables.length > 0) {
            Changes.copyElement(tables[0], this);
        }
        return (Changes)this.myself;
    }

    public List<Table> getTablesList() {
        return this.tablesList;
    }

    public Changes setRequest(Request request) {
        if (request == null) {
            throw new NullPointerException("The request must be not null");
        }
        this.tablesList = null;
        this.tablesAtStartPointList = null;
        this.tablesAtEndPointList = null;
        this.request = Changes.getDuplicatedRequest(request);
        Changes.copyElement(request, this);
        this.requestAtStartPoint = null;
        this.requestAtEndPoint = null;
        this.changesList = null;
        return (Changes)this.myself;
    }

    public Request getRequest() {
        return this.request;
    }

    public List<Table> getTablesAtStartPointList() {
        return this.tablesAtStartPointList;
    }

    public List<Table> getTablesAtEndPointList() {
        return this.tablesAtEndPointList;
    }

    public Request getRequestAtStartPoint() {
        return this.requestAtStartPoint;
    }

    public Request getRequestAtEndPoint() {
        return this.requestAtEndPoint;
    }

    private static void copyElement(AbstractDbElement<?> elementToCopy, AbstractDbElement<?> element) {
        if (elementToCopy.getSource() != null) {
            element.setSource(elementToCopy.getSource());
        }
        if (elementToCopy.getDataSource() != null) {
            element.setDataSource(elementToCopy.getDataSource());
        }
    }

    private static Request getDuplicatedRequest(Request request) {
        Request r = new Request();
        Changes.copyElement(request, r);
        return r.setRequest(request.getRequest()).setParameters(request.getParameters()).setPksName(request.getPksNameList().toArray(new String[request.getPksNameList().size()]));
    }

    private static Table getDuplicatedTable(Table table) {
        Table t = new Table();
        Changes.copyElement(table, t);
        return t.setName(table.getName()).setColumnsToCheck(table.getColumnsToCheck()).setColumnsToExclude(table.getColumnsToExclude());
    }

    public Changes setStartPointNow() {
        if (this.request == null && this.tablesList == null) {
            try (Connection connection = this.getConnection();){
                this.tablesList = new LinkedList<Table>();
                DatabaseMetaData metaData = connection.getMetaData();
                ResultSet resultSet = metaData.getTables(Changes.getCatalog(connection), Changes.getSchema(connection), null, new String[]{"TABLE"});
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    Table t = new Table().setName(tableName);
                    Changes.copyElement(this, t);
                    this.tablesList.add(t);
                }
            }
            catch (SQLException e) {
                throw new AssertJDBException(e);
            }
        }
        if (this.request != null) {
            this.tablesAtStartPointList = null;
            this.requestAtStartPoint = Changes.getDuplicatedRequest(this.request);
            this.requestAtStartPoint.getRowsList();
        } else {
            this.requestAtStartPoint = null;
            this.tablesAtStartPointList = new LinkedList<Table>();
            for (Table table : this.tablesList) {
                Table t = Changes.getDuplicatedTable(table);
                t.getRowsList();
                this.tablesAtStartPointList.add(t);
            }
        }
        this.tablesAtEndPointList = null;
        this.requestAtEndPoint = null;
        this.changesList = null;
        return (Changes)this.myself;
    }

    public Changes setEndPointNow() {
        if (this.requestAtStartPoint == null && this.tablesAtStartPointList == null) {
            throw new AssertJDBException("Start point must be set before", new Object[0]);
        }
        if (this.requestAtStartPoint != null) {
            this.requestAtEndPoint = Changes.getDuplicatedRequest(this.request);
            this.requestAtEndPoint.getRowsList();
        } else {
            this.tablesAtEndPointList = new LinkedList<Table>();
            for (Table table : this.tablesList) {
                Table t = Changes.getDuplicatedTable(table);
                t.getRowsList();
                this.tablesAtEndPointList.add(t);
            }
        }
        this.changesList = null;
        return (Changes)this.myself;
    }

    private List<Change> getChangesListWithPks(String dataName, AbstractDbData<?> dataAtStartPoint, AbstractDbData<?> dataAtEndPoint) {
        Change change;
        ArrayList<Change> changesList = new ArrayList<Change>();
        for (Row row : dataAtEndPoint.getRowsList()) {
            Row rowAtStartPoint = dataAtStartPoint.getRowFromPksValues(row.getPksValues());
            if (rowAtStartPoint != null) continue;
            change = Change.createCreationChange(dataAtEndPoint.getDataType(), dataName, row);
            changesList.add(change);
        }
        for (Row row : dataAtStartPoint.getRowsList()) {
            Row rowAtEndPoint = dataAtEndPoint.getRowFromPksValues(row.getPksValues());
            if (rowAtEndPoint == null) {
                change = Change.createDeletionChange(dataAtStartPoint.getDataType(), dataName, row);
                changesList.add(change);
                continue;
            }
            if (row.hasValues(rowAtEndPoint)) continue;
            change = Change.createModificationChange(dataAtStartPoint.getDataType(), dataName, row, rowAtEndPoint);
            changesList.add(change);
        }
        return changesList;
    }

    private List<Change> getChangesListWithoutPks(String dataName, AbstractDbData<?> dataAtStartPoint, AbstractDbData<?> dataAtEndPoint) {
        ArrayList<Change> changesList = new ArrayList<Change>();
        ArrayList<Row> rowsAtStartPointList = new ArrayList<Row>(dataAtStartPoint.getRowsList());
        for (Row rowAtEndPoint : dataAtEndPoint.getRowsList()) {
            int index = -1;
            int index1 = 0;
            for (Row rowAtStartPoint : rowsAtStartPointList) {
                if (rowAtEndPoint.hasValues(rowAtStartPoint)) {
                    index = index1;
                    break;
                }
                ++index1;
            }
            if (index == -1) {
                Change change = Change.createCreationChange(dataAtStartPoint.getDataType(), dataName, rowAtEndPoint);
                changesList.add(change);
                continue;
            }
            rowsAtStartPointList.remove(index);
        }
        ArrayList<Row> rowsAtEndPointList = new ArrayList<Row>(dataAtEndPoint.getRowsList());
        for (Row rowAtStartPoint : dataAtStartPoint.getRowsList()) {
            int index = -1;
            int index1 = 0;
            for (Row rowAtEndPoint : rowsAtEndPointList) {
                if (rowAtStartPoint.hasValues(rowAtEndPoint)) {
                    index = index1;
                    break;
                }
                ++index1;
            }
            if (index == -1) {
                Change change = Change.createDeletionChange(dataAtStartPoint.getDataType(), dataName, rowAtStartPoint);
                changesList.add(change);
                continue;
            }
            rowsAtEndPointList.remove(index);
        }
        return changesList;
    }

    private List<Change> getChangesList(String dataName, AbstractDbData<?> dataAtStartPoint, AbstractDbData<?> dataAtEndPoint) {
        if (dataAtStartPoint.getPksNameList().size() > 0) {
            return this.getChangesListWithPks(dataName, dataAtStartPoint, dataAtEndPoint);
        }
        return this.getChangesListWithoutPks(dataName, dataAtStartPoint, dataAtEndPoint);
    }

    public List<Change> getChangesList() {
        if (this.changesList == null) {
            if (this.requestAtEndPoint == null && this.tablesAtEndPointList == null) {
                throw new AssertJDBException("End point must be set before", new Object[0]);
            }
            if (this.requestAtEndPoint != null) {
                this.changesList = this.getChangesList(this.requestAtStartPoint.getRequest(), this.requestAtStartPoint, this.requestAtEndPoint);
            } else {
                this.changesList = new ArrayList<Change>();
                Iterator<Table> iteratorAtStartPoint = this.tablesAtStartPointList.iterator();
                Iterator<Table> iteratorAtEndPoint = this.tablesAtEndPointList.iterator();
                while (iteratorAtStartPoint.hasNext()) {
                    Table tableAtStartPoint = iteratorAtStartPoint.next();
                    Table tableAtEndPoint = iteratorAtEndPoint.next();
                    this.changesList.addAll(this.getChangesList(tableAtStartPoint.getName(), tableAtStartPoint, tableAtEndPoint));
                }
            }
        }
        Collections.sort(this.changesList, ChangeComparator.INSTANCE);
        return this.changesList;
    }

    public Changes getChangesOfTable(String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName must be not null");
        }
        Changes changes = this.createChangesFromThis();
        List<Change> changesList = this.getChangesList();
        if (this.tablesList != null) {
            for (Change change : changesList) {
                if (!tableName.equalsIgnoreCase(change.getDataName())) continue;
                changes.changesList.add(change);
            }
        }
        return changes;
    }

    public Changes getChangesOfType(ChangeType changeType) {
        if (changeType == null) {
            throw new NullPointerException("changeType must be not null");
        }
        Changes changes = this.createChangesFromThis();
        List<Change> changesList = this.getChangesList();
        for (Change change : changesList) {
            if (!changeType.equals((Object)change.getChangeType())) continue;
            changes.changesList.add(change);
        }
        return changes;
    }

    private Changes createChangesFromThis() {
        Changes changes = new Changes();
        if (this.request != null) {
            changes.request = Changes.getDuplicatedRequest(this.request);
        }
        if (this.tablesList != null) {
            changes.tablesList = new ArrayList<Table>();
            for (Table table : this.tablesList) {
                changes.tablesList.add(Changes.getDuplicatedTable(table));
            }
        }
        changes.changesList = new ArrayList<Change>();
        return changes;
    }
}

