/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.sql.DataSource;
import org.assertj.db.type.AbstractDbData;
import org.assertj.db.type.DataType;
import org.assertj.db.type.Source;

public class Request
extends AbstractDbData<Request> {
    private String request;
    private Object[] parameters;

    public Request() {
        super(Request.class, DataType.REQUEST);
    }

    public Request(Source source, String request, Object ... parameters) {
        super(Request.class, DataType.REQUEST, source);
        this.setRequest(request);
        this.parameters = parameters;
    }

    public Request(DataSource dataSource, String request, Object ... parameters) {
        super(Request.class, DataType.REQUEST, dataSource);
        this.setRequest(request);
        this.parameters = parameters;
    }

    @Override
    public String getRequest() {
        return this.request;
    }

    public Request setRequest(String request) {
        if (request == null) {
            throw new NullPointerException("request can not be null");
        }
        this.request = request;
        return this;
    }

    public Object[] getParameters() {
        if (this.parameters == null) {
            return null;
        }
        return (Object[])this.parameters.clone();
    }

    public Request setParameters(Object ... parameters) {
        this.parameters = parameters;
        return this;
    }

    public Request setPksName(String ... pksName) {
        ArrayList<String> pksNameList = new ArrayList<String>();
        pksNameList.addAll(Arrays.asList(pksName));
        super.setPksNameList(pksNameList);
        return this;
    }

    private void collectColumnsNameFromResultSet(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        ArrayList<String> columnsNameList = new ArrayList<String>();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            String columnName = resultSetMetaData.getColumnLabel(i);
            columnsNameList.add(columnName.toUpperCase());
        }
        this.setColumnsNameList(columnsNameList);
        this.controlIfAllThePksNameExistInTheColumns();
    }

    @Override
    protected void loadImpl(Connection connection) throws SQLException {
        if (this.request == null) {
            throw new NullPointerException("request can not be null");
        }
        try (PreparedStatement statement = connection.prepareStatement(this.request);){
            for (int i = 0; i < this.parameters.length; ++i) {
                statement.setObject(i + 1, this.parameters[i]);
            }
            try (ResultSet resultSet = statement.executeQuery();){
                this.collectColumnsNameFromResultSet(resultSet);
                this.collectRowsFromResultSet(resultSet);
            }
        }
    }
}

