/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.util.ArrayList;
import java.util.List;
import org.assertj.db.util.Values;

public class Row {
    private List<String> pksNameList;
    private final List<String> columnsNameList;
    private final List<Object> valuesList;

    Row(List<String> pksNameList, List<String> columnsNameList, List<Object> valuesList) {
        this.pksNameList = pksNameList;
        this.columnsNameList = columnsNameList;
        this.valuesList = valuesList;
    }

    public List<String> getPksNameList() {
        return this.pksNameList;
    }

    public List<Object> getPksValueList() {
        ArrayList<Object> pksValueList = new ArrayList<Object>();
        for (String name : this.pksNameList) {
            int index = this.columnsNameList.indexOf(name);
            Object value = this.valuesList.get(index);
            pksValueList.add(value);
        }
        return pksValueList;
    }

    void setPksNameList(List<String> pksNameList) {
        this.pksNameList = pksNameList;
    }

    public List<String> getColumnsNameList() {
        return this.columnsNameList;
    }

    public List<Object> getValuesList() {
        return this.valuesList;
    }

    public Object[] getPksValues() {
        ArrayList<Object> pksValuesList = new ArrayList<Object>();
        if (this.pksNameList != null) {
            for (String pkName : this.pksNameList) {
                int index = this.columnsNameList.indexOf(pkName);
                Object value = this.valuesList.get(index);
                pksValuesList.add(value);
            }
        }
        return pksValuesList.toArray(new Object[pksValuesList.size()]);
    }

    public boolean hasPksValuesEqualTo(Object[] pksValues) {
        Object[] pksValues1 = this.getPksValues();
        if (pksValues1.length != 0 && pksValues1.length == pksValues.length) {
            for (int index = 0; index < pksValues1.length; ++index) {
                if (Values.areEqual(pksValues1[index], pksValues[index])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasValues(Row row) {
        List<Object> valuesList = this.getValuesList();
        List<Object> rowValuesList = row.getValuesList();
        for (int index = 0; index < valuesList.size(); ++index) {
            Object rowValue;
            Object value = valuesList.get(index);
            if (Values.areEqual(value, rowValue = rowValuesList.get(index))) continue;
            return false;
        }
        return true;
    }

    public Object getColumnValue(int index) {
        return this.valuesList.get(index);
    }

    public Object getColumnValue(String columnName) {
        if (columnName == null) {
            throw new NullPointerException("Column name must be not null");
        }
        String name = columnName.toUpperCase();
        int index = this.getColumnsNameList().indexOf(name);
        if (index == -1) {
            return null;
        }
        return this.getColumnValue(index);
    }
}

