/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.assertj.db.type.AbstractDbData;
import org.assertj.db.type.DataType;
import org.assertj.db.type.Source;

public class Table
extends AbstractDbData<Table> {
    private String name;
    private String[] columnsToCheck;
    private String[] columnsToExclude;

    public Table() {
        super(Table.class, DataType.TABLE);
    }

    public Table(Source source, String name) {
        this(source, name, null, null);
    }

    public Table(Source source, String name, String[] columnsToCheck, String[] columnsToExclude) {
        super(Table.class, DataType.TABLE, source);
        this.setName(name);
        this.setColumnsToCheck(columnsToCheck);
        this.setColumnsToExclude(columnsToExclude);
    }

    public Table(DataSource dataSource, String name) {
        this(dataSource, name, null, null);
    }

    public Table(DataSource dataSource, String name, String[] columnsToCheck, String[] columnsToExclude) {
        super(Table.class, DataType.TABLE, dataSource);
        this.setName(name);
        this.setColumnsToCheck(columnsToCheck);
        this.setColumnsToExclude(columnsToExclude);
    }

    public String getName() {
        return this.name;
    }

    public Table setName(String name) {
        if (name == null) {
            throw new NullPointerException("name can not be null");
        }
        this.name = name;
        return this;
    }

    public String[] getColumnsToCheck() {
        if (this.columnsToCheck == null) {
            return null;
        }
        return (String[])this.columnsToCheck.clone();
    }

    public Table setColumnsToCheck(String[] columnsToCheck) {
        if (columnsToCheck != null) {
            this.columnsToCheck = new String[columnsToCheck.length];
            for (int index = 0; index < columnsToCheck.length; ++index) {
                String column = columnsToCheck[index];
                if (column == null) {
                    throw new NullPointerException("The name of the column can not be null");
                }
                this.columnsToCheck[index] = column.toUpperCase();
            }
        } else {
            this.columnsToCheck = null;
        }
        return this;
    }

    public String[] getColumnsToExclude() {
        if (this.columnsToExclude == null) {
            return null;
        }
        return (String[])this.columnsToExclude.clone();
    }

    public Table setColumnsToExclude(String[] columnsToExclude) {
        if (columnsToExclude != null) {
            this.columnsToExclude = new String[columnsToExclude.length];
            for (int index = 0; index < columnsToExclude.length; ++index) {
                String column = columnsToExclude[index];
                if (column == null) {
                    throw new NullPointerException("The name of the column can not be null");
                }
                this.columnsToExclude[index] = column.toUpperCase();
            }
        } else {
            this.columnsToExclude = null;
        }
        return this;
    }

    @Override
    public String getRequest() {
        if (this.name == null) {
            throw new NullPointerException("name can not be null");
        }
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        if (this.columnsToCheck == null) {
            stringBuilder.append("*");
        } else {
            for (String column : this.columnsToCheck) {
                if (stringBuilder.length() > 7) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(column);
            }
        }
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.name);
        return stringBuilder.toString();
    }

    private void collectColumnsNameFromResultSet(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        ArrayList<String> columnsNameList = new ArrayList<String>();
        List<String> columnsToExcludeList = null;
        if (this.columnsToExclude != null) {
            columnsToExcludeList = Arrays.asList(this.columnsToExclude);
        }
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            String columnName = resultSetMetaData.getColumnLabel(i).toUpperCase();
            if (columnsToExcludeList != null && columnsToExcludeList.contains(columnName)) continue;
            columnsNameList.add(columnName);
        }
        this.setColumnsNameList(columnsNameList);
    }

    private void collectPrimaryKeyName(Connection connection) throws SQLException {
        ArrayList<String> pksNameList = new ArrayList<String>();
        DatabaseMetaData metaData = connection.getMetaData();
        try (ResultSet resultSet = metaData.getPrimaryKeys(Table.getCatalog(connection), Table.getSchema(connection), this.name.toUpperCase());){
            while (resultSet.next()) {
                String columnName = resultSet.getString("COLUMN_NAME");
                if (this.getColumnsNameList().indexOf(columnName) == -1) continue;
                pksNameList.add(columnName);
            }
        }
        this.setPksNameList(pksNameList);
    }

    @Override
    protected void loadImpl(Connection connection) throws SQLException {
        if (this.name == null) {
            throw new NullPointerException("name can not be null");
        }
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(this.getRequest());){
            this.collectColumnsNameFromResultSet(resultSet);
            this.collectRowsFromResultSet(resultSet);
        }
        this.collectPrimaryKeyName(connection);
    }
}

