/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.assertj.db.type.DateTimeValue;
import org.assertj.db.type.DateValue;
import org.assertj.db.type.TimeValue;

public enum ValueType {
    BYTES,
    BOOLEAN,
    TEXT,
    DATE,
    TIME,
    DATE_TIME,
    NUMBER,
    NOT_IDENTIFIED;


    public static ValueType getType(Object value) {
        if (value instanceof byte[]) {
            return BYTES;
        }
        if (value instanceof Boolean) {
            return BOOLEAN;
        }
        if (value instanceof String) {
            return TEXT;
        }
        if (value instanceof Date) {
            return DATE;
        }
        if (value instanceof Time) {
            return TIME;
        }
        if (value instanceof Timestamp) {
            return DATE_TIME;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof BigDecimal) {
            return NUMBER;
        }
        return NOT_IDENTIFIED;
    }

    public static ValueType[] getPossibleTypesForComparison(Object expected) {
        if (expected instanceof byte[]) {
            return new ValueType[]{BYTES};
        }
        if (expected instanceof Boolean) {
            return new ValueType[]{BOOLEAN};
        }
        if (expected instanceof String) {
            return new ValueType[]{TEXT, NUMBER, DATE, TIME, DATE_TIME};
        }
        if (expected instanceof DateValue) {
            return new ValueType[]{DATE, DATE_TIME};
        }
        if (expected instanceof TimeValue) {
            return new ValueType[]{TIME};
        }
        if (expected instanceof DateTimeValue) {
            return new ValueType[]{DATE_TIME};
        }
        if (expected instanceof Number) {
            return new ValueType[]{NUMBER};
        }
        return new ValueType[]{NOT_IDENTIFIED};
    }
}

