/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.api.AbstractColumnAssert;
import org.assertj.db.api.AbstractColumnValueAssert;
import org.assertj.db.api.AbstractRowAssert;
import org.assertj.db.api.AbstractRowValueAssert;
import org.assertj.db.api.assertions.AssertOnNumberOfColumns;
import org.assertj.db.api.assertions.AssertOnNumberOfRows;
import org.assertj.db.api.assertions.impl.AssertionsOnNumberOfColumns;
import org.assertj.db.api.assertions.impl.AssertionsOnNumberOfRows;
import org.assertj.db.api.origin.OriginWithColumnsAndRows;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.AbstractDbData;
import org.assertj.db.type.Column;
import org.assertj.db.type.Row;

public abstract class AbstractDbAssert<D extends AbstractDbData<D>, A extends AbstractDbAssert<D, A, C, CV, R, RV>, C extends AbstractColumnAssert<D, A, C, CV, R, RV>, CV extends AbstractColumnValueAssert<D, A, C, CV, R, RV>, R extends AbstractRowAssert<D, A, C, CV, R, RV>, RV extends AbstractRowValueAssert<D, A, C, CV, R, RV>>
extends AbstractAssert<A>
implements OriginWithColumnsAndRows<C, R>,
AssertOnNumberOfColumns<A>,
AssertOnNumberOfRows<A> {
    private final D actual;
    private int indexNextRow;
    private final Class<R> rowAssertClass;
    private final Class<C> columnAssertClass;
    private int indexNextColumn;
    private final Map<Integer, R> rowsAssertMap = new HashMap<Integer, R>();
    private final Map<Integer, C> columnsAssertMap = new HashMap<Integer, C>();

    AbstractDbAssert(D actualValue, Class<A> selfType, Class<C> columnAssertType, Class<R> rowAssertType) {
        super(selfType);
        this.actual = actualValue;
        this.rowAssertClass = rowAssertType;
        this.columnAssertClass = columnAssertType;
    }

    protected Row getRow(int index) {
        int size = ((AbstractDbData)this.actual).getRowsList().size();
        if (index < 0 || index >= size) {
            throw new AssertJDBException("Index %s out of the limits [0, %s[", index, size);
        }
        Row row = ((AbstractDbData)this.actual).getRow(index);
        this.indexNextRow = index + 1;
        return row;
    }

    private R getRowAssertInstance(int index) {
        if (this.rowsAssertMap.containsKey(index)) {
            AbstractRowAssert rowAssert = (AbstractRowAssert)this.rowsAssertMap.get(index);
            this.indexNextRow = index + 1;
            return (R)rowAssert;
        }
        Row row = this.getRow(index);
        try {
            Constructor<R> constructor = this.rowAssertClass.getDeclaredConstructor(((AbstractDbAssert)this.myself).getClass(), Row.class);
            AbstractRowAssert instance = (AbstractRowAssert)constructor.newInstance(this, row);
            this.rowsAssertMap.put(index, instance);
            return (R)((AbstractRowAssert)instance.as("Row at index " + index + " of " + this.info.descriptionText(), new Object[0]));
        }
        catch (Exception e) {
            throw new AssertJDBException("There is an exception '" + e.getMessage() + "'\n\t in the instantiation of the assertion " + this.rowAssertClass.getName() + "\n\t on the row with " + ((AbstractDbAssert)this.myself).getClass() + ".\n " + "It is normally impossible.\n That means there is a big mistake in the development of AssertJDB.\n " + "Please write an issue for that if you meet this problem.", new Object[0]);
        }
    }

    @Override
    public R row() {
        return this.getRowAssertInstance(this.indexNextRow);
    }

    @Override
    public R row(int index) {
        return this.getRowAssertInstance(index);
    }

    protected Column getColumn(int index) {
        List<String> columnsNameList = ((AbstractDbData)this.actual).getColumnsNameList();
        int size = columnsNameList.size();
        if (index < 0 || index >= size) {
            throw new AssertJDBException("Index %s out of the limits [0, %s[", index, size);
        }
        Column column = ((AbstractDbData)this.actual).getColumn(index);
        this.indexNextColumn = index + 1;
        return column;
    }

    private C getColumnAssertInstance(int index) {
        if (this.columnsAssertMap.containsKey(index)) {
            AbstractColumnAssert columnAssert = (AbstractColumnAssert)this.columnsAssertMap.get(index);
            this.indexNextColumn = index + 1;
            return (C)columnAssert;
        }
        Column column = this.getColumn(index);
        List<String> columnsNameList = ((AbstractDbData)this.actual).getColumnsNameList();
        String columnName = columnsNameList.get(index);
        try {
            Constructor<C> constructor = this.columnAssertClass.getDeclaredConstructor(((AbstractDbAssert)this.myself).getClass(), Column.class);
            AbstractColumnAssert instance = (AbstractColumnAssert)constructor.newInstance(this, column);
            this.columnsAssertMap.put(index, instance);
            return (C)((AbstractColumnAssert)instance.as("Column at index " + index + " (column name : " + columnName + ") of " + this.info.descriptionText(), new Object[0]));
        }
        catch (Exception e) {
            throw new AssertJDBException("There is an exception '" + e.getMessage() + "'\n\t in the instantiation of the assertion " + this.columnAssertClass.getName() + "\n\t on the column with " + ((AbstractDbAssert)this.myself).getClass() + ".\n " + "It is normally impossible.\n That means there is a big mistake in the development of AssertJDB.\n " + "Please write an issue for that if you meet this problem.", new Object[0]);
        }
    }

    @Override
    public C column() {
        return this.getColumnAssertInstance(this.indexNextColumn);
    }

    @Override
    public C column(int index) {
        return this.getColumnAssertInstance(index);
    }

    @Override
    public C column(String columnName) {
        if (columnName == null) {
            throw new NullPointerException("Column name must be not null");
        }
        List<String> columnsNameList = ((AbstractDbData)this.actual).getColumnsNameList();
        int index = columnsNameList.indexOf(columnName.toUpperCase());
        if (index == -1) {
            throw new AssertJDBException("Column <%s> does not exist", columnName);
        }
        return this.getColumnAssertInstance(index);
    }

    @Override
    public A hasNumberOfRows(int expected) {
        List<Row> rowsList = ((AbstractDbData)this.actual).getRowsList();
        int size = rowsList.size();
        return (A)((AbstractDbAssert)AssertionsOnNumberOfRows.hasNumberOfRows(this.myself, this.info, size, expected));
    }

    @Override
    public A hasNumberOfColumns(int expected) {
        List<String> columnsNameList = ((AbstractDbData)this.actual).getColumnsNameList();
        int size = columnsNameList.size();
        return (A)((AbstractDbAssert)AssertionsOnNumberOfColumns.hasNumberOfColumns(this.myself, this.info, size, expected));
    }
}

