/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.db.api.AbstractAssertWithOriginWithColumnsAndRows;
import org.assertj.db.api.AbstractColumnAssert;
import org.assertj.db.api.AbstractColumnValueAssert;
import org.assertj.db.api.AbstractDbAssert;
import org.assertj.db.api.AbstractRowAssert;
import org.assertj.db.api.AbstractRowValueAssert;
import org.assertj.db.api.AbstractValueAssert;
import org.assertj.db.api.navigation.ToValue;
import org.assertj.db.api.origin.OriginWithColumnsAndRows;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.AbstractDbData;

public abstract class AbstractSubAssert<D extends AbstractDbData<D>, A extends AbstractDbAssert<D, A, C, CV, R, RV>, S extends AbstractSubAssert<D, A, S, V, C, CV, R, RV>, V extends AbstractValueAssert<D, A, S, V, C, CV, R, RV>, C extends AbstractColumnAssert<D, A, C, CV, R, RV>, CV extends AbstractColumnValueAssert<D, A, C, CV, R, RV>, R extends AbstractRowAssert<D, A, C, CV, R, RV>, RV extends AbstractRowValueAssert<D, A, C, CV, R, RV>>
extends AbstractAssertWithOriginWithColumnsAndRows<S, A, D, A, C, CV, R, RV>
implements OriginWithColumnsAndRows<C, R>,
ToValue<V> {
    private final Class<V> valueAssertClass;
    private int indexNextValue;
    private final Map<Integer, V> valuesAssertMap = new HashMap<Integer, V>();

    AbstractSubAssert(A originalDbAssert, Class<S> selfType, Class<V> valueAssertType) {
        super(selfType, originalDbAssert);
        this.valueAssertClass = valueAssertType;
    }

    protected V getValueAssertInstance(int index) {
        if (this.valuesAssertMap.containsKey(index)) {
            AbstractValueAssert valueAssert = (AbstractValueAssert)this.valuesAssertMap.get(index);
            this.indexNextValue = index + 1;
            return (V)valueAssert;
        }
        Object value = this.getValue(index);
        try {
            V instance = this.getValueAssertInstance(this.valueAssertClass, index, value);
            this.valuesAssertMap.put(index, instance);
            return instance;
        }
        catch (Exception e) {
            throw new AssertJDBException("There is an exception '" + e.getMessage() + "'\n\t in the instantiation of the assertion " + this.valueAssertClass.getName() + "\n\t on the value with " + ((AbstractSubAssert)this.myself).getClass() + ".\n " + "It is normally impossible.\n That means there is a big mistake in the development of AssertJDB.\n " + "Please write an issue for that if you meet this problem.", new Object[0]);
        }
    }

    protected abstract V getValueAssertInstance(Class<V> var1, int var2, Object var3) throws Exception;

    @Override
    public V value() {
        return this.getValueAssertInstance(this.indexNextValue);
    }

    @Override
    public V value(int index) {
        return this.getValueAssertInstance(index);
    }

    protected abstract List<Object> getValuesList();

    protected Object getValue(int index) {
        int size = this.getValuesList().size();
        if (index < 0 || index >= size) {
            throw new AssertJDBException("Index %s out of the limits [0, %s[", index, size);
        }
        Object object = this.getValuesList().get(index);
        this.indexNextValue = index + 1;
        return object;
    }
}

