/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.db.api.AbstractAssertWithOriginWithChanges;
import org.assertj.db.api.ChangeColumnAssert;
import org.assertj.db.api.ChangeRowAssert;
import org.assertj.db.api.ChangesAssert;
import org.assertj.db.api.assertions.AssertOnChangeType;
import org.assertj.db.api.assertions.AssertOnDataType;
import org.assertj.db.api.assertions.AssertOnModifiedColumns;
import org.assertj.db.api.assertions.AssertOnNumberOfColumns;
import org.assertj.db.api.assertions.AssertOnPrimaryKey;
import org.assertj.db.api.assertions.impl.AssertionsOnChangeType;
import org.assertj.db.api.assertions.impl.AssertionsOnDataType;
import org.assertj.db.api.assertions.impl.AssertionsOnModifiedColumns;
import org.assertj.db.api.assertions.impl.AssertionsOnNumberOfColumns;
import org.assertj.db.api.assertions.impl.AssertionsOnPrimaryKey;
import org.assertj.db.api.origin.OriginWithColumnsAndRowsFromChange;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.Change;
import org.assertj.db.type.ChangeType;
import org.assertj.db.type.DataType;
import org.assertj.db.type.Row;
import org.assertj.db.util.Changes;

public class ChangeAssert
extends AbstractAssertWithOriginWithChanges<ChangeAssert, ChangesAssert>
implements OriginWithColumnsAndRowsFromChange,
AssertOnDataType<ChangeAssert>,
AssertOnPrimaryKey<ChangeAssert>,
AssertOnChangeType<ChangeAssert>,
AssertOnModifiedColumns<ChangeAssert>,
AssertOnNumberOfColumns<ChangeAssert> {
    private final Change change;
    private ChangeRowAssert changeRowAssertAtStartPoint;
    private ChangeRowAssert changeRowAssertAtEndPoint;
    private int indexNextColumn;
    private final Map<Integer, ChangeColumnAssert> columnsAssertMap = new HashMap<Integer, ChangeColumnAssert>();

    ChangeAssert(ChangesAssert origin, Change change) {
        super(ChangeAssert.class, origin);
        this.change = change;
    }

    @Override
    public ChangeRowAssert rowAtStartPoint() {
        if (this.changeRowAssertAtStartPoint == null) {
            String string = "Row at start point of " + this.info.descriptionText();
            this.changeRowAssertAtStartPoint = (ChangeRowAssert)new ChangeRowAssert(this, this.change.getRowAtStartPoint()).as(string, new Object[0]);
        }
        return this.changeRowAssertAtStartPoint;
    }

    @Override
    public ChangeRowAssert rowAtEndPoint() {
        if (this.changeRowAssertAtEndPoint == null) {
            String string = "Row at end point of " + this.info.descriptionText();
            this.changeRowAssertAtEndPoint = (ChangeRowAssert)new ChangeRowAssert(this, this.change.getRowAtEndPoint()).as(string, new Object[0]);
        }
        return this.changeRowAssertAtEndPoint;
    }

    private ChangeColumnAssert getChangeColumnAssertInstance(int index) {
        if (this.columnsAssertMap.containsKey(index)) {
            ChangeColumnAssert changeColumnAssert = this.columnsAssertMap.get(index);
            this.indexNextColumn = index + 1;
            return changeColumnAssert;
        }
        int size = this.change.getColumnsNameList().size();
        if (index < 0 || index >= size) {
            throw new AssertJDBException("Index %s out of the limits [0, %s[", index, size);
        }
        Row rowAtStartPoint = this.change.getRowAtStartPoint();
        Row rowAtEndPoint = this.change.getRowAtEndPoint();
        Object valueAtStartPoint = null;
        Object valueAtEndPoint = null;
        if (rowAtStartPoint != null) {
            List<Object> valuesAtStartPoint = rowAtStartPoint.getValuesList();
            valueAtStartPoint = valuesAtStartPoint.get(index);
        }
        if (rowAtEndPoint != null) {
            List<Object> valuesAtEndPoint = rowAtEndPoint.getValuesList();
            valueAtEndPoint = valuesAtEndPoint.get(index);
        }
        List<String> columnsNameList = this.change.getColumnsNameList();
        String columnName = columnsNameList.get(index);
        ChangeColumnAssert instance = new ChangeColumnAssert(this, columnName, valueAtStartPoint, valueAtEndPoint);
        this.columnsAssertMap.put(index, instance);
        this.indexNextColumn = index + 1;
        return (ChangeColumnAssert)instance.as("Column at index " + index + " (column name : " + columnName + ") of " + this.info.descriptionText(), new Object[0]);
    }

    @Override
    public ChangeColumnAssert column() {
        return this.getChangeColumnAssertInstance(this.indexNextColumn);
    }

    @Override
    public ChangeColumnAssert column(int index) {
        return this.getChangeColumnAssertInstance(index);
    }

    @Override
    public ChangeColumnAssert column(String columnName) {
        if (columnName == null) {
            throw new NullPointerException("Column name must be not null");
        }
        List<String> columnsNameList = this.change.getColumnsNameList();
        int index = columnsNameList.indexOf(columnName.toUpperCase());
        if (index == -1) {
            throw new AssertJDBException("Column <%s> does not exist", columnName);
        }
        return this.getChangeColumnAssertInstance(index);
    }

    @Override
    public ChangeColumnAssert columnAmongTheModifiedOnes() {
        Integer[] indexesOfModifiedColumns;
        for (Integer indexModified : indexesOfModifiedColumns = Changes.getIndexesOfModifiedColumns(this.change)) {
            if (indexModified < this.indexNextColumn) continue;
            return this.getChangeColumnAssertInstance(indexModified);
        }
        throw new AssertJDBException("No more modified columns", new Object[0]);
    }

    @Override
    public ChangeColumnAssert columnAmongTheModifiedOnes(int index) {
        Integer[] indexesOfModifiedColumns = Changes.getIndexesOfModifiedColumns(this.change);
        int size = indexesOfModifiedColumns.length;
        if (index < 0 || index >= size) {
            throw new AssertJDBException("Index %s out of the limits of the modified columns [0, %s[", index, size);
        }
        int indexModified = indexesOfModifiedColumns[index];
        return this.getChangeColumnAssertInstance(indexModified);
    }

    @Override
    public ChangeColumnAssert columnAmongTheModifiedOnes(String columnName) {
        if (columnName == null) {
            throw new NullPointerException("Column name must be not null");
        }
        Integer[] indexesOfModifiedColumns = Changes.getIndexesOfModifiedColumns(this.change);
        List<String> columnsNameList = this.change.getColumnsNameList();
        for (Integer indexModified : indexesOfModifiedColumns) {
            String modifiedColumnName = columnsNameList.get(indexModified);
            if (!modifiedColumnName.equalsIgnoreCase(columnName)) continue;
            return this.getChangeColumnAssertInstance(indexModified);
        }
        throw new AssertJDBException("Column <%s> do not exist among the modified columns", columnName);
    }

    @Override
    public ChangeAssert isOnDataType(DataType expected) {
        return (ChangeAssert)AssertionsOnDataType.isOnDataType(this.myself, this.info, this.change, expected);
    }

    @Override
    public ChangeAssert isOnTable() {
        return (ChangeAssert)AssertionsOnDataType.isOnTable(this.myself, this.info, this.change);
    }

    @Override
    public ChangeAssert isOnRequest() {
        return (ChangeAssert)AssertionsOnDataType.isOnRequest(this.myself, this.info, this.change);
    }

    @Override
    public ChangeAssert isOnTable(String name) {
        return (ChangeAssert)AssertionsOnDataType.isOnTable(this.myself, this.info, this.change, name);
    }

    @Override
    public ChangeAssert hasPksNames(String ... names) {
        return (ChangeAssert)AssertionsOnPrimaryKey.hasPksNames(this.myself, this.info, this.change, names);
    }

    @Override
    public ChangeAssert hasPksValues(Object ... values) {
        return (ChangeAssert)AssertionsOnPrimaryKey.hasPksValues(this.myself, this.info, this.change, values);
    }

    @Override
    public ChangeAssert isOfType(ChangeType expected) {
        return (ChangeAssert)AssertionsOnChangeType.isOfType(this.myself, this.info, this.change, expected);
    }

    @Override
    public ChangeAssert isCreation() {
        return (ChangeAssert)AssertionsOnChangeType.isCreation(this.myself, this.info, this.change);
    }

    @Override
    public ChangeAssert isModification() {
        return (ChangeAssert)AssertionsOnChangeType.isModification(this.myself, this.info, this.change);
    }

    @Override
    public ChangeAssert isDeletion() {
        return (ChangeAssert)AssertionsOnChangeType.isDeletion(this.myself, this.info, this.change);
    }

    @Override
    public ChangeAssert hasNumberOfModifiedColumns(int number) {
        return (ChangeAssert)AssertionsOnModifiedColumns.hasNumberOfModifiedColumns(this.myself, this.info, this.change, number);
    }

    @Override
    public ChangeAssert hasModifiedColumns(Integer ... indexes) {
        return (ChangeAssert)AssertionsOnModifiedColumns.hasModifiedColumns(this.myself, this.info, this.change, indexes);
    }

    @Override
    public ChangeAssert hasModifiedColumns(String ... names) {
        return (ChangeAssert)AssertionsOnModifiedColumns.hasModifiedColumns(this.myself, this.info, this.change, names);
    }

    @Override
    public ChangeAssert hasNumberOfColumns(int expected) {
        return (ChangeAssert)AssertionsOnNumberOfColumns.hasNumberOfColumns(this.myself, this.info, this.change.getColumnsNameList().size(), expected);
    }

    public ChangesAssert returnToChanges() {
        return (ChangesAssert)this.returnToOrigin();
    }
}

