/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.api.assertions.impl.AssertionsOnColumnType;
import org.assertj.db.api.assertions.impl.AssertionsOnNumberOfRows;
import org.assertj.db.error.ShouldBeEqual;
import org.assertj.db.type.DateTimeValue;
import org.assertj.db.type.DateValue;
import org.assertj.db.type.TimeValue;
import org.assertj.db.type.ValueType;
import org.assertj.db.util.Values;

public class AssertionsOnColumnEquality {
    private static final Failures failures = Failures.instance();

    private AssertionsOnColumnEquality() {
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, List<Object> valuesList, Boolean ... expected) {
        AssertionsOnColumnType.isBoolean(assertion, info, valuesList, true);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        int index = 0;
        for (Object value : valuesList) {
            Boolean val = (Boolean)value;
            if (!Values.areEqual((Object)val, expected[index])) {
                throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index, val, expected[index]));
            }
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, List<Object> valuesList, Number ... expected) {
        AssertionsOnColumnType.isNumber(assertion, info, valuesList, true);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        int index = 0;
        for (Object value : valuesList) {
            Number val = (Number)value;
            if (!Values.areEqual((Object)val, expected[index])) {
                throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index, Values.getRepresentationFromValueInFrontOfExpected(val, expected[index]), expected[index]));
            }
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, List<Object> valuesList, byte[] ... expected) {
        AssertionsOnColumnType.isBytes(assertion, info, valuesList, true);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        int index = 0;
        for (Object value : valuesList) {
            if (!Values.areEqual(value, expected[index])) {
                throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index));
            }
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, List<Object> valuesList, String ... expected) {
        AssertionsOnColumnType.isOfAnyOfTypes(assertion, info, valuesList, ValueType.TEXT, ValueType.NUMBER, ValueType.DATE, ValueType.TIME, ValueType.DATE_TIME, ValueType.NOT_IDENTIFIED);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        int index = 0;
        for (Object value : valuesList) {
            if (!Values.areEqual(value, expected[index])) {
                throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index, Values.getRepresentationFromValueInFrontOfExpected(value, expected[index]), expected[index]));
            }
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, List<Object> valuesList, DateValue ... expected) {
        AssertionsOnColumnType.isOfAnyOfTypes(assertion, info, valuesList, ValueType.DATE, ValueType.DATE_TIME, ValueType.NOT_IDENTIFIED);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        int index = 0;
        for (Object value : valuesList) {
            if (!Values.areEqual(value, expected[index])) {
                throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index, Values.getRepresentationFromValueInFrontOfExpected(value, expected[index]), expected[index]));
            }
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, List<Object> valuesList, TimeValue ... expected) {
        AssertionsOnColumnType.isOfAnyOfTypes(assertion, info, valuesList, ValueType.TIME, ValueType.NOT_IDENTIFIED);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        int index = 0;
        for (Object value : valuesList) {
            if (!Values.areEqual(value, expected[index])) {
                throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index, Values.getRepresentationFromValueInFrontOfExpected(value, expected[index]), expected[index]));
            }
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, List<Object> valuesList, DateTimeValue ... expected) {
        AssertionsOnColumnType.isOfAnyOfTypes(assertion, info, valuesList, ValueType.DATE, ValueType.DATE_TIME, ValueType.NOT_IDENTIFIED);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        int index = 0;
        for (Object value : valuesList) {
            if (!Values.areEqual(value, expected[index])) {
                throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index, Values.getRepresentationFromValueInFrontOfExpected(value, expected[index]), expected[index]));
            }
            ++index;
        }
        return assertion;
    }
}

