/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldHaveName;

public class AssertionsOnColumnName {
    private static final Failures failures = Failures.instance();

    private AssertionsOnColumnName() {
    }

    public static <A extends AbstractAssert> A hasColumnName(A assertion, WritableAssertionInfo info, String columnName, String expected) {
        if (expected == null) {
            throw new NullPointerException("Column name must be not null");
        }
        if (!expected.equalsIgnoreCase(columnName)) {
            throw failures.failure((AssertionInfo)info, ShouldHaveName.shouldHaveName(columnName, expected));
        }
        return assertion;
    }
}

