/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.api.assertions.impl.AssertionsOnColumnOfChangeType;
import org.assertj.db.error.ShouldBeEqualWithEndPoint;
import org.assertj.db.error.ShouldBeEqualWithStartPoint;
import org.assertj.db.type.DateTimeValue;
import org.assertj.db.type.DateValue;
import org.assertj.db.type.TimeValue;
import org.assertj.db.type.ValueType;
import org.assertj.db.util.Values;

public class AssertionsOnColumnOfChangeEquality {
    private static final Failures failures = Failures.instance();

    private AssertionsOnColumnOfChangeEquality() {
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, Boolean expected) {
        AssertionsOnColumnOfChangeType.isBoolean(assertion, info, valueAtStartPoint, valueAtEndPoint, true);
        if (!Values.areEqual(valueAtStartPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(valueAtStartPoint, expected));
        }
        if (!Values.areEqual(valueAtEndPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(valueAtEndPoint, expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, Boolean expectedAtStartPoint, Boolean expectedAtEndPoint) {
        AssertionsOnColumnOfChangeType.isBoolean(assertion, info, valueAtStartPoint, valueAtEndPoint, true);
        if (!Values.areEqual(valueAtStartPoint, expectedAtStartPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(valueAtStartPoint, expectedAtStartPoint));
        }
        if (!Values.areEqual(valueAtEndPoint, expectedAtEndPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(valueAtEndPoint, expectedAtEndPoint));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, Number expected) {
        AssertionsOnColumnOfChangeType.isNumber(assertion, info, valueAtStartPoint, valueAtEndPoint, true);
        if (!Values.areEqual(valueAtStartPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expected), expected));
        }
        if (!Values.areEqual(valueAtEndPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expected), expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, Number expectedAtStartPoint, Number expectedAtEndPoint) {
        AssertionsOnColumnOfChangeType.isNumber(assertion, info, valueAtStartPoint, valueAtEndPoint, true);
        if (!Values.areEqual(valueAtStartPoint, expectedAtStartPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expectedAtStartPoint), expectedAtStartPoint));
        }
        if (!Values.areEqual(valueAtEndPoint, expectedAtEndPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expectedAtEndPoint), expectedAtEndPoint));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, byte[] expected) {
        AssertionsOnColumnOfChangeType.isBytes(assertion, info, valueAtStartPoint, valueAtEndPoint, true);
        if (!Values.areEqual(valueAtStartPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint());
        }
        if (!Values.areEqual(valueAtEndPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint());
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, byte[] expectedAtStartPoint, byte[] expectedAtEndPoint) {
        AssertionsOnColumnOfChangeType.isBytes(assertion, info, valueAtStartPoint, valueAtEndPoint, true);
        if (!Values.areEqual(valueAtStartPoint, expectedAtStartPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint());
        }
        if (!Values.areEqual(valueAtEndPoint, expectedAtEndPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint());
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, String expected) {
        AssertionsOnColumnOfChangeType.isOfAnyOfTypes(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.TEXT, ValueType.NUMBER, ValueType.DATE, ValueType.TIME, ValueType.DATE_TIME, ValueType.NOT_IDENTIFIED);
        if (!Values.areEqual(valueAtStartPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expected), expected));
        }
        if (!Values.areEqual(valueAtEndPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expected), expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, String expectedAtStartPoint, String expectedAtEndPoint) {
        AssertionsOnColumnOfChangeType.isOfAnyOfTypes(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.TEXT, ValueType.NUMBER, ValueType.DATE, ValueType.TIME, ValueType.DATE_TIME, ValueType.NOT_IDENTIFIED);
        if (!Values.areEqual(valueAtStartPoint, expectedAtStartPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expectedAtStartPoint), expectedAtStartPoint));
        }
        if (!Values.areEqual(valueAtEndPoint, expectedAtEndPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expectedAtEndPoint), expectedAtEndPoint));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, DateValue expected) {
        AssertionsOnColumnOfChangeType.isOfAnyOfTypes(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.DATE, ValueType.DATE_TIME, ValueType.NOT_IDENTIFIED);
        if (!Values.areEqual(valueAtStartPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expected), expected));
        }
        if (!Values.areEqual(valueAtEndPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expected), expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, DateValue expectedAtStartPoint, DateValue expectedAtEndPoint) {
        AssertionsOnColumnOfChangeType.isOfAnyOfTypes(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.DATE, ValueType.DATE_TIME, ValueType.NOT_IDENTIFIED);
        if (!Values.areEqual(valueAtStartPoint, expectedAtStartPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expectedAtStartPoint), expectedAtStartPoint));
        }
        if (!Values.areEqual(valueAtEndPoint, expectedAtEndPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expectedAtEndPoint), expectedAtEndPoint));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, TimeValue expected) {
        AssertionsOnColumnOfChangeType.isOfAnyOfTypes(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.TIME, ValueType.NOT_IDENTIFIED);
        if (!Values.areEqual(valueAtStartPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expected), expected));
        }
        if (!Values.areEqual(valueAtEndPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expected), expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, TimeValue expectedAtStartPoint, TimeValue expectedAtEndPoint) {
        AssertionsOnColumnOfChangeType.isOfAnyOfTypes(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.TIME, ValueType.NOT_IDENTIFIED);
        if (!Values.areEqual(valueAtStartPoint, expectedAtStartPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expectedAtStartPoint), expectedAtStartPoint));
        }
        if (!Values.areEqual(valueAtEndPoint, expectedAtEndPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expectedAtEndPoint), expectedAtEndPoint));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, DateTimeValue expected) {
        AssertionsOnColumnOfChangeType.isOfAnyOfTypes(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.DATE, ValueType.DATE_TIME, ValueType.NOT_IDENTIFIED);
        if (!Values.areEqual(valueAtStartPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expected), expected));
        }
        if (!Values.areEqual(valueAtEndPoint, expected)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expected), expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, DateTimeValue expectedAtStartPoint, DateTimeValue expectedAtEndPoint) {
        AssertionsOnColumnOfChangeType.isOfAnyOfTypes(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.DATE, ValueType.DATE_TIME, ValueType.NOT_IDENTIFIED);
        if (!Values.areEqual(valueAtStartPoint, expectedAtStartPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithStartPoint.shouldBeEqualWithStartPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtStartPoint, expectedAtStartPoint), expectedAtStartPoint));
        }
        if (!Values.areEqual(valueAtEndPoint, expectedAtEndPoint)) {
            throw failures.failure((AssertionInfo)info, ShouldBeEqualWithEndPoint.shouldBeEqualWithEndPoint(Values.getRepresentationFromValueInFrontOfExpected(valueAtEndPoint, expectedAtEndPoint), expectedAtEndPoint));
        }
        return assertion;
    }
}

