/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldBeValueTypeOfAnyWithEndPoint;
import org.assertj.db.error.ShouldBeValueTypeOfAnyWithStartPoint;
import org.assertj.db.error.ShouldBeValueTypeWithEndPoint;
import org.assertj.db.error.ShouldBeValueTypeWithStartPoint;
import org.assertj.db.type.ValueType;

public class AssertionsOnColumnOfChangeType {
    private static final Failures failures = Failures.instance();

    private AssertionsOnColumnOfChangeType() {
    }

    public static <A extends AbstractAssert> A isOfType(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, ValueType expected, boolean lenient) {
        if (lenient) {
            return AssertionsOnColumnOfChangeType.isOfAnyOfTypes(assertion, info, valueAtStartPoint, valueAtEndPoint, expected, ValueType.NOT_IDENTIFIED);
        }
        ValueType typeAtStartPoint = ValueType.getType(valueAtStartPoint);
        if (typeAtStartPoint != expected) {
            throw failures.failure((AssertionInfo)info, ShouldBeValueTypeWithStartPoint.shouldBeValueTypeWithStartPoint(valueAtStartPoint, expected, typeAtStartPoint));
        }
        ValueType typeAtEndPoint = ValueType.getType(valueAtEndPoint);
        if (typeAtEndPoint != expected) {
            throw failures.failure((AssertionInfo)info, ShouldBeValueTypeWithEndPoint.shouldBeValueTypeWithEndPoint(valueAtEndPoint, expected, typeAtEndPoint));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A isOfAnyOfTypes(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, ValueType ... expected) {
        ValueType typeAtStartPoint = ValueType.getType(valueAtStartPoint);
        boolean matched = false;
        for (ValueType valueType : expected) {
            if (typeAtStartPoint != valueType) continue;
            matched = true;
            break;
        }
        if (!matched) {
            throw failures.failure((AssertionInfo)info, ShouldBeValueTypeOfAnyWithStartPoint.shouldBeValueTypeOfAnyWithStartPoint(valueAtStartPoint, typeAtStartPoint, expected));
        }
        ValueType typeAtEndPoint = ValueType.getType(valueAtEndPoint);
        matched = false;
        for (ValueType valueType : expected) {
            if (typeAtEndPoint != valueType) continue;
            matched = true;
            break;
        }
        if (!matched) {
            throw failures.failure((AssertionInfo)info, ShouldBeValueTypeOfAnyWithEndPoint.shouldBeValueTypeOfAnyWithEndPoint(valueAtEndPoint, typeAtEndPoint, expected));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A isNumber(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, boolean lenient) {
        return AssertionsOnColumnOfChangeType.isOfType(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.NUMBER, lenient);
    }

    public static <A extends AbstractAssert> A isBoolean(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, boolean lenient) {
        return AssertionsOnColumnOfChangeType.isOfType(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.BOOLEAN, lenient);
    }

    public static <A extends AbstractAssert> A isDate(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, boolean lenient) {
        return AssertionsOnColumnOfChangeType.isOfType(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.DATE, lenient);
    }

    public static <A extends AbstractAssert> A isTime(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, boolean lenient) {
        return AssertionsOnColumnOfChangeType.isOfType(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.TIME, lenient);
    }

    public static <A extends AbstractAssert> A isDateTime(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, boolean lenient) {
        return AssertionsOnColumnOfChangeType.isOfType(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.DATE_TIME, lenient);
    }

    public static <A extends AbstractAssert> A isBytes(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, boolean lenient) {
        return AssertionsOnColumnOfChangeType.isOfType(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.BYTES, lenient);
    }

    public static <A extends AbstractAssert> A isText(A assertion, WritableAssertionInfo info, Object valueAtStartPoint, Object valueAtEndPoint, boolean lenient) {
        return AssertionsOnColumnOfChangeType.isOfType(assertion, info, valueAtStartPoint, valueAtEndPoint, ValueType.TEXT, lenient);
    }
}

