/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldHavePksNames;
import org.assertj.db.error.ShouldHavePksValues;
import org.assertj.db.type.Change;
import org.assertj.db.util.Values;

public class AssertionsOnPrimaryKey {
    private static final Failures failures = Failures.instance();

    private AssertionsOnPrimaryKey() {
    }

    public static <A extends AbstractAssert> A hasPksNames(A assertion, WritableAssertionInfo info, Change change, String ... names) {
        if (names == null) {
            throw new NullPointerException("Columns names must be not null");
        }
        List<String> pksNameList = change.getPksNameList();
        ArrayList<String> pksList = new ArrayList<String>(pksNameList);
        Collections.sort(pksList);
        ArrayList<String> namesList = new ArrayList<String>();
        for (String name : names) {
            if (name == null) {
                throw new NullPointerException("Column name must be not null");
            }
            namesList.add(name.toUpperCase());
        }
        Collections.sort(namesList);
        if (!namesList.equals(pksList)) {
            String[] pksNames = pksNameList.toArray(new String[pksNameList.size()]);
            throw failures.failure((AssertionInfo)info, ShouldHavePksNames.shouldHavePksNames(pksNames, names));
        }
        return assertion;
    }

    public static <A extends AbstractAssert> A hasPksValues(A assertion, WritableAssertionInfo info, Change change, Object ... values) {
        List<Object> pksValueList = change.getPksValueList();
        Object[] pksValues = pksValueList.toArray(new Object[pksValueList.size()]);
        if (values.length != pksValues.length) {
            Object[] representationsValues = Values.getRepresentationsFromValuesInFrontOfExpected(pksValues, values);
            throw failures.failure((AssertionInfo)info, ShouldHavePksValues.shouldHavePksValues(representationsValues, values));
        }
        int index = 0;
        for (Object pkValue : pksValueList) {
            Object value;
            if (!Values.areEqual(pkValue, value = values[index])) {
                Object[] representationsValues = Values.getRepresentationsFromValuesInFrontOfExpected(pksValues, values);
                throw failures.failure((AssertionInfo)info, ShouldHavePksValues.shouldHavePksValues(representationsValues, values));
            }
            ++index;
        }
        return assertion;
    }
}

