/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.api.assertions.impl.AssertionsOnNumberOfColumns;
import org.assertj.db.error.ShouldBeEqual;
import org.assertj.db.error.ShouldBeValueTypeOfAny;
import org.assertj.db.type.ValueType;
import org.assertj.db.util.Values;

public class AssertionsOnRowEquality {
    private static final Failures failures = Failures.instance();

    private AssertionsOnRowEquality() {
    }

    public static <A extends AbstractAssert> A hasValuesEqualTo(A assertion, WritableAssertionInfo info, List<Object> valuesList, Object ... expected) {
        AssertionsOnNumberOfColumns.hasNumberOfColumns(assertion, info, valuesList.size(), expected.length);
        int index = 0;
        for (Object value : valuesList) {
            ValueType[] possibleTypes = ValueType.getPossibleTypesForComparison(expected[index]);
            ValueType type = ValueType.getType(value);
            if (!Arrays.asList(possibleTypes).contains((Object)type)) {
                throw failures.failure((AssertionInfo)info, ShouldBeValueTypeOfAny.shouldBeValueTypeOfAny(index, value, type, possibleTypes));
            }
            if (!Values.areEqual(value, expected[index])) {
                if (ValueType.getType(value) == ValueType.BYTES) {
                    throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index));
                }
                throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index, Values.getRepresentationFromValueInFrontOfExpected(value, expected[index]), expected[index]));
            }
            ++index;
        }
        return assertion;
    }
}

