/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.AbstractDbElement;
import org.assertj.db.type.Column;
import org.assertj.db.type.DataType;
import org.assertj.db.type.Row;
import org.assertj.db.type.Source;
import org.assertj.db.util.RowComparator;

public abstract class AbstractDbData<D extends AbstractDbData<D>>
extends AbstractDbElement<D> {
    private final DataType dataType;
    private List<String> columnsNameList;
    private List<String> pksNameList;
    private List<Row> rowsList;
    private final Map<Integer, Column> columnsMap = new HashMap<Integer, Column>();

    AbstractDbData(Class<D> selfType, DataType dataType) {
        super(selfType);
        this.dataType = dataType;
    }

    AbstractDbData(Class<D> selfType, DataType dataType, Source source) {
        super(selfType, source);
        this.dataType = dataType;
    }

    AbstractDbData(Class<D> selfType, DataType dataType, DataSource dataSource) {
        super(selfType, dataSource);
        this.dataType = dataType;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public abstract String getRequest();

    private void load() {
        try (Connection connection = this.getConnection();){
            this.loadImpl(connection);
            Collections.sort(this.rowsList, RowComparator.INSTANCE);
            if (this.pksNameList == null) {
                this.pksNameList = new ArrayList<String>();
            }
        }
        catch (SQLException e) {
            throw new AssertJDBException(e);
        }
    }

    protected abstract void loadImpl(Connection var1) throws SQLException;

    protected void collectRowsFromResultSet(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        this.rowsList = new ArrayList<Row>();
        while (resultSet.next()) {
            ArrayList<Object> objectsList = new ArrayList<Object>();
            block6: for (String columnName : this.columnsNameList) {
                int index = this.columnsNameList.indexOf(columnName);
                int type = metaData.getColumnType(index + 1);
                switch (type) {
                    case 91: {
                        objectsList.add(resultSet.getDate(columnName));
                        continue block6;
                    }
                    case 92: {
                        objectsList.add(resultSet.getTime(columnName));
                        continue block6;
                    }
                    case 93: {
                        objectsList.add(resultSet.getTimestamp(columnName));
                        continue block6;
                    }
                }
                objectsList.add(resultSet.getObject(columnName));
            }
            this.rowsList.add(new Row(this.pksNameList, this.columnsNameList, objectsList));
        }
    }

    public List<String> getColumnsNameList() {
        if (this.columnsNameList == null) {
            this.load();
        }
        return this.columnsNameList;
    }

    protected void setColumnsNameList(List<String> columnsNameList) {
        this.columnsNameList = columnsNameList;
    }

    public List<String> getPksNameList() {
        if (this.pksNameList == null) {
            this.load();
        }
        return this.pksNameList;
    }

    protected void controlIfAllThePksNameExistInTheColumns() {
        if (this.pksNameList != null) {
            for (String pkName : this.pksNameList) {
                if (this.columnsNameList == null || this.columnsNameList.indexOf(pkName) != -1) continue;
                throw new AssertJDBException("Primary key %s do not exist in the columns %s", pkName, this.columnsNameList);
            }
        }
    }

    protected void setPksNameList(List<String> pksNameList) {
        this.pksNameList = new ArrayList<String>();
        for (String pkName : pksNameList) {
            String pkNameUp = pkName.toUpperCase();
            this.pksNameList.add(pkNameUp);
        }
        if (this.rowsList != null) {
            for (Row row : this.rowsList) {
                row.setPksNameList(this.pksNameList);
            }
        }
        this.controlIfAllThePksNameExistInTheColumns();
    }

    public List<Row> getRowsList() {
        if (this.rowsList == null) {
            this.load();
        }
        return this.rowsList;
    }

    public Column getColumn(int index) {
        if (this.columnsMap.containsKey(index)) {
            return this.columnsMap.get(index);
        }
        String name = this.getColumnsNameList().get(index);
        List<Object> valuesList = this.getValuesList(index);
        Column column = new Column(name, valuesList);
        this.columnsMap.put(index, column);
        return column;
    }

    public Row getRow(int index) {
        return this.getRowsList().get(index);
    }

    private List<Object> getValuesList(int index) {
        ArrayList<Object> valuesList = new ArrayList<Object>();
        for (Row row : this.getRowsList()) {
            valuesList.add(row.getColumnValue(index));
        }
        return valuesList;
    }

    public Row getRowFromPksValues(Object ... pksValues) {
        for (Row row : this.getRowsList()) {
            if (!row.hasPksValuesEqualTo(pksValues)) continue;
            return row;
        }
        return null;
    }
}

