/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.sql.Date;
import java.text.ParseException;
import java.util.Calendar;
import org.assertj.db.type.DateValueContainer;

public class DateValue
implements Comparable<DateValue>,
DateValueContainer {
    private final int dayOfTheMonth;
    private final int month;
    private final int year;
    private static final String DATE_FORMAT = "\\d\\d\\d\\d-\\d\\d-\\d\\d";

    public static DateValue of(int year, int month, int dayOfTheMonth) {
        return new DateValue(year, month, dayOfTheMonth);
    }

    public static DateValue parse(String date) throws ParseException {
        return new DateValue(date);
    }

    public static DateValue from(Date date) {
        return new DateValue(date);
    }

    public DateValue(int year, int month, int dayOfTheMonth) {
        this.dayOfTheMonth = dayOfTheMonth;
        this.month = month;
        this.year = year;
    }

    public DateValue(String date) throws ParseException {
        if (date == null) {
            throw new NullPointerException("date should be not null");
        }
        if (!date.matches(DATE_FORMAT)) {
            throw new ParseException("date must respect yyyy-mm-dd format", date.length());
        }
        this.year = Integer.parseInt(date.substring(0, 4));
        this.month = Integer.parseInt(date.substring(5, 7));
        this.dayOfTheMonth = Integer.parseInt(date.substring(8));
    }

    public DateValue(Date date) {
        if (date == null) {
            throw new NullPointerException("date should be not null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        this.dayOfTheMonth = calendar.get(5);
        this.month = calendar.get(2) + 1;
        this.year = calendar.get(1);
    }

    @Override
    public DateValue getDate() {
        return this;
    }

    @Override
    public boolean isMidnight() {
        return true;
    }

    public int getDayOfTheMonth() {
        return this.dayOfTheMonth;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public String toString() {
        return String.format("%4d-%02d-%02d", this.year, this.month, this.dayOfTheMonth);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DateValue) {
            DateValue dateValue = (DateValue)obj;
            return this.year == dateValue.year && this.month == dateValue.month && this.dayOfTheMonth == dateValue.dayOfTheMonth;
        }
        if (obj instanceof DateValueContainer) {
            DateValueContainer value = (DateValueContainer)obj;
            return this.equals(value.getDate()) && value.isMidnight();
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dayOfTheMonth;
        result = 31 * result + this.month;
        result = 31 * result + this.year;
        return result;
    }

    @Override
    public int compareTo(DateValue other) {
        if (this.year < other.year) {
            return -1;
        }
        if (this.year > other.year) {
            return 1;
        }
        if (this.month < other.month) {
            return -1;
        }
        if (this.month > other.month) {
            return 1;
        }
        if (this.dayOfTheMonth < other.dayOfTheMonth) {
            return -1;
        }
        if (this.dayOfTheMonth > other.dayOfTheMonth) {
            return 1;
        }
        return 0;
    }

    public boolean isBefore(DateValue date) {
        return this.compareTo(date) == -1;
    }

    public boolean isAfter(DateValue date) {
        return this.compareTo(date) == 1;
    }
}

