/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.sql.Time;
import java.text.ParseException;
import java.util.Calendar;

public class TimeValue
implements Comparable<TimeValue> {
    private final int hour;
    private final int minutes;
    private final int seconds;
    private final int nanoSeconds;
    private static final String TIME_FORMAT = "\\d\\d:\\d\\d";
    private static final String TIME_FORMAT_WITH_SECONDS = "\\d\\d:\\d\\d:\\d\\d";
    private static final String TIME_FORMAT_WITH_NANO = "\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d\\d\\d\\d\\d\\d\\d";

    public static TimeValue of(int hour, int minutes, int seconds, int nanoSeconds) {
        return new TimeValue(hour, minutes, seconds, nanoSeconds);
    }

    public static TimeValue of(int hour, int minutes, int seconds) {
        return new TimeValue(hour, minutes, seconds);
    }

    public static TimeValue of(int hour, int minutes) {
        return new TimeValue(hour, minutes);
    }

    public static TimeValue parse(String time) throws ParseException {
        return new TimeValue(time);
    }

    public static TimeValue from(Time time) {
        return new TimeValue(time);
    }

    public TimeValue(int hour, int minutes, int seconds, int nanoSeconds) {
        this.hour = hour;
        this.minutes = minutes;
        this.seconds = seconds;
        this.nanoSeconds = nanoSeconds;
    }

    public TimeValue(int hour, int minutes, int seconds) {
        this(hour, minutes, seconds, 0);
    }

    public TimeValue(int hour, int minutes) {
        this(hour, minutes, 0, 0);
    }

    public TimeValue(String time) throws ParseException {
        if (time == null) {
            throw new NullPointerException("time should be not null");
        }
        if (time.matches(TIME_FORMAT)) {
            this.hour = Integer.parseInt(time.substring(0, 2));
            this.minutes = Integer.parseInt(time.substring(3));
            this.seconds = 0;
            this.nanoSeconds = 0;
        } else if (time.matches(TIME_FORMAT_WITH_SECONDS)) {
            this.hour = Integer.parseInt(time.substring(0, 2));
            this.minutes = Integer.parseInt(time.substring(3, 5));
            this.seconds = Integer.parseInt(time.substring(6));
            this.nanoSeconds = 0;
        } else if (time.matches(TIME_FORMAT_WITH_NANO)) {
            this.hour = Integer.parseInt(time.substring(0, 2));
            this.minutes = Integer.parseInt(time.substring(3, 5));
            this.seconds = Integer.parseInt(time.substring(6, 8));
            this.nanoSeconds = Integer.parseInt(time.substring(9));
        } else {
            throw new ParseException("time must respect hh:mm, hh:mm:ss or hh:mm:ss.nnnnnnnnn format", time.length());
        }
    }

    public TimeValue(Time time) {
        if (time == null) {
            throw new NullPointerException("time should be not null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time.getTime());
        this.hour = calendar.get(11);
        this.minutes = calendar.get(12);
        this.seconds = calendar.get(13);
        this.nanoSeconds = 0;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getNanoSeconds() {
        return this.nanoSeconds;
    }

    public String toString() {
        return String.format("%02d:%02d:%02d.%09d", this.hour, this.minutes, this.seconds, this.nanoSeconds);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeValue) {
            TimeValue timeValue = (TimeValue)obj;
            return this.hour == timeValue.hour && this.minutes == timeValue.minutes && this.seconds == timeValue.seconds && this.nanoSeconds == timeValue.nanoSeconds;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.hour;
        result = 31 * result + this.minutes;
        result = 31 * result + this.nanoSeconds;
        result = 31 * result + this.seconds;
        return result;
    }

    @Override
    public int compareTo(TimeValue other) {
        if (this.hour < other.hour) {
            return -1;
        }
        if (this.hour > other.hour) {
            return 1;
        }
        if (this.minutes < other.minutes) {
            return -1;
        }
        if (this.minutes > other.minutes) {
            return 1;
        }
        if (this.seconds < other.seconds) {
            return -1;
        }
        if (this.seconds > other.seconds) {
            return 1;
        }
        if (this.nanoSeconds < other.nanoSeconds) {
            return -1;
        }
        if (this.nanoSeconds > other.nanoSeconds) {
            return 1;
        }
        return 0;
    }

    public boolean isBefore(TimeValue time) {
        return this.compareTo(time) == -1;
    }

    public boolean isAfter(TimeValue time) {
        return this.compareTo(time) == 1;
    }
}

